/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.CreditCodeUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    public static final Pattern GENERAL = PatternPool.GENERAL;
    public static final Pattern NUMBERS = PatternPool.NUMBERS;
    public static final Pattern GROUP_VAR = PatternPool.GROUP_VAR;
    public static final Pattern IPV4 = PatternPool.IPV4;
    public static final Pattern IPV6 = PatternPool.IPV6;
    public static final Pattern MONEY = PatternPool.MONEY;
    public static final Pattern EMAIL = PatternPool.EMAIL;
    public static final Pattern EMAIL_WITH_CHINESE = PatternPool.EMAIL_WITH_CHINESE;
    public static final Pattern MOBILE = PatternPool.MOBILE;
    public static final Pattern CITIZEN_ID = PatternPool.CITIZEN_ID;
    public static final Pattern ZIP_CODE = PatternPool.ZIP_CODE;
    public static final Pattern BIRTHDAY = PatternPool.BIRTHDAY;
    public static final Pattern URL = PatternPool.URL;
    public static final Pattern URL_HTTP = PatternPool.URL_HTTP;
    public static final Pattern GENERAL_WITH_CHINESE = PatternPool.GENERAL_WITH_CHINESE;
    public static final Pattern UUID = PatternPool.UUID;
    public static final Pattern UUID_SIMPLE = PatternPool.UUID_SIMPLE;
    public static final Pattern PLATE_NUMBER = PatternPool.PLATE_NUMBER;
    public static final Pattern CAR_VIN = PatternPool.CAR_VIN;
    public static final Pattern CAR_DRIVING_LICENCE = PatternPool.CAR_DRIVING_LICENCE;

    public static boolean isTrue(boolean value) {
        return value;
    }

    public static boolean isFalse(boolean value) {
        return !value;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean validateTrue(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isFalse(value)) {
            void var2_2;
            void var1_1;
            throw new ValidateException((String)var1_1, (Object[])var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean validateFalse(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isTrue(value)) {
            void var2_2;
            void var1_1;
            throw new ValidateException((String)var1_1, (Object[])var2_2);
        }
        return false;
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return value != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T validateNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNotNull(value)) {
            void var2_2;
            void var1_1;
            throw new ValidateException((String)var1_1, (Object[])var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T validateNotNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        T t;
        if (Validator.isNull(value)) {
            void var2_2;
            void var1_1;
            throw new ValidateException((String)var1_1, (Object[])var2_2);
        }
        return t;
    }

    public static boolean isEmpty(Object value) {
        Object object;
        return value == null || value instanceof String && StrUtil.isEmpty((String)object);
    }

    public static boolean isNotEmpty(Object value) {
        Object object;
        return false == Validator.isEmpty(object);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T validateEmpty(T value, String errorMsg) throws ValidateException {
        T t;
        if (Validator.isNotEmpty(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T validateNotEmpty(T value, String errorMsg) throws ValidateException {
        T t;
        if (Validator.isEmpty(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equal(Object t1, Object t2) {
        void var1_1;
        return ObjectUtil.equal(t1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Object object;
        void var1_1;
        if (!Validator.equal(t1, var1_1)) {
            void var2_2;
            throw new ValidateException((String)var2_2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        void var1_1;
        if (Validator.equal(t1, var1_1)) {
            void var2_2;
            throw new ValidateException((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        void var2_2;
        void var1_1;
        Object object;
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(object, var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        void var2_2;
        void var1_1;
        Object object;
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(object, var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateMatchRegex(String regex, T value, String errorMsg) throws ValidateException {
        void var1_1;
        String string;
        if (!Validator.isMatchRegex(string, value)) {
            void var2_2;
            throw new ValidateException((String)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        void var1_1;
        return ReUtil.isMatch(pattern, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMatchRegex(String regex, CharSequence value) {
        void var1_1;
        return ReUtil.isMatch(regex, (CharSequence)var1_1);
    }

    public static boolean isGeneral(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(GENERAL, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateGeneral(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isGeneral(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGeneral(CharSequence value, int min, int max) {
        CharSequence charSequence;
        void var3_3;
        void var2_2;
        if (min < 0) {
            min = 0;
        }
        String reg = "^\\w{" + min + "," + max + "}$";
        if (var2_2 <= 0) {
            void var1_1;
            reg = "^\\w{" + (int)var1_1 + ",}$";
        }
        return Validator.isMatchRegex((String)var3_3, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateGeneral(T value, int min, int max, String errorMsg) throws ValidateException {
        T t;
        void var2_2;
        void var1_1;
        if (!Validator.isGeneral(value, (int)var1_1, (int)var2_2)) {
            void var3_3;
            throw new ValidateException((String)var3_3);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGeneral(CharSequence value, int min) {
        void var1_1;
        return Validator.isGeneral(value, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateGeneral(T value, int min, String errorMsg) throws ValidateException {
        void var2_2;
        void var1_1;
        return Validator.validateGeneral(value, (int)var1_1, 0, (String)var2_2);
    }

    public static boolean isLetter(CharSequence value) {
        return StrUtil.isAllCharMatch(value, Character::isLetter);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateLetter(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isLetter(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isUpperCase(CharSequence value) {
        return StrUtil.isAllCharMatch(value, Character::isUpperCase);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateUpperCase(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isUpperCase(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isLowerCase(CharSequence value) {
        return StrUtil.isAllCharMatch(value, Character::isLowerCase);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateLowerCase(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isLowerCase(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isNumber(CharSequence value) {
        return NumberUtil.isNumber(value);
    }

    public static boolean hasNumber(CharSequence value) {
        CharSequence charSequence;
        return ReUtil.contains(PatternPool.NUMBERS, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static String validateNumber(String value, String errorMsg) throws ValidateException {
        String string;
        if (!Validator.isNumber(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return string;
    }

    public static boolean isWord(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PatternPool.WORD, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateWord(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isWord(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isMoney(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(MONEY, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateMoney(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isMoney(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isZipCode(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(ZIP_CODE, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateZipCode(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isZipCode(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isEmail(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(EMAIL, charSequence);
    }

    public static boolean isEmail(CharSequence value, boolean includChinese) {
        CharSequence charSequence;
        if (includChinese) {
            return Validator.isMatchRegex(EMAIL_WITH_CHINESE, value);
        }
        return Validator.isEmail(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateEmail(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isEmail(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isMobile(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(MOBILE, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateMobile(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isMobile(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isCitizenId(CharSequence value) {
        return IdcardUtil.isValidCard(String.valueOf(value));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateCitizenIdNumber(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isCitizenId(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBirthday(int year, int month, int day) {
        void var1_1;
        void var3_3;
        int thisYear = DateUtil.thisYear();
        if (year < 1900 || year > var3_3) {
            return false;
        }
        if (month <= 0 || month > 12) {
            return false;
        }
        if (day <= 0 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (var1_1 == 2) {
            int n;
            void var2_2;
            return day < 29 || var2_2 == 29 && DateUtil.isLeapYear(n);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBirthday(CharSequence value) {
        Matcher matcher = BIRTHDAY.matcher(value);
        if (matcher.find()) {
            void var0_1;
            void var2_3;
            void var1_2;
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday((int)var1_2, (int)var2_3, (int)var0_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateBirthday(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isBirthday(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isIpv4(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(IPV4, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateIpv4(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isIpv4(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isIpv6(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(IPV6, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateIpv6(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isIpv6(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isMac(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PatternPool.MAC_ADDRESS, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateMac(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isMac(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isPlateNumber(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PLATE_NUMBER, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validatePlateNumber(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isPlateNumber(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isUrl(CharSequence value) {
        if (StrUtil.isBlank(value)) {
            return false;
        }
        try {
            CharSequence charSequence;
            new URL(StrUtil.str(charSequence));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateUrl(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isUrl(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isChinese(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PatternPool.CHINESES, charSequence);
    }

    public static boolean hasChinese(CharSequence value) {
        CharSequence charSequence;
        return ReUtil.contains("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+", charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateChinese(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isChinese(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isGeneralWithChinese(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(GENERAL_WITH_CHINESE, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateGeneralWithChinese(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isGeneralWithChinese(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isUUID(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(UUID, value) || Validator.isMatchRegex(UUID_SIMPLE, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateUUID(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isUUID(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isHex(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PatternPool.HEX, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateHex(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isHex(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBetween(Number value, Number min, Number max) {
        void var2_2;
        void var3_3;
        void var1_1;
        double d;
        Number number;
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = number.doubleValue();
        return d >= var1_1.doubleValue() && var3_3 <= var2_2.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static void validateBetween(Number value, Number min, Number max, String errorMsg) throws ValidateException {
        void var2_2;
        void var1_1;
        Number number;
        if (!Validator.isBetween(number, (Number)var1_1, (Number)var2_2)) {
            void var3_3;
            throw new ValidateException((String)var3_3);
        }
    }

    public static boolean isCreditCode(CharSequence creditCode) {
        return CreditCodeUtil.isCreditCode(creditCode);
    }

    public static boolean isCarVin(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(CAR_VIN, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateCarVin(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isCarVin(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    public static boolean isCarDrivingLicence(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(CAR_DRIVING_LICENCE, charSequence);
    }

    public static boolean isChineseName(CharSequence value) {
        CharSequence charSequence;
        return Validator.isMatchRegex(PatternPool.CHINESE_NAME, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validateCarDrivingLicence(T value, String errorMsg) throws ValidateException {
        T t;
        if (!Validator.isCarDrivingLicence(value)) {
            void var1_1;
            throw new ValidateException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static void checkIndexLimit(int index, int size) {
        if (index > (size + 1) * 10) {
            void var1_1;
            int n;
            throw new ValidateException("Index [{}] is too large for size: [{}]", n, (int)var1_1);
        }
    }
}

