/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -1185015143654744140L;
    private final long mostSigBits;
    private final long leastSigBits;

    /*
     * WARNING - void declaration
     */
    private UUID(byte[] data) {
        void var2_2;
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = var2_2;
        this.leastSigBits = lsb;
    }

    /*
     * WARNING - void declaration
     */
    public UUID(long mostSigBits, long leastSigBits) {
        void var3_2;
        void var1_1;
        this.mostSigBits = var1_1;
        this.leastSigBits = var3_2;
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }

    /*
     * WARNING - void declaration
     */
    public static UUID randomUUID(boolean isSecure) {
        void var1_2;
        void var0_1;
        Random ng = isSecure ? Holder.NUMBER_GENERATOR : RandomUtil.getRandom();
        byte[] randomBytes = new byte[16];
        var0_1.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return new UUID((byte[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static UUID nameUUIDFromBytes(byte[] name) {
        byte[] byArray;
        void var1_1;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported");
        }
        byte[] byArray2 = var1_1.digest(name);
        byte[] md5Bytes = byArray2;
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        return new UUID(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static UUID fromString(String name) {
        void var2_3;
        void var1_1;
        String[] components = name.split("-");
        if (components.length != 5) {
            String string;
            throw new IllegalArgumentException("Invalid UUID string: " + string);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long i = Long.decode(components[0]);
        i <<= 16;
        i |= Long.decode(components[1]).longValue();
        long mostSigBits = (i <<= 16) | Long.decode(components[2]);
        long l = Long.decode(components[3]);
        long leastSigBits = (l <<= 48) | Long.decode((String)var1_1[4]);
        return new UUID((long)var2_3, leastSigBits);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return (int)(this.mostSigBits >> 12 & 0xFL);
    }

    public int variant() {
        return (int)(this.leastSigBits >>> (int)(64L - (this.leastSigBits >>> 62)) & this.leastSigBits >> 63);
    }

    public long timestamp() throws UnsupportedOperationException {
        this.checkTimeBase();
        return (this.mostSigBits & 0xFFFL) << 48 | (this.mostSigBits >> 16 & 0xFFFFL) << 32 | this.mostSigBits >>> 32;
    }

    public int clockSequence() throws UnsupportedOperationException {
        this.checkTimeBase();
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long node() throws UnsupportedOperationException {
        this.checkTimeBase();
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(boolean isSimple) {
        void var2_2;
        void var1_1;
        StringBuilder builder = StrUtil.builder(isSimple ? 32 : 36);
        builder.append(UUID.digits(this.mostSigBits >> 32, 8));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.mostSigBits >> 16, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.mostSigBits, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.leastSigBits >> 48, 4));
        if (var1_1 == false) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.leastSigBits, 12));
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        long hilo = this.mostSigBits ^ this.leastSigBits;
        return (int)(hilo >> 32) ^ (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == null || obj.getClass() != UUID.class) {
            return false;
        }
        UUID id = (UUID)obj;
        return this.mostSigBits == id.mostSigBits && this.leastSigBits == var1_1.leastSigBits;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(UUID val) {
        void var2_2;
        int compare = Long.compare(this.mostSigBits, val.mostSigBits);
        if (compare == 0) {
            void var1_1;
            compare = Long.compare(this.leastSigBits, var1_1.leastSigBits);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static String digits(long val, int digits) {
        void var3_2;
        long l;
        void var2_1;
        long hi = 1L << (var2_1 << 2);
        return Long.toHexString(hi | l & var3_2 - 1L).substring(1);
    }

    private void checkTimeBase() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
    }

    private static class Holder {
        static final SecureRandom NUMBER_GENERATOR = RandomUtil.getSecureRandom();

        private Holder() {
        }
    }
}

