/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.SystemClock;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static long DEFAULT_TWEPOCH = 1288834974657L;
    public static long DEFAULT_TIME_OFFSET = 2000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long timeOffset;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(IdUtil.getWorkerId(IdUtil.getDataCenterId(31L), 31L));
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(long workerId) {
        this((long)var1_1, IdUtil.getDataCenterId(31L));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(long workerId, long dataCenterId) {
        this((long)var1_1, (long)var3_2, false);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, (long)var1_1, (long)var3_2, isUseSystemClock);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this((Date)var1_1, (long)var2_2, dataCenterId, isUseSystemClock, DEFAULT_TIME_OFFSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset) {
        this((Date)var1_1, (long)var2_2, dataCenterId, isUseSystemClock, timeOffset, 0L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset, long randomSequenceLimit) {
        void var2_2;
        void var1_1;
        this.twepoch = epochDate != null ? var1_1.getTime() : DEFAULT_TWEPOCH;
        this.workerId = Assert.checkBetween((long)var2_2, 0L, 31L);
        this.dataCenterId = Assert.checkBetween(dataCenterId, 0L, 31L);
        this.useSystemClock = isUseSystemClock;
        this.timeOffset = timeOffset;
        this.randomSequenceLimit = Assert.checkBetween(randomSequenceLimit, 0L, 4095L);
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    /*
     * WARNING - void declaration
     */
    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd) {
        void var3_2;
        void var1_1;
        return this.getIdScopeByTimestamp((long)var1_1, (long)var3_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd, boolean ignoreCenterAndWorker) {
        void var3_2;
        long startTimeMinId = timestampStart - this.twepoch << 22;
        void endTimeMinId = var3_2 - this.twepoch << 22;
        if (ignoreCenterAndWorker) {
            void endId = endTimeMinId | 0x3FFFFFL;
            return Pair.of(startTimeMinId, (long)endId);
        }
        long startId = startTimeMinId | this.dataCenterId << 17 | this.workerId << 12;
        void endId = endTimeMinId | this.dataCenterId << 17 | this.workerId << 12 | 0xFFFL;
        return Pair.of(startId, (long)endId);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized long nextId() {
        void var1_1;
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - timestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            void var3_2;
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                Snowflake snowflake = this;
                timestamp = snowflake.tilNextMillis(snowflake.lastTimestamp);
            }
            this.sequence = var3_2;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? RandomUtil.randomLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return (long)(var1_1 - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence);
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    /*
     * WARNING - void declaration
     */
    private long tilNextMillis(long lastTimestamp) {
        void var3_2;
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            void var1_1;
            throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", (long)(var1_1 - timestamp)));
        }
        return (long)var3_2;
    }

    private long genTime() {
        if (this.useSystemClock) {
            return SystemClock.now();
        }
        return System.currentTimeMillis();
    }
}

