/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.TransIter;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutableObj;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.map.WeakConcurrentMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public class SimpleCache<K, V>
implements Serializable,
Iterable<Map.Entry<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Map<Mutable<K>, V> rawMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<K, Lock> keyLockMap = new SafeConcurrentHashMap<K, Lock>();

    public SimpleCache() {
        this(new WeakConcurrentMap());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleCache(Map<Mutable<K>, V> initMap) {
        void var1_1;
        this.rawMap = var1_1;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v;
            v = this.rawMap.get(MutableObj.of(v));
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public V get(K key, Func0<V> supplier) {
        void var2_2;
        void var1_1;
        return this.get(var1_1, null, (Func0<V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public V get(K key, Predicate<V> validPredicate, Func0<V> supplier) {
        Object v = this.get(key);
        if (validPredicate != null && v != null && !validPredicate.test(v)) {
            v = null;
        }
        if (v == null && supplier != null) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
            keyLock.lock();
            try {
                Exception exception;
                v = this.get(key);
                if (v == null || validPredicate != null && !exception.test(v)) {
                    try {
                        void var3_4;
                        v = var3_4.call();
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        throw ExceptionUtil.wrapRuntime(exception2);
                    }
                    this.put(key, v);
                }
                keyLock.unlock();
                this.keyLockMap.remove(key);
            }
            catch (Throwable throwable) {
                void var1_1;
                keyLock.unlock();
                this.keyLockMap.remove(var1_1);
                throw throwable;
            }
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    public V put(K key, V value) {
        void var2_3;
        this.lock.writeLock().lock();
        try {
            void var1_1;
            this.rawMap.put(MutableObj.of(var1_1), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return var2_3;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v;
            v = this.rawMap.remove(MutableObj.of(v));
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.rawMap.clear();
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new TransIter<Map.Entry, Map.Entry>(this.rawMap.entrySet().iterator(), entry -> {
            void var1_1;
            return new Map.Entry<K, V>(this, (Map.Entry)var1_1){
                final /* synthetic */ Map.Entry val$entry;
                final /* synthetic */ SimpleCache this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$entry = entry;
                }

                @Override
                public K getKey() {
                    return ((Mutable)this.val$entry.getKey()).get();
                }

                @Override
                public V getValue() {
                    return this.val$entry.getValue();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public V setValue(V value) {
                    void var1_1;
                    return this.val$entry.setValue(var1_1);
                }
            };
        });
    }
}

