/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.lock.NoLock;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Range<T>
implements Serializable,
Iterable<T>,
Iterator<T> {
    private static final long serialVersionUID = 1L;
    private Lock lock = new ReentrantLock();
    private final T start;
    private final T end;
    private T next;
    private final Stepper<T> stepper;
    private int index = 0;
    private final boolean includeStart;
    private final boolean includeEnd;

    /*
     * WARNING - void declaration
     */
    public Range(T start, Stepper<T> stepper) {
        this(var1_1, null, (Stepper<Object>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Range(T start, T end, Stepper<T> stepper) {
        this(var1_1, var2_2, (Stepper<void>)var3_3, true, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Range(T start, T end, Stepper<T> stepper, boolean isIncludeStart, boolean isIncludeEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(start, "First element must be not null!", new Object[0]);
        this.start = var1_1;
        this.end = var2_2;
        this.stepper = var3_3;
        this.next = this.safeStep(this.start);
        this.includeStart = isIncludeStart;
        this.includeEnd = isIncludeEnd;
    }

    public Range<T> disableLock() {
        this.lock = new NoLock();
        return this;
    }

    @Override
    public boolean hasNext() {
        this.lock.lock();
        try {
            if (this.index == 0 && this.includeStart) {
                return true;
            }
            if (this.next == null) {
                return false;
            }
            if (!this.includeEnd && this.next.equals(this.end)) {
                return false;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public T next() {
        this.lock.lock();
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Has no next range!");
            }
            T t = this.nextUncheck();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private T nextUncheck() {
        void var1_1;
        block2: {
            T current;
            while (this.index == 0) {
                current = this.start;
                if (!this.includeStart) {
                    ++this.index;
                    continue;
                }
                break block2;
            }
            current = this.next;
            this.next = this.safeStep(this.next);
        }
        ++this.index;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private T safeStep(T base) {
        void var3_3;
        int index = this.index;
        Object next = null;
        try {
            void var2_2;
            void var1_1;
            next = this.stepper.step(var1_1, (void)this.end, (int)var2_2);
        }
        catch (Exception exception) {}
        return var3_3;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove ranged element!");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public Range<T> reset() {
        this.lock.lock();
        try {
            this.index = 0;
            this.next = this.safeStep(this.start);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @FunctionalInterface
    public static interface Stepper<T> {
        public T step(T var1, T var2, int var3);
    }
}

