/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.func.VoidFunc0;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Opt<T> {
    private static final Opt<?> EMPTY = new Opt<Object>(null);
    private final T value;
    private Exception exception;

    public static <T> Opt<T> empty() {
        return EMPTY;
    }

    public static <T> Opt<T> of(T value) {
        T t;
        return new Opt<T>(Objects.requireNonNull(t));
    }

    public static <T> Opt<T> ofNullable(T value) {
        T t;
        if (value == null) {
            return Opt.empty();
        }
        return new Opt<T>(t);
    }

    public static <T> Opt<T> ofBlankAble(T value) {
        T t;
        if (StrUtil.isBlankIfStr(value)) {
            return Opt.empty();
        }
        return new Opt<T>(t);
    }

    public static <T, R extends Collection<T>> Opt<R> ofEmptyAble(R value) {
        R r;
        if (ObjectUtil.isEmpty(value)) {
            return Opt.empty();
        }
        return new Opt<R>(r);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Opt<T> ofTry(Func0<T> supplier) {
        try {
            return Opt.ofNullable(supplier.call());
        }
        catch (Exception e) {
            void var1_2;
            void var0_1;
            Opt<Object> empty = new Opt<Object>(null);
            new Opt<Object>(null).exception = var0_1;
            return var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Opt(T value) {
        void var1_1;
        this.value = var1_1;
    }

    public T get() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isFail() {
        return this.exception != null;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    /*
     * WARNING - void declaration
     */
    public Opt<T> ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            void var1_1;
            var1_1.accept(this.value);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Opt<T> ifPresentOrElse(Consumer<? super T> action, VoidFunc0 emptyAction) {
        if (this.isPresent()) {
            void var1_1;
            var1_1.accept(this.value);
        } else {
            void var2_2;
            var2_2.callWithRuntimeException();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <U> Opt<U> mapOrElse(Function<? super T, ? extends U> mapper, VoidFunc0 emptyAction) {
        void var2_2;
        if (this.isPresent()) {
            void var1_1;
            return Opt.ofNullable(var1_1.apply(this.value));
        }
        var2_2.callWithRuntimeException();
        return Opt.empty();
    }

    /*
     * WARNING - void declaration
     */
    public Opt<T> filter(Predicate<? super T> predicate) {
        void var1_1;
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        if (var1_1.test(this.value)) {
            return this;
        }
        return Opt.empty();
    }

    /*
     * WARNING - void declaration
     */
    public <U> Opt<U> map(Function<? super T, ? extends U> mapper) {
        void var1_1;
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(var1_1.apply(this.value));
    }

    public <U> Opt<U> flatMap(Function<? super T, ? extends Opt<? extends U>> mapper) {
        Opt opt;
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        opt = (Opt)opt.apply(this.value);
        return Objects.requireNonNull(opt);
    }

    /*
     * WARNING - void declaration
     */
    public <U> Opt<U> flattedMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        void var1_1;
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(((Optional)var1_1.apply(this.value)).orElse(null));
    }

    /*
     * WARNING - void declaration
     */
    public Opt<T> peek(Consumer<T> action) throws NullPointerException {
        void var1_1;
        Objects.requireNonNull(action);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        var1_1.accept(this.value);
        return this;
    }

    @SafeVarargs
    public final Opt<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return Stream.of(actions).reduce(this, Opt::peek, (opts, opt) -> null);
    }

    public Opt<T> or(Supplier<? extends Opt<? extends T>> supplier) {
        Opt opt;
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        opt = (Opt)opt.get();
        return Objects.requireNonNull(opt);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public T orElse(T other) {
        void var1_1;
        if (this.isPresent()) {
            return this.value;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public T exceptionOrElse(T other) {
        if (this.isFail()) {
            void var1_1;
            return var1_1;
        }
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public T orElseGet(Supplier<? extends T> supplier) {
        void var1_1;
        if (this.isPresent()) {
            return this.value;
        }
        return var1_1.get();
    }

    public T orElseThrow() {
        return this.orElseThrow(NoSuchElementException::new, "No value present");
    }

    /*
     * WARNING - void declaration
     */
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        void var1_1;
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    public <X extends Throwable> T orElseThrow(Function<String, ? extends X> exceptionFunction, String message) throws X {
        void var2_2;
        void var1_1;
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)var1_1.apply(var2_2);
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opt)) {
            return false;
        }
        Opt other = (Opt)obj;
        return Objects.equals(this.value, var1_1.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return StrUtil.toStringOrNull(this.value);
    }
}

