/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectId {
    private static final AtomicInteger NEXT_INC = new AtomicInteger(RandomUtil.randomInt());
    private static final int MACHINE = ObjectId.getMachinePiece() | ObjectId.getProcessPiece();

    /*
     * WARNING - void declaration
     */
    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = (s = StrUtil.removeAll((CharSequence)s, "-")).length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            void var2_3;
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && var2_3 <= 70) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] nextBytes() {
        void var0;
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putInt((int)DateUtil.currentSeconds());
        bb.putInt(MACHINE);
        bb.putInt(NEXT_INC.getAndIncrement());
        return var0.array();
    }

    public static String next() {
        return ObjectId.next(false);
    }

    /*
     * WARNING - void declaration
     */
    public static String next(boolean withHyphen) {
        void var2_2;
        byte[] array = ObjectId.nextBytes();
        StringBuilder buf = new StringBuilder(withHyphen ? 26 : 24);
        for (int i = 0; i < array.length; ++i) {
            void var3_4;
            int t;
            if (withHyphen && i % 4 == 0 && i != 0) {
                buf.append("-");
            }
            if ((t = array[i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString((int)var3_4));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static int getMachinePiece() {
        void var0_1;
        int machinePiece;
        try {
            StringBuilder netSb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                void var2_3;
                NetworkInterface ni = e.nextElement();
                netSb.append(var2_3.toString());
            }
            machinePiece = netSb.toString().hashCode() << 16;
        }
        catch (Throwable throwable) {
            machinePiece = RandomUtil.randomInt() << 16;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getProcessPiece() {
        void var1_4;
        void var0;
        int processId;
        try {
            processId = RuntimeUtil.getPid();
        }
        catch (Throwable throwable) {
            processId = RandomUtil.randomInt();
        }
        ClassLoader loader = ClassLoaderUtil.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        String string = Integer.toHexString((int)var0) + Integer.toHexString((int)var1_4);
        int n = string.hashCode() & 0xFFFF;
        return n;
    }
}

