/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsoleTable {
    private static final char ROW_LINE = '\uff0d';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private static final char LF = '\n';
    private boolean isSBCMode = true;
    private final List<List<String>> headerList = new ArrayList<List<String>>();
    private final List<List<String>> bodyList = new ArrayList<List<String>>();
    private List<Integer> columnCharNumber;

    public static ConsoleTable create() {
        return new ConsoleTable();
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleTable setSBCMode(boolean isSBCMode) {
        void var1_1;
        this.isSBCMode = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleTable addHeader(String ... titles) {
        void var2_2;
        void var1_1;
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
        }
        ArrayList<String> l = new ArrayList<String>();
        this.fillColumns(l, (String[])var1_1);
        this.headerList.add((List<String>)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleTable addBody(String ... values) {
        void var1_1;
        void var2_2;
        ArrayList l = new ArrayList();
        this.bodyList.add(l);
        this.fillColumns((List<String>)var2_2, (String[])var1_1);
        return this;
    }

    private void fillColumns(List<String> l, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String column = StrUtil.toString(columns[i]);
            if (this.isSBCMode) {
                column = Convert.toSBC(column);
            }
            l.add(column);
            int width = column.length();
            if (width <= this.columnCharNumber.get(i)) continue;
            this.columnCharNumber.set(i, width);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.fillBorder(sb);
        this.fillRows(sb, this.headerList);
        this.fillBorder(sb);
        this.fillRows(sb, this.bodyList);
        this.fillBorder(sb);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void fillRows(StringBuilder sb, List<List<String>> list) {
        for (List<String> row : list) {
            void var3_3;
            sb.append('|');
            this.fillRow(sb, (List<String>)var3_3);
            sb.append('\n');
        }
    }

    private void fillRow(StringBuilder sb, List<String> row) {
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            String value = row.get(i);
            sb.append('\u3000');
            sb.append(value);
            int length = value.length();
            int sbcCount = this.sbcCount(value);
            if (sbcCount % 2 == 1) {
                sb.append(' ');
            }
            sb.append('\u3000');
            int maxLength = this.columnCharNumber.get(i);
            for (int j = 0; j < maxLength - length + sbcCount / 2; ++j) {
                sb.append('\u3000');
            }
            sb.append('|');
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillBorder(StringBuilder sb) {
        void var1_1;
        sb.append('+');
        for (Integer width : this.columnCharNumber) {
            void var3_3;
            sb.append(StrUtil.repeat('\uff0d', var3_3.intValue() + 2));
            sb.append('+');
        }
        var1_1.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }

    /*
     * WARNING - void declaration
     */
    private int sbcCount(String value) {
        void var2_2;
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) >= '\u007f') continue;
            ++count;
        }
        return (int)var2_2;
    }
}

