/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.ConsoleTable;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Scanner;

public class Console {
    private static final String TEMPLATE_VAR = "{}";

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        Object object;
        if (obj instanceof Throwable) {
            Object e = (Throwable)obj;
            Console.log((Throwable)e, ((Throwable)object).getMessage(), new Object[0]);
            return;
        }
        Console.log(TEMPLATE_VAR, object);
    }

    /*
     * WARNING - void declaration
     */
    public static void log(Object obj1, Object ... otherObjs) {
        Object object;
        void var1_1;
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.log(obj1);
            return;
        }
        Console.log(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{object}));
    }

    /*
     * WARNING - void declaration
     */
    public static void log(String template, Object ... values) {
        String string;
        void var1_1;
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.logInternal(template, values);
            return;
        }
        Console.logInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{string}));
    }

    /*
     * WARNING - void declaration
     */
    public static void log(Throwable t, String template, Object ... values) {
        void var2_2;
        void var1_1;
        System.out.println(StrUtil.format((CharSequence)var1_1, (Object[])var2_2));
        if (t != null) {
            Throwable throwable;
            throwable.printStackTrace(System.out);
            System.out.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logInternal(String template, Object ... values) {
        void var1_1;
        String string;
        Console.log(null, string, (Object[])var1_1);
    }

    public static void table(ConsoleTable consoleTable) {
        Console.print(consoleTable.toString());
    }

    public static void print(Object obj) {
        Object object;
        Console.print(TEMPLATE_VAR, object);
    }

    /*
     * WARNING - void declaration
     */
    public static void print(Object obj1, Object ... otherObjs) {
        Object object;
        void var1_1;
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.print(obj1);
            return;
        }
        Console.print(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{object}));
    }

    /*
     * WARNING - void declaration
     */
    public static void print(String template, Object ... values) {
        String string;
        void var1_1;
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.printInternal(template, values);
            return;
        }
        Console.printInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{string}));
    }

    /*
     * WARNING - void declaration
     */
    public static void printProgress(char showChar, int len) {
        void var1_1;
        char c;
        Console.print("{}{}", Character.valueOf('\r'), StrUtil.repeat(c, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void printProgress(char showChar, int totalLen, double rate) {
        void var2_2;
        void var1_1;
        char c;
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(c, (int)((double)var1_1 * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static void printInternal(String template, Object ... values) {
        void var1_1;
        String string;
        System.out.print(StrUtil.format(string, (Object[])var1_1));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        Object object;
        if (obj instanceof Throwable) {
            Object e = (Throwable)obj;
            Console.error((Throwable)e, ((Throwable)object).getMessage(), new Object[0]);
            return;
        }
        Console.error(TEMPLATE_VAR, object);
    }

    /*
     * WARNING - void declaration
     */
    public static void error(Object obj1, Object ... otherObjs) {
        Object object;
        void var1_1;
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.error(obj1);
            return;
        }
        Console.error(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{object}));
    }

    /*
     * WARNING - void declaration
     */
    public static void error(String template, Object ... values) {
        String string;
        void var1_1;
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template, TEMPLATE_VAR)) {
            Console.errorInternal(template, values);
            return;
        }
        Console.errorInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(var1_1, 0, new Object[]{string}));
    }

    /*
     * WARNING - void declaration
     */
    public static void error(Throwable t, String template, Object ... values) {
        void var2_2;
        void var1_1;
        System.err.println(StrUtil.format((CharSequence)var1_1, (Object[])var2_2));
        if (t != null) {
            Throwable throwable;
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void errorInternal(String template, Object ... values) {
        void var1_1;
        String string;
        Console.error(null, string, (Object[])var1_1);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().nextLine();
    }

    /*
     * WARNING - void declaration
     */
    public static String where() {
        void var0;
        void var3_3;
        void var2_2;
        void var1_1;
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", var1_1, var2_2, var3_3, var0);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int count) {
        int n;
        return StrUtil.repeatAndJoin(TEMPLATE_VAR, n, " ");
    }
}

