/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Filter<Class<?>> classFilter;
    private final Charset charset;
    private ClassLoader classLoader;
    private boolean initialize;
    private final Set<Class<?>> classes = new HashSet();
    private boolean ignoreLoadError = false;
    private final Set<String> classesOfLoadError = new HashSet<String>();

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanAllPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        void var1_1;
        return ClassScanner.scanAllPackage(packageName, arg_0 -> ClassScanner.lambda$scanAllPackageByAnnotation$0((Class)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        void var1_1;
        return ClassScanner.scanPackage(packageName, arg_0 -> ClassScanner.lambda$scanPackageByAnnotation$1((Class)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanAllPackageBySuper(String packageName, Class<?> superClass) {
        void var1_1;
        return ClassScanner.scanAllPackage(packageName, arg_0 -> ClassScanner.lambda$scanAllPackageBySuper$2((Class)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        void var1_1;
        return ClassScanner.scanPackage(packageName, arg_0 -> ClassScanner.lambda$scanPackageBySuper$3((Class)var1_1, arg_0));
    }

    public static Set<Class<?>> scanAllPackage() {
        return ClassScanner.scanAllPackage("", null);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanAllPackage(String packageName, Filter<Class<?>> classFilter) {
        void var1_1;
        String string;
        return new ClassScanner(string, (Filter<Class<?>>)var1_1).scan(true);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        void var1_1;
        String string;
        return new ClassScanner(string, (Filter<Class<?>>)var1_1).scan();
    }

    public ClassScanner() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClassScanner(String packageName) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassScanner(String packageName, Filter<Class<?>> classFilter) {
        this((String)var1_1, (Filter<Class<?>>)var2_2, CharsetUtil.CHARSET_UTF_8);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassScanner(String packageName, Filter<Class<?>> classFilter, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.packageName = packageName = StrUtil.nullToEmpty(packageName);
        this.packageNameWithDot = StrUtil.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = var1_1.replace('.', '/');
        this.classFilter = var2_2;
        this.charset = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ClassScanner setIgnoreLoadError(boolean ignoreLoadError) {
        void var1_1;
        this.ignoreLoadError = var1_1;
        return this;
    }

    public Set<Class<?>> scan() {
        return this.scan(false);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Class<?>> scan(boolean forceScanJavaClassPaths) {
        void var1_1;
        this.classes.clear();
        this.classesOfLoadError.clear();
        for (URL url : ResourceUtil.getResourceIter(this.packagePath, this.classLoader)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLUtil.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    void var3_3;
                    this.scanJar(URLUtil.getJarFile((URL)var3_3));
                }
            }
        }
        if (var1_1 != false || CollUtil.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    /*
     * WARNING - void declaration
     */
    public void setInitialize(boolean initialize) {
        void var1_1;
        this.initialize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setClassLoader(ClassLoader classLoader) {
        void var1_1;
        this.classLoader = var1_1;
    }

    public Set<String> getClassesOfLoadError() {
        return Collections.unmodifiableSet(this.classesOfLoadError);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void scanJavaClassPaths() {
        String[] stringArray = ClassUtil.getJavaClassPaths();
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            String classPath = URLUtil.decode(string, CharsetUtil.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanFile(File file, String rootDir) {
        if (file.isFile()) {
            String className;
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
                return;
            } else {
                if (!className.endsWith(".jar")) return;
                try {
                    this.scanJar(new JarFile(file));
                    return;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        } else {
            void var3_5;
            File[] files;
            if (!file.isDirectory() || (files = file.listFiles()) == null) return;
            for (void subFile : var3_5) {
                this.scanFile((File)subFile, rootDir == null ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scanJar(JarFile jar) {
        try {
            for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
                void var2_3;
                String name = StrUtil.removePrefix(entry.getName(), "/");
                if (!StrUtil.isEmpty(this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(0, name.length() - 6).replace('/', '.');
                ClassScanner classScanner = this;
                classScanner.addIfAccept(classScanner.loadClass((String)var2_3));
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            IoUtil.close((Closeable)var1_1);
            throw throwable;
        }
        IoUtil.close(jar);
    }

    /*
     * WARNING - void declaration
     */
    protected Class<?> loadClass(String className) {
        void var3_4;
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            this.classLoader = loader = ClassLoaderUtil.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, loader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            this.classesOfLoadError.add(className);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.classesOfLoadError.add(className);
        }
        catch (Throwable e) {
            void var1_1;
            if (!this.ignoreLoadError) {
                void var2_3;
                throw ExceptionUtil.wrapRuntime((Throwable)var2_3);
            }
            this.classesOfLoadError.add((String)var1_1);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private void addIfAccept(String className) {
        void var3_3;
        void var2_2;
        int packageLen;
        if (StrUtil.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length()) ? className.equals(this.packageName) : var2_2 > var3_3 && (".".equals(this.packageNameWithDot) || className.startsWith(this.packageNameWithDot))) {
            void var1_1;
            ClassScanner classScanner = this;
            classScanner.addIfAccept(classScanner.loadClass((String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addIfAccept(Class<?> clazz) {
        void var2_2;
        Filter<Class<?>> classFilter;
        if (clazz != null && ((classFilter = this.classFilter) == null || var2_2.accept(clazz))) {
            void var1_1;
            this.classes.add((Class<?>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String subPathBeforePackage(File file) {
        void var1_1;
        String filePath = file.getAbsolutePath();
        if (StrUtil.isNotEmpty(this.packageDirName)) {
            filePath = StrUtil.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StrUtil.addSuffixIfNot((CharSequence)var1_1, File.separator);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$scanPackageBySuper$3(Class superClass, Class clazz) {
        void var1_1;
        Class clazz2;
        return superClass.isAssignableFrom(clazz) && !clazz2.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$scanAllPackageBySuper$2(Class superClass, Class clazz) {
        void var1_1;
        Class clazz2;
        return superClass.isAssignableFrom(clazz) && !clazz2.equals(var1_1);
    }

    private static /* synthetic */ boolean lambda$scanPackageByAnnotation$1(Class annotationClass, Class clazz) {
        Class clazz2;
        return clazz.isAnnotationPresent(clazz2);
    }

    private static /* synthetic */ boolean lambda$scanAllPackageByAnnotation$0(Class annotationClass, Class clazz) {
        Class clazz2;
        return clazz.isAnnotationPresent(clazz2);
    }
}

