/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.function.Supplier;

public class Assert {
    private static final String TEMPLATE_VALUE_MUST_BE_BETWEEN_AND = "The value must be between {} and {}.";

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void isTrue(boolean expression, Supplier<? extends X> supplier) throws X {
        if (!expression) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        Assert.isTrue(expression, () -> Assert.lambda$isTrue$0((String)var1_1, (Object[])var2_2));
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void isFalse(boolean expression, Supplier<X> errorSupplier) throws X {
        if (expression) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        Assert.isFalse(expression, () -> Assert.lambda$isFalse$1((String)var1_1, (Object[])var2_2));
    }

    public static void isFalse(boolean expression) throws IllegalArgumentException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void isNull(Object object, Supplier<X> errorSupplier) throws X {
        if (object != null) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        Assert.isNull(object, () -> Assert.lambda$isNull$2((String)var1_1, (Object[])var2_2));
    }

    public static void isNull(Object object) throws IllegalArgumentException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        T t;
        if (object == null) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notNull(object, () -> Assert.lambda$notNull$3((String)var1_1, (Object[])var2_2));
    }

    public static <T> T notNull(T object) throws IllegalArgumentException {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence, X extends Throwable> T notEmpty(T text, Supplier<X> errorSupplier) throws X {
        T t;
        if (StrUtil.isEmpty(text)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notEmpty(text, () -> Assert.lambda$notEmpty$4((String)var1_1, (Object[])var2_2));
    }

    public static <T extends CharSequence> T notEmpty(T text) throws IllegalArgumentException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence, X extends Throwable> T notBlank(T text, Supplier<X> errorMsgSupplier) throws X {
        T t;
        if (StrUtil.isBlank(text)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notBlank(text, () -> Assert.lambda$notBlank$5((String)var1_1, (Object[])var2_2));
    }

    public static <T extends CharSequence> T notBlank(T text) throws IllegalArgumentException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence, X extends Throwable> T notContain(CharSequence textToSearch, T substring, Supplier<X> errorSupplier) throws X {
        void var1_1;
        if (StrUtil.contains(textToSearch, substring)) {
            void var2_2;
            throw (Throwable)var2_2.get();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        return (String)Assert.notContain(textToSearch, var1_1, () -> Assert.lambda$notContain$6((String)var2_2, (Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String notContain(String textToSearch, String substring) throws IllegalArgumentException {
        void var1_1;
        return Assert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, X extends Throwable> T[] notEmpty(T[] array, Supplier<X> errorSupplier) throws X {
        T[] TArray;
        if (ArrayUtil.isEmpty(array)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] notEmpty(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notEmpty(array, () -> Assert.lambda$notEmpty$7((String)var1_1, (Object[])var2_2));
    }

    public static <T> T[] notEmpty(T[] array) throws IllegalArgumentException {
        return Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, X extends Throwable> T[] noNullElements(T[] array, Supplier<X> errorSupplier) throws X {
        T[] TArray;
        if (ArrayUtil.hasNull(array)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.noNullElements(array, () -> Assert.lambda$noNullElements$8((String)var1_1, (Object[])var2_2));
    }

    public static <T> T[] noNullElements(T[] array) throws IllegalArgumentException {
        return Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <E, T extends Iterable<E>, X extends Throwable> T notEmpty(T collection, Supplier<X> errorSupplier) throws X {
        T t;
        if (CollUtil.isEmpty(collection)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <E, T extends Iterable<E>> T notEmpty(T collection, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notEmpty(collection, () -> Assert.lambda$notEmpty$9((String)var1_1, (Object[])var2_2));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection) throws IllegalArgumentException {
        return Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, T extends Map<K, V>, X extends Throwable> T notEmpty(T map, Supplier<X> errorSupplier) throws X {
        T t;
        if (MapUtil.isEmpty(map)) {
            void var1_1;
            throw (Throwable)var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, T extends Map<K, V>> T notEmpty(T map, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return Assert.notEmpty(map, () -> Assert.lambda$notEmpty$10((String)var1_1, (Object[])var2_2));
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map) throws IllegalArgumentException {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T isInstanceOf(Class<?> type, T obj) {
        Class<?> clazz;
        void var1_1;
        return Assert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", var1_1, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var1_1;
        Class<?> clazz;
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!clazz.isInstance(obj)) {
            void var3_3;
            void var2_2;
            throw new IllegalArgumentException(StrUtil.format((CharSequence)var2_2, (Object[])var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void isAssignable(Class<?> superType, Class<?> subType) throws IllegalArgumentException {
        Class<?> clazz;
        void var1_1;
        Assert.isAssignable(superType, subType, "{} is not assignable to {})", var1_1, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var1_1;
        Class<?> clazz;
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !clazz.isAssignableFrom((Class<?>)var1_1)) {
            void var3_3;
            void var2_2;
            throw new IllegalArgumentException(StrUtil.format((CharSequence)var2_2, (Object[])var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void state(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalStateException {
        if (!expression) {
            void var1_1;
            throw new IllegalStateException((String)var1_1.get());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(StrUtil.format((CharSequence)var1_1, (Object[])var2_2));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int checkIndex(int index, int size) throws IllegalArgumentException, IndexOutOfBoundsException {
        void var1_1;
        return Assert.checkIndex(index, (int)var1_1, "[Assertion failed]", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws IllegalArgumentException, IndexOutOfBoundsException {
        int n;
        if (index < 0 || index >= size) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(Assert.badIndexMsg(index, (int)var1_1, (String)var2_2, (Object[])var3_3));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> int checkBetween(int value, int min, int max, Supplier<? extends X> errorSupplier) throws X {
        int n;
        void var2_2;
        void var1_1;
        if (value < var1_1 || value > var2_2) {
            void var3_3;
            throw (Throwable)var3_3.get();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkBetween(int value, int min, int max, String errorMsgTemplate, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Assert.checkBetween(value, (int)var1_1, (int)var2_2, () -> Assert.lambda$checkBetween$11((String)var3_3, params));
    }

    /*
     * WARNING - void declaration
     */
    public static int checkBetween(int value, int min, int max) {
        void var2_2;
        void var1_1;
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{(int)var1_1, (int)var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> long checkBetween(long value, long min, long max, Supplier<? extends X> errorSupplier) throws X {
        long l;
        void var2_1;
        if (value < var2_1 || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static long checkBetween(long value, long min, long max, String errorMsgTemplate, Object ... params) {
        void var2_1;
        return Assert.checkBetween(value, (long)var2_1, max, () -> {
            void var1_1;
            String string;
            return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static long checkBetween(long value, long min, long max) {
        void var2_2;
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{(long)var2_2, max});
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> double checkBetween(double value, double min, double max, Supplier<? extends X> errorSupplier) throws X {
        double d;
        void var2_1;
        if (value < var2_1 || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static double checkBetween(double value, double min, double max, String errorMsgTemplate, Object ... params) {
        void var2_1;
        return Assert.checkBetween(value, (double)var2_1, max, () -> {
            void var1_1;
            String string;
            return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static double checkBetween(double value, double min, double max) {
        void var2_2;
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, (double)var2_2, max);
    }

    /*
     * WARNING - void declaration
     */
    public static Number checkBetween(Number value, Number min, Number max) {
        Number number;
        void var3_3;
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || var3_3 > maxDouble) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(StrUtil.format(TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, var1_1, var2_2));
        }
        return number;
    }

    /*
     * WARNING - void declaration
     */
    public static void notEquals(Object obj1, Object obj2) {
        void var1_1;
        Object object;
        Assert.notEquals(obj1, obj2, "({}) must be not equals ({})", object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void notEquals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notEquals(obj1, var1_1, () -> Assert.lambda$notEquals$14((String)var2_2, (Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void notEquals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        void var1_1;
        if (ObjectUtil.equals(obj1, var1_1)) {
            void var2_2;
            throw (Throwable)var2_2.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void equals(Object obj1, Object obj2) {
        void var1_1;
        Object object;
        Assert.equals(obj1, obj2, "({}) must be equals ({})", object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void equals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.equals(obj1, var1_1, () -> Assert.lambda$equals$15((String)var2_2, (Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void equals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        void var1_1;
        if (ObjectUtil.notEqual(obj1, var1_1)) {
            void var2_2;
            throw (Throwable)var2_2.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        void var1_1;
        int n;
        void var3_3;
        void var2_2;
        if (index < 0) {
            return StrUtil.format("{} ({}) must not be negative", StrUtil.format(desc, params), index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return StrUtil.format("{} ({}) must be less than size ({})", StrUtil.format((CharSequence)var2_2, (Object[])var3_3), n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$equals$15(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notEquals$14(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$checkBetween$11(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notEmpty$10(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notEmpty$9(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$noNullElements$8(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notEmpty$7(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notContain$6(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notBlank$5(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notEmpty$4(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$notNull$3(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$isNull$2(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$isFalse$1(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IllegalArgumentException lambda$isTrue$0(String errorMsgTemplate, Object[] params) {
        void var1_1;
        String string;
        return new IllegalArgumentException(StrUtil.format(string, (Object[])var1_1));
    }
}

