/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch.watchers;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.Set;

public class DelayWatcher
implements Watcher {
    private final Set<Path> eventSet = new ConcurrentHashSet<Path>();
    private final Watcher watcher;
    private final long delay;

    /*
     * WARNING - void declaration
     */
    public DelayWatcher(Watcher watcher, long delay) {
        void var2_2;
        void var1_1;
        Assert.notNull(watcher);
        if (watcher instanceof DelayWatcher) {
            throw new IllegalArgumentException("Watcher must not be a DelayWatcher");
        }
        this.watcher = var1_1;
        this.delay = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        void var2_2;
        void var1_1;
        if (this.delay < 1L) {
            this.watcher.onModify(event, currentPath);
            return;
        }
        this.onDelayModify((WatchEvent<?>)var1_1, (Path)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCreate(WatchEvent<?> event, Path currentPath) {
        void var2_2;
        void var1_1;
        this.watcher.onCreate((WatchEvent<?>)var1_1, (Path)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDelete(WatchEvent<?> event, Path currentPath) {
        void var2_2;
        void var1_1;
        this.watcher.onDelete((WatchEvent<?>)var1_1, (Path)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onOverflow(WatchEvent<?> event, Path currentPath) {
        void var2_2;
        void var1_1;
        this.watcher.onOverflow((WatchEvent<?>)var1_1, (Path)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void onDelayModify(WatchEvent<?> event, Path currentPath) {
        void var2_2;
        void var1_1;
        void var3_3;
        Path eventPath = Paths.get(currentPath.toString(), event.context().toString());
        if (this.eventSet.contains(eventPath)) {
            return;
        }
        this.eventSet.add((Path)var3_3);
        this.startHandleModifyThread((WatchEvent<?>)var1_1, (Path)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void startHandleModifyThread(WatchEvent<?> event, Path currentPath) {
        void var1_1;
        void var2_2;
        ThreadUtil.execute(() -> this.lambda$startHandleModifyThread$0((Path)var2_2, (WatchEvent)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$startHandleModifyThread$0(Path currentPath, WatchEvent event) {
        void var1_1;
        void var2_2;
        ThreadUtil.sleep(this.delay);
        this.eventSet.remove(Paths.get(currentPath.toString(), event.context().toString()));
        this.watcher.onModify((WatchEvent<?>)var2_2, (Path)var1_1);
    }
}

