/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.watch.WatchAction;
import cn.hutool.core.io.watch.WatchException;
import cn.hutool.core.io.watch.WatchKind;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class WatchServer
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchService watchService;
    protected WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    protected boolean isClosed;
    private final Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();

    /*
     * WARNING - void declaration
     */
    public void init() throws WatchException {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            void var1_1;
            throw new WatchException((Throwable)var1_1);
        }
        this.isClosed = false;
    }

    /*
     * WARNING - void declaration
     */
    public void setModifiers(WatchEvent.Modifier[] modifiers) {
        void var1_1;
        this.modifiers = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void registerPath(Path path, int maxDepth) {
        WatchEvent.Kind<?>[] kinds = ArrayUtil.defaultIfEmpty(this.events, WatchKind.ALL);
        try {
            WatchKey key;
            key = ArrayUtil.isEmpty(this.modifiers) ? path.register(this.watchService, kinds) : path.register(this.watchService, (WatchEvent.Kind<?>[])key, this.modifiers);
            this.watchKeyPathMap.put(key, path);
            if (maxDepth > 1) {
                void var2_2;
                void var1_1;
                Files.walkFileTree((Path)var1_1, EnumSet.noneOf(FileVisitOption.class), (int)var2_2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                    final /* synthetic */ WatchServer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        void var2_2;
                        void var1_1;
                        this.this$0.registerPath(dir, 0);
                        return super.postVisitDirectory(var1_1, (IOException)var2_2);
                    }
                });
            }
            return;
        }
        catch (IOException e) {
            if (!(e instanceof AccessDeniedException)) {
                void var3_4;
                throw new WatchException((Throwable)var3_4);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void watch(WatchAction action, Filter<WatchEvent<?>> watchFilter) {
        void var3_3;
        WatchKey wk;
        try {
            wk = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException exception) {
            this.close();
            return;
        }
        Path currentPath = this.watchKeyPathMap.get(wk);
        for (WatchEvent<?> event : wk.pollEvents()) {
            if (watchFilter != null && !watchFilter.accept(event)) continue;
            action.doAction(event, currentPath);
        }
        var3_3.reset();
    }

    /*
     * WARNING - void declaration
     */
    public void watch(Watcher watcher, Filter<WatchEvent<?>> watchFilter) {
        void var2_2;
        void var1_1;
        this.watch((arg_0, arg_1) -> WatchServer.lambda$watch$0((Watcher)var1_1, arg_0, arg_1), (Filter<WatchEvent<?>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public WatchKey getWatchKey(Path path) {
        for (Map.Entry<WatchKey, Path> entry : this.watchKeyPathMap.entrySet()) {
            void var3_3;
            if (!ObjectUtil.equals(path, entry.getValue())) continue;
            return (WatchKey)var3_3.getKey();
        }
        return null;
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.close(this.watchService);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$watch$0(Watcher watcher, WatchEvent event, Path currentPath) {
        void var3_3;
        WatchEvent.Kind kind = event.kind();
        if (kind == WatchKind.CREATE.getValue()) {
            watcher.onCreate(event, currentPath);
            return;
        }
        if (kind == WatchKind.MODIFY.getValue()) {
            watcher.onModify(event, currentPath);
            return;
        }
        if (kind == WatchKind.DELETE.getValue()) {
            watcher.onDelete(event, currentPath);
            return;
        }
        if (var3_3 == WatchKind.OVERFLOW.getValue()) {
            void var2_2;
            void var1_1;
            Watcher watcher2;
            watcher2.onOverflow((WatchEvent<?>)var1_1, (Path)var2_2);
        }
    }
}

