/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.watch.WatchException;
import cn.hutool.core.io.watch.WatchKind;
import cn.hutool.core.io.watch.WatchServer;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.FileAttribute;

public class WatchMonitor
extends WatchServer {
    private static final long serialVersionUID = 1L;
    public static final WatchEvent.Kind<?> OVERFLOW = WatchKind.OVERFLOW.getValue();
    public static final WatchEvent.Kind<?> ENTRY_MODIFY = WatchKind.MODIFY.getValue();
    public static final WatchEvent.Kind<?> ENTRY_CREATE = WatchKind.CREATE.getValue();
    public static final WatchEvent.Kind<?> ENTRY_DELETE = WatchKind.DELETE.getValue();
    public static final WatchEvent.Kind<?>[] EVENTS_ALL = WatchKind.ALL;
    private Path path;
    private int maxDepth;
    private Path filePath;
    private Watcher watcher;

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        void var1_1;
        return WatchMonitor.create(url, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var2_2;
        void var1_1;
        return WatchMonitor.create(URLUtil.toURI(url), (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        void var1_1;
        return WatchMonitor.create(uri, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var2_2;
        void var1_1;
        return WatchMonitor.create(Paths.get(uri), (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        void var1_1;
        return WatchMonitor.create(file, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var2_2;
        void var1_1;
        return WatchMonitor.create(file.toPath(), (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        void var1_1;
        return WatchMonitor.create(path, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var2_2;
        void var1_1;
        return WatchMonitor.create(Paths.get(path, new String[0]), (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        void var1_1;
        return WatchMonitor.create(path, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var2_2;
        void var1_1;
        Path path2;
        return new WatchMonitor(path2, (int)var1_1, (WatchEvent.Kind<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        void var1_1;
        return WatchMonitor.createAll(Paths.get(uri), (Watcher)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor createAll(URL url, Watcher watcher) {
        try {
            void var1_2;
            return WatchMonitor.createAll(Paths.get(url.toURI()), (Watcher)var1_2);
        }
        catch (URISyntaxException e) {
            void var0_1;
            throw new WatchException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor createAll(File file, Watcher watcher) {
        void var1_1;
        return WatchMonitor.createAll(file.toPath(), (Watcher)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor createAll(String path, Watcher watcher) {
        void var1_1;
        return WatchMonitor.createAll(Paths.get(path, new String[0]), (Watcher)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static WatchMonitor createAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor;
        void var1_1;
        WatchMonitor watchMonitor2 = WatchMonitor.create(path, EVENTS_ALL);
        watchMonitor2.setWatcher((Watcher)var1_1);
        return watchMonitor;
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(var1_1.toPath(), (WatchEvent.Kind<?>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get((String)var1_1, new String[0]), (WatchEvent.Kind<?>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this((Path)var1_1, 0, (WatchEvent.Kind<?>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.path = var1_1;
        this.maxDepth = var2_2;
        this.events = var3_3;
        ((WatchServer)this).init();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() throws WatchException {
        if (!Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            String lastPathEleStr;
            Path lastPathEle = FileUtil.getLastPathEle(this.path);
            if (lastPathEle != null && StrUtil.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StrUtil.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
        } else if (Files.isRegularFile(this.path, LinkOption.NOFOLLOW_LINKS)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        super.init();
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor setWatcher(Watcher watcher) {
        void var1_1;
        this.watcher = var1_1;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        WatchMonitor watchMonitor = this;
        watchMonitor.watch(watchMonitor.watcher);
    }

    public void watch(Watcher watcher) throws WatchException {
        if (this.isClosed) {
            throw new WatchException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            this.doTakeAndWatch(watcher);
        }
    }

    /*
     * WARNING - void declaration
     */
    public WatchMonitor setMaxDepth(int maxDepth) {
        void var1_1;
        this.maxDepth = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void doTakeAndWatch(Watcher watcher) {
        void var1_1;
        super.watch((Watcher)var1_1, (WatchEvent<?> watchEvent) -> {
            void var1_1;
            return this.filePath == null || this.filePath.endsWith(var1_1.context().toString());
        });
    }

    private void registerPath() {
        WatchMonitor watchMonitor = this;
        watchMonitor.registerPath(watchMonitor.path, this.filePath != null ? 0 : this.maxDepth);
    }
}

