/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.net.URL;

public class ClassPathResource
extends UrlResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    /*
     * WARNING - void declaration
     */
    public ClassPathResource(String path) {
        this((String)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassPathResource(String path, ClassLoader classLoader) {
        this((String)var1_1, (ClassLoader)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassPathResource(String path, Class<?> clazz) {
        this((String)var1_1, null, (Class<?>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassPathResource(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        super((URL)null);
        void var3_3;
        void var2_2;
        void var1_1;
        String path;
        Assert.notNull(pathBaseClassLoader, "Path must not be null", new Object[0]);
        this.path = path = this.normalizePath(pathBaseClassLoader);
        this.name = StrUtil.isBlank(path) ? null : FileUtil.getName((String)var1_1);
        this.classLoader = ObjectUtil.defaultIfNull(var2_2, ClassUtil::getClassLoader);
        this.clazz = var3_3;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (FileUtil.isAbsolutePath(this.path)) {
            return this.path;
        }
        return FileUtil.normalize(URLUtil.getDecodedPath(this.url));
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = this.clazz != null ? this.clazz.getResource(this.path) : (this.classLoader != null ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (this.url == null) {
            throw new NoResourceException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        if (this.path == null) {
            return super.toString();
        }
        return "classpath:" + this.path;
    }

    /*
     * WARNING - void declaration
     */
    private String normalizePath(String path) {
        void var1_1;
        path = FileUtil.normalize(path);
        path = StrUtil.removePrefix(path, "/");
        Assert.isFalse(FileUtil.isAbsolutePath(path), "Path [{}] must be a relative path !", path);
        return var1_1;
    }
}

