/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file.visitor;

import cn.hutool.core.io.file.PathUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final Path target;
    private final CopyOption[] copyOptions;
    private boolean isTargetCreated;

    /*
     * WARNING - void declaration
     */
    public CopyVisitor(Path source, Path target, CopyOption ... copyOptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (PathUtil.exists(target, false) && !PathUtil.isDirectory(target)) {
            throw new IllegalArgumentException("Target must be a directory");
        }
        this.source = var1_1;
        this.target = var2_2;
        this.copyOptions = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        block2: {
            this.initTargetDir();
            Path targetDir = this.resolveTarget(dir);
            try {
                Files.copy(dir, targetDir, this.copyOptions);
            }
            catch (FileAlreadyExistsException e) {
                void var1_2;
                void var2_3;
                if (Files.isDirectory((Path)var2_3, new LinkOption[0])) break block2;
                throw var1_2;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        void var1_1;
        this.initTargetDir();
        Files.copy(file, this.resolveTarget((Path)var1_1), this.copyOptions);
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private Path resolveTarget(Path file) {
        void var1_1;
        return this.target.resolve(this.source.relativize((Path)var1_1));
    }

    private void initTargetDir() {
        if (!this.isTargetCreated) {
            PathUtil.mkdir(this.target);
            this.isTargetCreated = true;
        }
    }
}

