/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.io.file.LineReadWatcher;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchKind;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Tailer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final LineHandler CONSOLE_HANDLER = new ConsoleLineHandler();
    private final Charset charset;
    private final LineHandler lineHandler;
    private final int initReadLine;
    private final long period;
    private final String filePath;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;
    private WatchMonitor fileDeleteWatchMonitor;
    private boolean stopOnDelete;

    /*
     * WARNING - void declaration
     */
    public Tailer(File file, LineHandler lineHandler) {
        this((File)var1_1, (LineHandler)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tailer(File file, LineHandler lineHandler, int initReadLine) {
        this((File)var1_1, CharsetUtil.CHARSET_UTF_8, (LineHandler)var2_2, (int)var3_3, DateUnit.SECOND.getMillis());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tailer(File file, Charset charset, LineHandler lineHandler) {
        this((File)var1_1, (Charset)var2_2, (LineHandler)var3_3, 0, DateUnit.SECOND.getMillis());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tailer(File file, Charset charset, LineHandler lineHandler, int initReadLine, long period) {
        void var1_1;
        void var3_3;
        void var2_2;
        Tailer.checkFile(file);
        this.charset = var2_2;
        this.lineHandler = var3_3;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileUtil.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.filePath = var1_1.getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public void setStopOnDelete(boolean stopOnDelete) {
        void var1_1;
        this.stopOnDelete = var1_1;
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - void declaration
     */
    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (this.stopOnDelete) {
            this.fileDeleteWatchMonitor = WatchMonitor.create(this.filePath, WatchKind.DELETE.getValue());
            this.fileDeleteWatchMonitor.setWatcher(new SimpleWatcher(this){
                final /* synthetic */ Tailer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onDelete(WatchEvent<?> event, Path currentPath) {
                    void var2_2;
                    void var1_1;
                    super.onDelete((WatchEvent<?>)var1_1, (Path)var2_2);
                    this.this$0.stop();
                    throw new IORuntimeException("{} has been deleted", this.this$0.filePath);
                }
            });
            this.fileDeleteWatchMonitor.start();
        }
        if (!async) {
            try {
                void var2_4;
                var2_4.get();
                return;
            }
            catch (ExecutionException e) {
                void var1_2;
                throw new UtilException((Throwable)var1_2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        try {
            this.executorService.shutdown();
            return;
        }
        finally {
            IoUtil.close(this.randomAccessFile);
            IoUtil.close(this.fileDeleteWatchMonitor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L < 0L ? 0L : len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine <= this.initReadLine) {
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    String line = FileUtil.readLine(this.randomAccessFile, this.charset);
                    if (line != null) {
                        stack.push(line);
                    }
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                String line = FileUtil.readLine(this.randomAccessFile, this.charset);
                if (line == null) break;
                stack.push(line);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.handle((String)stack.pop());
            }
        }
        try {
            void var1_1;
            this.randomAccessFile.seek((long)var1_1);
            return;
        }
        catch (IOException e) {
            void var3_3;
            throw new IORuntimeException((Throwable)var3_3);
        }
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new UtilException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            File file2;
            throw new UtilException("Path [{}] is not a file !", file2.getAbsolutePath());
        }
    }

    public static class ConsoleLineHandler
    implements LineHandler {
        @Override
        public void handle(String line) {
            Console.log(line);
        }
    }
}

