/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.PathMover;
import cn.hutool.core.io.file.visitor.CopyVisitor;
import cn.hutool.core.io.file.visitor.DelVisitor;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class PathUtil {
    /*
     * WARNING - void declaration
     */
    public static boolean isDirEmpty(Path dirPath) {
        boolean bl;
        block12: {
            Iterable<Path> dirStream2 = Files.newDirectoryStream(dirPath);
            Throwable throwable = null;
            try {
                boolean bl2 = bl = false == dirStream2.iterator().hasNext();
                if (dirStream2 == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (dirStream2 != null) {
                            if (throwable != null) {
                                try {
                                    dirStream2.close();
                                }
                                catch (Throwable dirStream2) {
                                    throwable.addSuppressed(dirStream2);
                                }
                            } else {
                                dirStream2.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    void var0_2;
                    throw new IORuntimeException((Throwable)var0_2);
                }
            }
            dirStream2.close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(Path path, FileFilter fileFilter) {
        void var1_1;
        return PathUtil.loopFiles(path, -1, (FileFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(Path path, int maxDepth, FileFilter fileFilter) {
        void var2_2;
        void var1_1;
        return PathUtil.loopFiles(path, (int)var1_1, false, (FileFilter)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(Path path, int maxDepth, boolean isFollowLinks, FileFilter fileFilter) {
        void var3_3;
        void var2_2;
        void var1_1;
        Comparable<Path> comparable;
        ArrayList<File> fileList = new ArrayList<File>();
        if (!PathUtil.exists(path, isFollowLinks)) {
            return fileList;
        }
        if (!PathUtil.isDirectory(path, isFollowLinks)) {
            Comparable<Path> file = path.toFile();
            if (fileFilter == null || fileFilter.accept((File)file)) {
                fileList.add((File)comparable);
            }
            return fileList;
        }
        PathUtil.walkFiles(comparable, (int)var1_1, (boolean)var2_2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((FileFilter)var3_3, fileList){
            final /* synthetic */ FileFilter val$fileFilter;
            final /* synthetic */ List val$fileList;
            {
                this.val$fileFilter = fileFilter;
                this.val$fileList = list;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (this.val$fileFilter == null || this.val$fileFilter.accept(file)) {
                    void var1_1;
                    this.val$fileList.add(var1_1);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    /*
     * WARNING - void declaration
     */
    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        void var1_1;
        PathUtil.walkFiles(start, -1, (FileVisitor<? super Path>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        void var2_2;
        void var1_1;
        PathUtil.walkFiles(start, (int)var1_1, false, (FileVisitor<? super Path>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void walkFiles(Path start, int maxDepth, boolean isFollowLinks, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            void var3_4;
            void var1_2;
            void var2_3;
            Files.walkFileTree(start, PathUtil.getFileVisitOption((boolean)var2_3), (int)var1_2, (FileVisitor<? super Path>)var3_4);
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean del(Path path) throws IORuntimeException {
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try {
            if (PathUtil.isDirectory(path)) {
                Files.walkFileTree(path, DelVisitor.INSTANCE);
            } else {
                PathUtil.delFile(path);
            }
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Path copyFile(Resource src, Path target, CopyOption ... options) throws IORuntimeException {
        Object object;
        block13: {
            Assert.notNull(src, "Source is null !", new Object[0]);
            if (src instanceof FileResource) {
                return PathUtil.copyFile(((FileResource)src).getFile().toPath(), target, options);
            }
            InputStream stream2 = src.getStream();
            Throwable throwable = null;
            try {
                void var2_5;
                object = PathUtil.copyFile(stream2, (Path)object, (CopyOption[])var2_5);
                if (stream2 == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (stream2 != null) {
                            if (throwable != null) {
                                try {
                                    stream2.close();
                                }
                                catch (Throwable stream2) {
                                    throwable.addSuppressed(stream2);
                                }
                            } else {
                                stream2.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    void var0_2;
                    throw new RuntimeException((Throwable)var0_2);
                }
            }
            stream2.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Path copyFile(InputStream src, Path target, CopyOption ... options) throws IORuntimeException {
        void var1_2;
        Assert.notNull(src, "Source is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directory is null !", new Object[0]);
        try {
            void var2_3;
            Files.copy(src, target, (CopyOption[])var2_3);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return PathUtil.copyFile(src, (Path)var1_1, (CopyOption[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directory is null !", new Object[0]);
        Path targetPath = PathUtil.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathUtil.mkParentDirs(targetPath);
        try {
            void var2_3;
            void var1_2;
            return Files.copy(src, (Path)var1_2, (CopyOption[])var2_3);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Path copy(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        Path path;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(src)) {
            return PathUtil.copyContent(src, target.resolve(src.getFileName()), options);
        }
        return PathUtil.copyFile(path, (Path)var1_1, (CopyOption[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Path copyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        void var1_2;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        try {
            void var2_3;
            Files.walkFileTree(src, new CopyVisitor(src, target, (CopyOption[])var2_3));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        return var1_2;
    }

    public static boolean isDirectory(Path path) {
        return PathUtil.isDirectory(path, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        void var1_1;
        Path path2;
        if (path == null) {
            return false;
        }
        return Files.isDirectory(path2, PathUtil.getLinkOptions((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Path getPathEle(Path path, int index) {
        void var1_1;
        Path path2;
        int n = index;
        return PathUtil.subPath(path, n, n == -1 ? path2.getNameCount() : var1_1 + true);
    }

    public static Path getLastPathEle(Path path) {
        Path path2 = path;
        return PathUtil.getPathEle(path2, path2.getNameCount() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static Path subPath(Path path, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Path path2;
        if (path == null) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            void var3_3;
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = var3_3;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path2.subpath((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws IORuntimeException {
        if (path == null) {
            return null;
        }
        try {
            void var1_2;
            return Files.readAttributes(path, BasicFileAttributes.class, PathUtil.getLinkOptions((boolean)var1_2));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws IORuntimeException {
        InputStream inputStream;
        try {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(inputStream);
    }

    public static BufferedReader getUtf8Reader(Path path) throws IORuntimeException {
        return PathUtil.getReader(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getReader(Path path, Charset charset) throws IORuntimeException {
        void var1_1;
        return IoUtil.getReader((InputStream)PathUtil.getInputStream(path), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static BufferedOutputStream getOutputStream(Path path) throws IORuntimeException {
        OutputStream outputStream;
        try {
            OutputStream in = Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Path rename(Path path, String newName, boolean isOverride) {
        void var2_2;
        void var1_1;
        Path path2 = path;
        return PathUtil.move(path2, path2.resolveSibling((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Path move(Path src, Path target, boolean isOverride) {
        void var2_2;
        void var1_1;
        return PathMover.of(src, (Path)var1_1, (boolean)var2_2).move();
    }

    /*
     * WARNING - void declaration
     */
    public static Path moveContent(Path src, Path target, boolean isOverride) {
        void var2_2;
        void var1_1;
        return PathMover.of(src, (Path)var1_1, (boolean)var2_2).moveContent();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            void var1_2;
            return Files.isSameFile(file1, (Path)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFile(Path path, boolean isFollowLinks) {
        void var1_1;
        Path path2;
        if (path == null) {
            return false;
        }
        return Files.isRegularFile(path2, PathUtil.getLinkOptions((boolean)var1_1));
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(Path path, boolean isFollowLinks) {
        void var1_1;
        return Files.exists(path, PathUtil.getLinkOptions((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isExistsAndNotDirectory(Path path, boolean isFollowLinks) {
        void var1_1;
        Path path2;
        return PathUtil.exists(path, isFollowLinks) && false == PathUtil.isDirectory(path2, (boolean)var1_1);
    }

    public static boolean isSub(Path parent, Path sub) {
        Path path;
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(path));
    }

    public static Path toAbsNormal(Path path) {
        Path path2;
        Assert.notNull(path);
        return path2.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Path mkdir(Path dir) {
        Path path;
        if (dir != null && !PathUtil.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
        }
        return path;
    }

    public static Path mkParentDirs(Path path) {
        return PathUtil.mkdir(path.getParent());
    }

    public static String getName(Path path) {
        Path path2;
        if (path == null) {
            return null;
        }
        return path2.getFileName().toString();
    }

    public static Path createTempFile(String prefix, String suffix, Path dir) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                if (dir == null) {
                    return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                }
                return Files.createTempFile(PathUtil.mkdir(dir), prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void delFile(Path path) throws IOException {
        try {
            Files.delete(path);
            return;
        }
        catch (AccessDeniedException e) {
            Path path2;
            if (!path2.toFile().delete()) {
                void var1_1;
                throw var1_1;
            }
            return;
        }
    }

    public static LinkOption[] getLinkOptions(boolean isFollowLinks) {
        if (isFollowLinks) {
            return new LinkOption[0];
        }
        return new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    }

    public static Set<FileVisitOption> getFileVisitOption(boolean isFollowLinks) {
        if (isFollowLinks) {
            return EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        }
        return EnumSet.noneOf(FileVisitOption.class);
    }
}

