/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.PathUtil;
import cn.hutool.core.io.file.visitor.MoveVisitor;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class PathMover {
    private final Path src;
    private final Path target;
    private final CopyOption[] options;

    /*
     * WARNING - void declaration
     */
    public static PathMover of(Path src, Path target, boolean isOverride) {
        void var1_1;
        CopyOption[] copyOptionArray;
        void var2_2;
        if (var2_2 != false) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathMover.of(src, (Path)var1_1, copyOptionArray);
    }

    /*
     * WARNING - void declaration
     */
    public static PathMover of(Path src, Path target, CopyOption[] options) {
        void var2_2;
        void var1_1;
        Path path;
        return new PathMover(path, (Path)var1_1, (CopyOption[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public PathMover(Path src, Path target, CopyOption[] options) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!PathUtil.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = var1_1;
        this.target = (Path)Assert.notNull(var2_2, "Target path must be not null !", new Object[0]);
        this.options = ObjUtil.defaultIfNull(var3_3, new CopyOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Path move() {
        Path src = this.src;
        Path target = this.target;
        CopyOption[] options = this.options;
        if (PathUtil.isSub(src, target)) {
            if (Files.exists(target, new LinkOption[0]) && PathUtil.equals(src, target)) {
                return target;
            }
            throw new IllegalArgumentException(StrUtil.format("Target [{}] is sub path of src [{}]!", target, src));
        }
        if (PathUtil.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        PathUtil.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException iOException) {
            void var2_2;
            void var1_1;
            void var3_3;
            IOException e = iOException;
            if (iOException instanceof FileAlreadyExistsException || e instanceof AccessDeniedException) {
                throw new IORuntimeException(e);
            }
            PathMover.walkMove(src, target, (CopyOption[])var3_3);
            PathUtil.del((Path)var1_1);
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Path moveContent() {
        void var2_2;
        void var3_3;
        void var1_1;
        Path src = this.src;
        if (PathUtil.isExistsAndNotDirectory(this.target, false)) {
            return this.move();
        }
        Path target = this.target;
        if (PathUtil.isExistsAndNotDirectory(target, false)) {
            throw new IllegalArgumentException("Can not move dir content to a file");
        }
        if (PathUtil.equals(src, target)) {
            return target;
        }
        CopyOption[] options = this.options;
        PathUtil.mkParentDirs(target);
        PathMover.walkMove((Path)var1_1, target, (CopyOption[])var3_3);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void walkMove(Path src, Path target, CopyOption ... options) {
        try {
            void var2_3;
            void var1_2;
            Files.walkFileTree(src, new MoveVisitor(src, (Path)var1_2, (CopyOption[])var2_3));
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }
}

