/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileWrapper;
import cn.hutool.core.io.file.LineSeparator;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Map;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    public static FileWriter create(File file, Charset charset) {
        void var1_1;
        File file2;
        return new FileWriter(file2, (Charset)var1_1);
    }

    public static FileWriter create(File file) {
        File file2;
        return new FileWriter(file2);
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(File file, Charset charset) {
        super((File)var1_1, (Charset)var2_2);
        void var2_2;
        void var1_1;
        this.checkFile();
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(File file, String charset) {
        this((File)var1_1, CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(String filePath, Charset charset) {
        this(FileUtil.file((String)var1_1), (Charset)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(String filePath, String charset) {
        this(FileUtil.file((String)var1_1), CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(File file) {
        this((File)var1_1, DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileWriter(String filePath) {
        this((String)var1_1, DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public File write(String content, boolean isAppend) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            void var2_4;
            writer = this.getWriter((boolean)var2_4);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            try {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                throw throwable;
            }
        }
        IoUtil.close(writer);
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public File write(String content) throws IORuntimeException {
        void var1_1;
        return this.write((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public File append(String content) throws IORuntimeException {
        void var1_1;
        return this.write((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public <T> File writeLines(Iterable<T> list) throws IORuntimeException {
        void var1_1;
        return this.writeLines((Iterable<T>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public <T> File appendLines(Iterable<T> list) throws IORuntimeException {
        void var1_1;
        return this.writeLines((Iterable<T>)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public <T> File writeLines(Iterable<T> list, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return this.writeLines((Iterable<T>)var1_1, null, (boolean)var2_2);
    }

    public <T> File writeLines(Iterable<T> list, LineSeparator lineSeparator, boolean isAppend) throws IORuntimeException {
        PrintWriter writer = this.getPrintWriter(isAppend);
        Throwable throwable = null;
        try {
            Iterator iterator;
            boolean isFirst = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t;
                block16: {
                    block15: {
                        t = iterator.next();
                        if (t == null) continue;
                        if (!isFirst) break block15;
                        isFirst = false;
                        if (!isAppend || !FileUtil.isNotEmpty(this.file)) break block16;
                    }
                    this.printNewLine(writer, lineSeparator);
                }
                writer.print(t);
                writer.flush();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
                throw throwable4;
            }
        }
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public File writeMap(Map<?, ?> map, String kvSeparator, boolean isAppend) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeMap((Map<?, ?>)var1_1, null, (String)var2_2, (boolean)var3_3);
    }

    public File writeMap(Map<?, ?> map, LineSeparator lineSeparator, String kvSeparator, boolean isAppend) throws IORuntimeException {
        Throwable throwable;
        if (kvSeparator == null) {
            kvSeparator = " = ";
        }
        PrintWriter writer = this.getPrintWriter(isAppend);
        Throwable throwable2 = null;
        try {
            for (Map.Entry entry : throwable.entrySet()) {
                if (entry == null) continue;
                writer.print(StrUtil.format("{}{}{}", entry.getKey(), kvSeparator, entry.getValue()));
                this.printNewLine(writer, lineSeparator);
                writer.flush();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (writer != null) {
                    if (throwable2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
                throw throwable4;
            }
        }
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public File write(byte[] data, int off, int len) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.write((byte[])var1_1, (int)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public File append(byte[] data, int off, int len) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.write((byte[])var1_1, (int)var2_2, (int)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    public File write(byte[] data, int off, int len, boolean isAppend) throws IORuntimeException {
        try {
            Throwable throwable;
            FileOutputStream out = new FileOutputStream(FileUtil.touch(this.file), isAppend);
            Throwable throwable2 = null;
            try {
                void var3_5;
                void var2_3;
                out.write((byte[])throwable, (int)var2_3, (int)var3_5);
                out.flush();
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throwable2 = throwable3;
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    if (throwable2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                    throw throwable4;
                }
            }
            out.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public File writeFromStream(InputStream in) throws IORuntimeException {
        void var1_1;
        return this.writeFromStream((InputStream)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public File writeFromStream(InputStream in, boolean isCloseIn) throws IORuntimeException {
        OutputStream out = null;
        try {
            out = Files.newOutputStream(FileUtil.touch(this.file).toPath(), new OpenOption[0]);
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                void var2_2;
                void var3_3;
                IoUtil.close((Closeable)var3_3);
                if (var2_2 != false) {
                    void var1_1;
                    IoUtil.close((Closeable)var1_1);
                }
                throw throwable;
            }
        }
        IoUtil.close(out);
        if (isCloseIn) {
            IoUtil.close(in);
        }
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedOutputStream getOutputStream() throws IORuntimeException {
        try {
            return new BufferedOutputStream(Files.newOutputStream(FileUtil.touch(this.file).toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BufferedWriter getWriter(boolean isAppend) throws IORuntimeException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PrintWriter getPrintWriter(boolean isAppend) throws IORuntimeException {
        void var1_1;
        return new PrintWriter(this.getWriter((boolean)var1_1));
    }

    private void checkFile() throws IORuntimeException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printNewLine(PrintWriter writer, LineSeparator lineSeparator) {
        void var2_2;
        void var1_1;
        if (lineSeparator == null) {
            writer.println();
            return;
        }
        var1_1.print(var2_2.getValue());
    }
}

