/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileWrapper;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    public static FileReader create(File file, Charset charset) {
        void var1_1;
        File file2;
        return new FileReader(file2, (Charset)var1_1);
    }

    public static FileReader create(File file) {
        File file2;
        return new FileReader(file2);
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(File file, Charset charset) {
        super((File)var1_1, (Charset)var2_2);
        void var2_2;
        void var1_1;
        this.checkFile();
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(File file, String charset) {
        this((File)var1_1, CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(String filePath, Charset charset) {
        this(FileUtil.file((String)var1_1), (Charset)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(String filePath, String charset) {
        this(FileUtil.file((String)var1_1), CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(File file) {
        this((File)var1_1, DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileReader(String filePath) {
        this((String)var1_1, DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes() throws IORuntimeException {
        void var3_4;
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(StrUtil.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return var3_4;
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        void var1_1;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtil.getReader(this.file, this.charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
        }
        catch (IOException e) {
            try {
                void var3_5;
                throw new IORuntimeException((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                IoUtil.close((Closeable)var2_3);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void readLines(LineHandler lineHandler) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            void var1_1;
            reader = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)reader, (LineHandler)var1_1);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(reader);
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public <T> T read(ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var1_1;
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            T result = readerHandler.handle(reader);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable e2) {
                void result;
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw result;
            }
        }
        IoUtil.close(reader);
        return var1_1;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoUtil.getReader((InputStream)this.getInputStream(), this.charset);
    }

    /*
     * WARNING - void declaration
     */
    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long writeToStream(OutputStream out) throws IORuntimeException {
        void var1_1;
        return this.writeToStream((OutputStream)var1_1, false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public long writeToStream(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        long l;
        Throwable throwable;
        FileInputStream in2222;
        block14: {
            in2222 = new FileInputStream(this.file);
            throwable = null;
            l = IoUtil.copy((InputStream)in2222, out);
            in2222.close();
            if (!isCloseOut) break block14;
            IoUtil.close(out);
        }
        return l;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable != null) {
                                try {
                                    in2222.close();
                                }
                                catch (Throwable in2222) {
                                    throwable.addSuppressed(in2222);
                                }
                            } else {
                                in2222.close();
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        void var3_5;
                        throw new IORuntimeException((Throwable)var3_5);
                    }
                }
                catch (Throwable throwable5) {
                    void var2_2;
                    if (var2_2 != false) {
                        void var1_1;
                        IoUtil.close((Closeable)var1_1);
                    }
                    throw throwable5;
                }
            }
        }
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

