/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.regex.Pattern;

public class FileNameUtil {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_JAR = ".jar";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|\r\n]");
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};

    public static String getName(File file) {
        if (file != null) {
            File file2;
            return file2.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(String filePath) {
        void var1_1;
        void var2_2;
        String string;
        if (filePath == null) {
            return null;
        }
        int len = filePath.length();
        if (len == 0) {
            return filePath;
        }
        if (CharUtil.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = filePath.charAt(i);
            if (!CharUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return string.substring((int)var2_2, (int)var1_1);
    }

    public static String getSuffix(File file) {
        return FileNameUtil.extName(file);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static String getPrefix(File file) {
        return FileNameUtil.mainName(file);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtil.mainName(fileName);
    }

    public static String mainName(File file) {
        File file2;
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileNameUtil.mainName(file2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String mainName(String fileName) {
        void var2_3;
        String string;
        if (fileName == null) {
            return null;
        }
        int len = fileName.length();
        if (len == 0) {
            return fileName;
        }
        CharSequence[] charSequenceArray = SPECIAL_SUFFIX;
        int n = SPECIAL_SUFFIX.length;
        for (int i = 0; i < n; ++i) {
            CharSequence specialSuffix = charSequenceArray[i];
            if (!StrUtil.endWith((CharSequence)fileName, "." + specialSuffix)) continue;
            return StrUtil.subPre(fileName, len - specialSuffix.length() - 1);
        }
        if (CharUtil.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (!CharUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return string.substring((int)var2_3, n);
    }

    public static String extName(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileNameUtil.extName(file2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String extName(String fileName) {
        String string;
        void var1_1;
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, index).lastIndexOf(".");
        String substr = fileName.substring(secondToLastIndex == -1 ? index : secondToLastIndex + 1);
        if (StrUtil.containsAny((CharSequence)substr, SPECIAL_SUFFIX)) {
            void var2_3;
            return var2_3;
        }
        String ext = fileName.substring((int)(var1_1 + true));
        if (StrUtil.containsAny((CharSequence)ext, '/', '\\')) {
            return "";
        }
        return string;
    }

    public static String cleanInvalid(String fileName) {
        String string;
        if (StrUtil.isBlank(fileName)) {
            return fileName;
        }
        return ReUtil.delAll(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)string);
    }

    public static boolean containsInvalid(String fileName) {
        String string;
        return false == StrUtil.isBlank(fileName) && ReUtil.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isType(String fileName, String ... extNames) {
        void var1_1;
        return StrUtil.equalsAnyIgnoreCase(FileNameUtil.extName(fileName), (CharSequence[])var1_1);
    }
}

