/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.copier.SrcToDestCopier;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class FileCopier
extends SrcToDestCopier<File, FileCopier> {
    private static final long serialVersionUID = 1L;
    private boolean isOverride;
    private boolean isCopyAttributes;
    private boolean isCopyContentIfDir;
    private boolean isOnlyCopyFile;

    /*
     * WARNING - void declaration
     */
    public static FileCopier create(String srcPath, String destPath) {
        void var1_1;
        String string;
        return new FileCopier(FileUtil.file(string), FileUtil.file((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static FileCopier create(File src, File dest) {
        void var1_1;
        File file;
        return new FileCopier(file, (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FileCopier(File src, File dest) {
        void var2_2;
        void var1_1;
        this.src = var1_1;
        this.dest = var2_2;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    /*
     * WARNING - void declaration
     */
    public FileCopier setOverride(boolean isOverride) {
        void var1_1;
        this.isOverride = var1_1;
        return this;
    }

    public boolean isCopyAttributes() {
        return this.isCopyAttributes;
    }

    /*
     * WARNING - void declaration
     */
    public FileCopier setCopyAttributes(boolean isCopyAttributes) {
        void var1_1;
        this.isCopyAttributes = var1_1;
        return this;
    }

    public boolean isCopyContentIfDir() {
        return this.isCopyContentIfDir;
    }

    /*
     * WARNING - void declaration
     */
    public FileCopier setCopyContentIfDir(boolean isCopyContentIfDir) {
        void var1_1;
        this.isCopyContentIfDir = var1_1;
        return this;
    }

    public boolean isOnlyCopyFile() {
        return this.isOnlyCopyFile;
    }

    /*
     * WARNING - void declaration
     */
    public FileCopier setOnlyCopyFile(boolean isOnlyCopyFile) {
        void var1_1;
        this.isOnlyCopyFile = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public File copy() throws IORuntimeException {
        void var2_2;
        File src = (File)this.src;
        File dest = (File)this.dest;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new IORuntimeException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(src, dest)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", src, dest);
        }
        if (src.isDirectory()) {
            void var3_3;
            if (dest.exists() && !dest.isDirectory()) {
                throw new IORuntimeException("Src is a directory but dest is a file!");
            }
            if (FileUtil.isSub(src, dest)) {
                throw new IORuntimeException("Dest is a sub directory of src !");
            }
            File subTarget = this.isCopyContentIfDir ? dest : FileUtil.mkdir(FileUtil.file(dest, src.getName()));
            this.internalCopyDirContent(src, (File)var3_3);
        } else {
            void var1_1;
            dest = this.internalCopyFile((File)var1_1, dest);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void internalCopyDirContent(File src, File dest) throws IORuntimeException {
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        } else if (!dest.isDirectory()) {
            throw new IORuntimeException(StrUtil.format("Src [{}] is a directory but dest [{}] is a file!", src.getPath(), dest.getPath()));
        }
        String[] files = src.list();
        if (ArrayUtil.isNotEmpty(files)) {
            String[] stringArray = files;
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                void var3_3;
                File destFile;
                String file = stringArray[i];
                File srcFile = new File(src, file);
                File file2 = destFile = this.isOnlyCopyFile ? dest : new File(dest, file);
                if (srcFile.isDirectory()) {
                    this.internalCopyDirContent(srcFile, destFile);
                    continue;
                }
                this.internalCopyFile((File)var3_3, destFile);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private File internalCopyFile(File src, File dest) throws IORuntimeException {
        void var2_3;
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return src;
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (dest.exists() && !this.isOverride) {
                return src;
            }
        } else {
            FileUtil.mkParentDirs(dest);
        }
        ArrayList<StandardCopyOption> optionList = new ArrayList<StandardCopyOption>(2);
        if (this.isOverride) {
            optionList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.isCopyAttributes) {
            optionList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        try {
            void var3_4;
            Files.copy(src.toPath(), dest.toPath(), var3_4.toArray(new CopyOption[0]));
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return var2_3;
    }
}

