/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.thread.lock.LockUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class FileAppender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FileWriter writer;
    private final int capacity;
    private final boolean isNewLineMode;
    private final List<String> list;
    private final Lock lock;

    /*
     * WARNING - void declaration
     */
    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this((File)var1_1, CharsetUtil.CHARSET_UTF_8, (int)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode) {
        this((File)var1_1, (Charset)var2_2, (int)var3_3, isNewLineMode, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode, Lock lock) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.capacity = capacity;
        this.list = new ArrayList<String>((int)var3_3);
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.create((File)var1_1, (Charset)var2_2);
        this.lock = ObjectUtil.defaultIfNull(lock, LockUtil::getNoLock);
    }

    /*
     * WARNING - void declaration
     */
    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.lock.lock();
        try {
            void var1_1;
            this.list.add((String)var1_1);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public FileAppender flush() {
        this.lock.lock();
        try {
            PrintWriter pw2 = this.writer.getPrintWriter(true);
            Throwable throwable = null;
            try {
                for (String str : this.list) {
                    pw2.print(str);
                    if (!this.isNewLineMode) continue;
                    pw2.println();
                }
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (pw2 != null) {
                        if (throwable != null) {
                            try {
                                pw2.close();
                            }
                            catch (Throwable pw2) {
                                throwable.addSuppressed(pw2);
                            }
                        } else {
                            void var1_1;
                            var1_1.close();
                        }
                    }
                    throw throwable4;
                }
            }
            this.list.clear();
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }
}

