/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.copy;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.io.copy.IoCopier;
import cn.hutool.core.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopier
extends IoCopier<InputStream, OutputStream> {
    public StreamCopier() {
        this(8192);
    }

    /*
     * WARNING - void declaration
     */
    public StreamCopier(int bufferSize) {
        this((int)var1_1, -1L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamCopier(int bufferSize, long count) {
        this((int)var1_1, (long)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamCopier(int bufferSize, long count, StreamProgress progress) {
        super((int)var1_1, (long)var2_2, progress);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long copy(InputStream source, OutputStream target) {
        long size;
        Assert.notNull(source, "InputStream is null !", new Object[0]);
        Assert.notNull(target, "OutputStream is null !", new Object[0]);
        StreamProgress progress = this.progress;
        if (progress != null) {
            progress.start();
        }
        try {
            void var2_3;
            StreamCopier streamCopier = this;
            size = this.doCopy(source, target, new byte[streamCopier.bufferSize(streamCopier.count)], progress);
            var2_3.flush();
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        if (progress != null) {
            void var3_4;
            var3_4.finish();
        }
        return size;
    }

    private long doCopy(InputStream source, OutputStream target, byte[] buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            if (this.flushEveryBuffer) {
                target.flush();
            }
            numToRead -= (long)read;
            total += (long)read;
            if (progress == null) continue;
            progress.progress(this.count, total);
        }
        return total;
    }
}

