/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.copy;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.io.copy.IoCopier;
import cn.hutool.core.lang.Assert;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelCopier
extends IoCopier<ReadableByteChannel, WritableByteChannel> {
    public ChannelCopier() {
        this(8192);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelCopier(int bufferSize) {
        this((int)var1_1, -1L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelCopier(int bufferSize, long count) {
        this((int)var1_1, (long)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelCopier(int bufferSize, long count, StreamProgress progress) {
        super((int)var1_1, (long)var2_2, progress);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long copy(ReadableByteChannel source, WritableByteChannel target) {
        long size;
        Assert.notNull(source, "InputStream is null !", new Object[0]);
        Assert.notNull(target, "OutputStream is null !", new Object[0]);
        StreamProgress progress = this.progress;
        if (progress != null) {
            progress.start();
        }
        try {
            void var2_3;
            ChannelCopier channelCopier = this;
            size = this.doCopy(source, (WritableByteChannel)var2_3, ByteBuffer.allocate(channelCopier.bufferSize(channelCopier.count)), progress);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        if (progress != null) {
            void var3_4;
            var3_4.finish();
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
            if (progress == null) continue;
            progress.progress(this.count, total);
        }
        return total;
    }
}

