/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.collection.CollUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class ValidateObjectInputStream
extends ObjectInputStream {
    private Set<String> whiteClassSet;
    private Set<String> blackClassSet;

    /*
     * WARNING - void declaration
     */
    public ValidateObjectInputStream(InputStream inputStream, Class<?> ... acceptClasses) throws IOException {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        this.accept((Class<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void refuse(Class<?> ... refuseClasses) {
        void var1_1;
        if (this.blackClassSet == null) {
            this.blackClassSet = new HashSet<String>();
        }
        for (void acceptClass : var1_1) {
            this.blackClassSet.add(acceptClass.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void accept(Class<?> ... acceptClasses) {
        void var1_1;
        if (this.whiteClassSet == null) {
            this.whiteClassSet = new HashSet<String>();
        }
        for (void acceptClass : var1_1) {
            this.whiteClassSet.add(acceptClass.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        void var1_1;
        this.validateClassName(desc.getName());
        return super.resolveClass((ObjectStreamClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void validateClassName(String className) throws InvalidClassException {
        void var1_1;
        if (CollUtil.isNotEmpty(this.blackClassSet) && this.blackClassSet.contains(className)) {
            throw new InvalidClassException("Unauthorized deserialization attempt by black list", className);
        }
        if (CollUtil.isEmpty(this.whiteClassSet)) {
            return;
        }
        if (className.startsWith("java.")) {
            return;
        }
        if (this.whiteClassSet.contains(className)) {
            return;
        }
        throw new InvalidClassException("Unauthorized deserialization attempt", (String)var1_1);
    }
}

