/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.io.copy.ChannelCopier;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public class NioUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    /*
     * WARNING - void declaration
     */
    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return NioUtil.copyByNIO(in, (OutputStream)var1_1, (int)var2_2, -1L, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        long copySize = NioUtil.copy(Channels.newChannel(in), Channels.newChannel(out), (int)var2_2, (long)var3_3, streamProgress);
        IoUtil.flush((Flushable)var1_1);
        return copySize;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(FileChannel inChannel, FileChannel outChannel) throws IORuntimeException {
        Assert.notNull(inChannel, "In channel is null!", new Object[0]);
        Assert.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            void var1_2;
            return NioUtil.copySafely(inChannel, (FileChannel)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static long copySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        void var2_2;
        long writeBytes;
        long totalBytes = inChannel.size();
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IORuntimeException {
        void var1_1;
        return NioUtil.copy(in, (WritableByteChannel)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return NioUtil.copy(in, (WritableByteChannel)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return NioUtil.copy(in, (WritableByteChannel)var1_1, (int)var2_2, -1L, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        void var1_1;
        ReadableByteChannel readableByteChannel;
        void var3_3;
        void var2_2;
        return new ChannelCopier((int)var2_2, (long)var3_3, streamProgress).copy(readableByteChannel, (WritableByteChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String read(ReadableByteChannel channel, Charset charset) throws IORuntimeException {
        void var1_1;
        Closeable closeable;
        Closeable out = NioUtil.read(channel);
        if (charset == null) {
            return ((FastByteArrayOutputStream)out).toString();
        }
        return ((FastByteArrayOutputStream)closeable).toString((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IORuntimeException {
        void var1_1;
        ReadableByteChannel readableByteChannel;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        NioUtil.copy(readableByteChannel, Channels.newChannel(out));
        return var1_1;
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String read(FileChannel fileChannel, String charsetName) throws IORuntimeException {
        void var1_1;
        return NioUtil.read(fileChannel, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        void var1_2;
        MappedByteBuffer mappedByteBuffer;
        try {
            MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StrUtil.str((ByteBuffer)mappedByteBuffer, (Charset)var1_2);
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                AutoCloseable autoCloseable;
                autoCloseable.close();
                return;
            }
            catch (Exception exception) {}
        }
    }
}

