/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.collection.LineIter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.BOMInputStream;
import cn.hutool.core.io.BomReader;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.NioUtil;
import cn.hutool.core.io.NullOutputStream;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.io.ValidateObjectInputStream;
import cn.hutool.core.io.copy.ReaderWriterCopier;
import cn.hutool.core.io.copy.StreamCopier;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class IoUtil
extends NioUtil {
    /*
     * WARNING - void declaration
     */
    public static long copy(Reader reader, Writer writer) throws IORuntimeException {
        void var1_1;
        return IoUtil.copy(reader, (Writer)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(Reader reader, Writer writer, int bufferSize) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return IoUtil.copy(reader, (Writer)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return IoUtil.copy(reader, (Writer)var1_1, (int)var2_2, -1L, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(Reader reader, Writer writer, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        void var1_1;
        Reader reader2;
        void var3_3;
        void var2_2;
        return new ReaderWriterCopier((int)var2_2, (long)var3_3, streamProgress).copy(reader2, (Writer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        void var1_1;
        return IoUtil.copy(in, (OutputStream)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return IoUtil.copy(in, (OutputStream)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return IoUtil.copy(in, (OutputStream)var1_1, (int)var2_2, -1L, (StreamProgress)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        void var1_1;
        InputStream inputStream;
        void var3_3;
        void var2_2;
        return new StreamCopier((int)var2_2, (long)var3_3, streamProgress).copy(inputStream, (OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        long l;
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            void var1_2;
            FileInputStream fileInputStream;
            inChannel = fileInputStream.getChannel();
            outChannel = var1_2.getChannel();
            l = IoUtil.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            void var2_3;
            void var3_4;
            IoUtil.close((Closeable)var3_4);
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(outChannel);
        IoUtil.close(inChannel);
        return l;
    }

    public static BufferedReader getUtf8Reader(InputStream in) {
        return IoUtil.getReader(in, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static BufferedReader getReader(InputStream in, String charsetName) {
        void var1_1;
        return IoUtil.getReader(in, Charset.forName((String)var1_1));
    }

    public static BufferedReader getReader(BOMInputStream in) {
        BOMInputStream bOMInputStream = in;
        return IoUtil.getReader((InputStream)bOMInputStream, bOMInputStream.getCharset());
    }

    public static BomReader getBomReader(InputStream in) {
        InputStream inputStream;
        return new BomReader(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getReader(InputStream in, Charset charset) {
        Closeable closeable;
        void var1_1;
        Closeable reader;
        if (in == null) {
            return null;
        }
        reader = charset == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)reader, (Charset)var1_1);
        return new BufferedReader((Reader)closeable);
    }

    public static BufferedReader getReader(Reader reader) {
        Reader reader2;
        if (reader == null) {
            return null;
        }
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader2);
    }

    /*
     * WARNING - void declaration
     */
    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        void var1_1;
        Reader reader2;
        if (reader instanceof PushbackReader) {
            return (PushbackReader)reader;
        }
        return new PushbackReader(reader2, (int)var1_1);
    }

    public static OutputStreamWriter getUtf8Writer(OutputStream out) {
        return IoUtil.getWriter(out, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        void var1_1;
        return IoUtil.getWriter(out, Charset.forName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        void var1_1;
        OutputStream outputStream;
        if (out == null) {
            return null;
        }
        if (charset == null) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(outputStream, (Charset)var1_1);
    }

    public static String readUtf8(InputStream in) throws IORuntimeException {
        return IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String read(InputStream in, String charsetName) throws IORuntimeException {
        void var1_1;
        Closeable closeable;
        Closeable out = IoUtil.read(in);
        if (StrUtil.isBlank(charsetName)) {
            return ((FastByteArrayOutputStream)out).toString();
        }
        return ((FastByteArrayOutputStream)closeable).toString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        void var1_1;
        return StrUtil.str(IoUtil.readBytes(in), (Charset)var1_1);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IORuntimeException {
        return IoUtil.read(in, true);
    }

    /*
     * WARNING - void declaration
     */
    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IORuntimeException {
        void var2_3;
        InputStream inputStream;
        FastByteArrayOutputStream out;
        if (in instanceof FileInputStream) {
            try {
                out = new FastByteArrayOutputStream(in.available());
            }
            catch (IOException e) {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
        } else {
            out = new FastByteArrayOutputStream();
        }
        try {
            IoUtil.copy(inputStream, out);
        }
        finally {
            if (isClose) {
                IoUtil.close(inputStream);
            }
        }
        return var2_3;
    }

    public static String read(Reader reader) throws IORuntimeException {
        return IoUtil.read(reader, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        void var2_2;
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
            if (!isClose) return var2_2.toString();
        }
        catch (IOException e) {
            try {
                void var2_3;
                throw new IORuntimeException((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                Reader reader2;
                void var1_1;
                if (var1_1 == false) throw throwable;
                IoUtil.close(reader2);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return var2_2.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return IoUtil.readBytes(in, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        void var1_1;
        return IoUtil.read(in, (boolean)var1_1).toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(InputStream in, int length) throws IORuntimeException {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        if (in == null) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(length);
        IoUtil.copy(inputStream, out, 8192, (long)var1_1, null);
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(IoUtil.readBytes(in, (int)var1_1), (boolean)var2_2);
    }

    public static String readHex64Upper(InputStream in) throws IORuntimeException {
        return IoUtil.readHex(in, 64, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String readHex8192Upper(InputStream in) throws IORuntimeException {
        try {
            in.available();
            return IoUtil.readHex(in, Math.min(8192, in.available()), false);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static String readHex64Lower(InputStream in) throws IORuntimeException {
        return IoUtil.readHex(in, 64, true);
    }

    public static <T> T readObj(InputStream in) throws IORuntimeException, UtilException {
        return IoUtil.readObj(in, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T readObj(InputStream in, Class<T> clazz) throws IORuntimeException, UtilException {
        try {
            void var1_2;
            return IoUtil.readObj(in instanceof ValidateObjectInputStream ? (ValidateObjectInputStream)in : new ValidateObjectInputStream(in, new Class[0]), var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T readObj(ValidateObjectInputStream in, Class<T> clazz) throws IORuntimeException, UtilException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (clazz != null) {
            void var1_3;
            in.accept(new Class[]{var1_3});
        }
        try {
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            void var0_2;
            throw new UtilException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws IORuntimeException {
        void var1_1;
        return IoUtil.readLines(in, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return IoUtil.readLines(in, CharsetUtil.charset((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return IoUtil.readLines((Reader)IoUtil.getReader(in, (Charset)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws IORuntimeException {
        void var1_1;
        IoUtil.readLines(reader, collection::add);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void readUtf8Lines(InputStream in, LineHandler lineHandler) throws IORuntimeException {
        void var1_1;
        IoUtil.readLines(in, CharsetUtil.CHARSET_UTF_8, (LineHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void readLines(InputStream in, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        IoUtil.readLines((Reader)IoUtil.getReader(in, (Charset)var1_1), (LineHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void readLines(Reader reader, LineHandler lineHandler) throws IORuntimeException {
        Object object;
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        for (String line : IoUtil.lineIter((Reader)object)) {
            void var2_2;
            lineHandler.handle((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static ByteArrayInputStream toStream(String content, String charsetName) {
        void var1_1;
        return IoUtil.toStream(content, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteArrayInputStream toStream(String content, Charset charset) {
        void var1_1;
        String string;
        if (content == null) {
            return null;
        }
        return IoUtil.toStream(StrUtil.bytes((CharSequence)string, (Charset)var1_1));
    }

    public static ByteArrayInputStream toUtf8Stream(String content) {
        return IoUtil.toStream(content, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        byte[] byArray;
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static ByteArrayInputStream toStream(ByteArrayOutputStream out) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        InputStream inputStream;
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedInputStream toBuffered(InputStream in, int bufferSize) {
        void var1_1;
        InputStream inputStream;
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(inputStream, (int)var1_1);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        OutputStream outputStream;
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        if (out instanceof BufferedOutputStream) {
            return (BufferedOutputStream)out;
        }
        return new BufferedOutputStream(outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedOutputStream toBuffered(OutputStream out, int bufferSize) {
        void var1_1;
        OutputStream outputStream;
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        if (out instanceof BufferedOutputStream) {
            return (BufferedOutputStream)out;
        }
        return new BufferedOutputStream(outputStream, (int)var1_1);
    }

    public static BufferedReader toBuffered(Reader reader) {
        Reader reader2;
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader toBuffered(Reader reader, int bufferSize) {
        void var1_1;
        Reader reader2;
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader2, (int)var1_1);
    }

    public static BufferedWriter toBuffered(Writer writer) {
        Writer writer2;
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedWriter toBuffered(Writer writer, int bufferSize) {
        void var1_1;
        Writer writer2;
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer2, (int)var1_1);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        InputStream inputStream;
        if (in == null) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        void var1_1;
        InputStream inputStream;
        if (in instanceof PushbackInputStream) {
            return (PushbackInputStream)in;
        }
        return new PushbackInputStream(inputStream, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream toAvailableStream(InputStream in) {
        InputStream inputStream;
        if (in instanceof FileInputStream) {
            return in;
        }
        InputStream pushbackInputStream = IoUtil.toPushbackStream(in, 1);
        try {
            int n = ((PushbackInputStream)pushbackInputStream).available();
            if (n <= 0) {
                int b = ((PushbackInputStream)pushbackInputStream).read();
                ((PushbackInputStream)pushbackInputStream).unread(b);
            }
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        try {
            out.write(content);
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                void var2_3;
                throw new IORuntimeException((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                OutputStream outputStream;
                void var1_1;
                if (var1_1 == false) throw throwable;
                IoUtil.close(outputStream);
                throw throwable;
            }
        }
        IoUtil.close(out);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUtf8(OutputStream out, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        void var2_2;
        void var1_1;
        IoUtil.write(out, CharsetUtil.CHARSET_UTF_8, (boolean)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void write(OutputStream out, String charsetName, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        IoUtil.write(out, CharsetUtil.charset((String)var1_1), (boolean)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        OutputStreamWriter osw = null;
        try {
            void var3_6;
            void var1_3;
            osw = IoUtil.getWriter(out, (Charset)var1_3);
            for (OutputStream content : var3_6) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var2_5;
                if (var2_5 == false) throw throwable;
                IoUtil.close(osw);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeObj(OutputStream out, boolean isCloseOut, Serializable obj) throws IORuntimeException {
        void var2_2;
        void var1_1;
        IoUtil.writeObjects(out, (boolean)var1_1, new Serializable[]{var2_2});
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            void var2_4;
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (OutputStream content : var2_4) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var3_6;
                void var1_3;
                if (var1_3 == false) throw throwable;
                IoUtil.close((Closeable)var3_6);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                Flushable flushable2;
                flushable2.flush();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                Closeable closeable2;
                closeable2.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeIfPosible(Object obj) {
        if (obj instanceof AutoCloseable) {
            Object object;
            IoUtil.close((AutoCloseable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contentEquals(InputStream input1, InputStream input2) throws IORuntimeException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            void var1_1;
            int n;
            int ch = input1.read();
            while (-1 != ch) {
                int ch2 = input2.read();
                if (ch != n) {
                    return false;
                }
                ch = input1.read();
            }
            n = var1_1.read();
            return n == -1;
        }
        catch (IOException e) {
            void var2_3;
            throw new IORuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contentEquals(Reader input1, Reader input2) throws IORuntimeException {
        input1 = IoUtil.getReader(input1);
        input2 = IoUtil.getReader(input2);
        try {
            void var1_1;
            int n;
            int ch = input1.read();
            while (-1 != ch) {
                int ch2 = input2.read();
                if (ch != n) {
                    return false;
                }
                ch = input1.read();
            }
            n = var1_1.read();
            return n == -1;
        }
        catch (IOException e) {
            void var2_3;
            throw new IORuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IORuntimeException {
        Reader br1 = IoUtil.getReader(input1);
        BufferedReader br2 = IoUtil.getReader(input2);
        try {
            void var3_4;
            String line1 = ((BufferedReader)br1).readLine();
            String line2 = br2.readLine();
            while (line1 != null && line1.equals(line2)) {
                line1 = ((BufferedReader)br1).readLine();
                line2 = br2.readLine();
            }
            return Objects.equals(line1, var3_4);
        }
        catch (IOException e) {
            void var2_3;
            throw new IORuntimeException((Throwable)var2_3);
        }
    }

    public static long checksumCRC32(InputStream in) throws IORuntimeException {
        return IoUtil.checksum(in, new CRC32()).getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static Checksum checksum(InputStream in, Checksum checksum2) throws IORuntimeException {
        void var1_1;
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (checksum2 == null) {
            checksum2 = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum2);
            IoUtil.copy(in, new NullOutputStream());
        }
        catch (Throwable checksum2) {
            InputStream inputStream;
            IoUtil.close(inputStream);
            throw checksum2;
        }
        IoUtil.close(in);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long checksumValue(InputStream in, Checksum checksum) {
        void var1_1;
        return IoUtil.checksum(in, (Checksum)var1_1).getValue();
    }

    public static LineIter lineIter(Reader reader) {
        Reader reader2;
        return new LineIter(reader2);
    }

    /*
     * WARNING - void declaration
     */
    public static LineIter lineIter(InputStream in, Charset charset) {
        void var1_1;
        InputStream inputStream;
        return new LineIter(inputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(ByteArrayOutputStream out, Charset charset) {
        try {
            void var1_2;
            return out.toString(var1_2.name());
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }
}

