/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.BOMInputStream;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileCopier;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.io.file.LineSeparator;
import cn.hutool.core.io.file.PathUtil;
import cn.hutool.core.io.file.Tailer;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class FileUtil
extends PathUtil {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String PATH_SEPARATOR = File.pathSeparator;
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    /*
     * WARNING - void declaration
     */
    public static File[] ls(String path) {
        String string;
        if (path == null) {
            return null;
        }
        File file = FileUtil.file(path);
        if (file.isDirectory()) {
            void var1_1;
            return var1_1.listFiles();
        }
        throw new IORuntimeException(StrUtil.format("Path [{}] is not directory!", string));
    }

    public static boolean isEmpty(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            file = file.list();
            return ArrayUtil.isEmpty(file);
        }
        if (file.isFile()) {
            File file2;
            return file2.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        File file2;
        return false == FileUtil.isEmpty(file2);
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtil.isDirEmpty(dir.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        void var1_1;
        return FileUtil.loopFiles(FileUtil.file(path), (FileFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        void var1_1;
        return FileUtil.loopFiles(file, -1, (FileFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void walkFiles(File file, Consumer<File> consumer) {
        void var1_1;
        File[] fileArray;
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (ArrayUtil.isNotEmpty(subFiles)) {
                for (File file2 : fileArray) {
                    FileUtil.walkFiles(file2, consumer);
                }
            }
            return;
        }
        var1_1.accept(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> loopFiles(File file, int maxDepth, FileFilter fileFilter) {
        void var2_2;
        void var1_1;
        return FileUtil.loopFiles(file.toPath(), (int)var1_1, (FileFilter)var2_2);
    }

    public static List<File> loopFiles(String path) {
        return FileUtil.loopFiles(FileUtil.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileUtil.loopFiles(file, null);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> listFileNames(String path) throws IORuntimeException {
        List<String> index2;
        if (path == null) {
            return new ArrayList<String>(0);
        }
        int index2 = path.lastIndexOf(JAR_PATH_EXT);
        if (index2 < 0) {
            ArrayList<String> paths = new ArrayList<String>();
            path = index2 = FileUtil.ls((String)path);
            index2 = index2.length;
            for (int i = 0; i < index2; ++i) {
                File file = path[i];
                if (!file.isFile()) continue;
                paths.add(file.getName());
            }
            return paths;
        }
        path = FileUtil.getAbsolutePath((String)path);
        index2 += 4;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path.substring(0, index2));
            index2 = ZipUtil.listFileNames(jarFile, StrUtil.removePrefix(path.substring(index2 + 1), "/"));
        }
        catch (IOException e) {
            try {
                void var1_6;
                String string;
                throw new IORuntimeException(StrUtil.format("Can not read file path of [{}]", string), (Throwable)var1_6);
            }
            catch (Throwable throwable) {
                void var2_8;
                IoUtil.close((Closeable)var2_8);
                throw throwable;
            }
        }
        IoUtil.close(jarFile);
        return index2;
    }

    public static File newFile(String path) {
        String string;
        return new File(string);
    }

    public static File file(String path) {
        String string;
        if (path == null) {
            return null;
        }
        return new File(FileUtil.getAbsolutePath(string));
    }

    /*
     * WARNING - void declaration
     */
    public static File file(String parent, String path) {
        void var1_1;
        String string;
        return FileUtil.file(new File(string), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File file(File parent, String path) {
        void var1_1;
        File file;
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        File file2 = file;
        return FileUtil.checkSlip(file2, FileUtil.buildFile(file2, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static File file(File directory, String ... names) {
        File file;
        void var1_1;
        Assert.notNull(directory, "directory must not be null", new Object[0]);
        if (ArrayUtil.isEmpty(names)) {
            return directory;
        }
        for (void name : var1_1) {
            File file2;
            if (name == null) continue;
            file2 = FileUtil.file(file2, (String)name);
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public static File file(String ... names) {
        void var1_1;
        String[] stringArray;
        if (ArrayUtil.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : stringArray) {
            file = file == null ? FileUtil.file(name) : FileUtil.file(file, name);
        }
        return var1_1;
    }

    public static File file(URI uri) {
        URI uRI;
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uRI);
    }

    public static File file(URL url) {
        URL uRL;
        return new File(URLUtil.toURI(uRL));
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileUtil.file(FileUtil.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileUtil.file(FileUtil.getUserHomePath());
    }

    public static boolean exist(String path) {
        String string;
        return path != null && FileUtil.file(string).exists();
    }

    public static boolean exist(File file) {
        File file2;
        return file != null && file2.exists();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exist(String directory, String regexp) {
        void var0_2;
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (void var4_7 : var0_2) {
            if (!var4_7.matches((String)regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        File file2;
        if (!FileUtil.exist(file)) {
            return null;
        }
        return new Date(file2.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        String string;
        return FileUtil.lastModifiedTime(new File(string));
    }

    public static long size(File file) {
        return FileUtil.size(file, false);
    }

    /*
     * WARNING - void declaration
     */
    public static long size(File file, boolean includeDirSize) {
        File[] fileArray;
        if (file == null || !file.exists() || FileUtil.isSymlink(file)) {
            return 0L;
        }
        if (file.isDirectory()) {
            void var2_2;
            long size = includeDirSize ? file.length() : 0L;
            File[] subFiles = file.listFiles();
            if (ArrayUtil.isEmpty(subFiles)) {
                return 0L;
            }
            for (File subFile : fileArray) {
                size += FileUtil.size(subFile, includeDirSize);
            }
            return (long)var2_2;
        }
        return fileArray.length();
    }

    /*
     * WARNING - void declaration
     */
    public static int getTotalLines(File file) {
        int n;
        if (!FileUtil.isFile(file)) {
            throw new IORuntimeException("Input must be a File");
        }
        LineNumberReader lineNumberReader2 = new LineNumberReader(new java.io.FileReader(file));
        Throwable throwable = null;
        try {
            lineNumberReader2.setLineNumber(1);
            lineNumberReader2.skip(Long.MAX_VALUE);
            n = lineNumberReader2.getLineNumber();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            lineNumberReader2.close();
                        }
                        catch (Throwable lineNumberReader2) {
                            throwable.addSuppressed(lineNumberReader2);
                        }
                    } else {
                        lineNumberReader2.close();
                    }
                    throw throwable4;
                }
            }
            catch (IOException e) {
                void var0_2;
                throw new IORuntimeException((Throwable)var0_2);
            }
        }
        lineNumberReader2.close();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean newerThan(File file, File reference) {
        void var1_1;
        File file2;
        if (reference == null || !reference.exists()) {
            return true;
        }
        return FileUtil.newerThan(file2, var1_1.lastModified());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean newerThan(File file, long timeMillis) {
        void var1_1;
        File file2;
        if (file == null || !file.exists()) {
            return false;
        }
        return file2.lastModified() > var1_1;
    }

    public static File touch(String path) throws IORuntimeException {
        String string;
        if (path == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(string));
    }

    /*
     * WARNING - void declaration
     */
    public static File touch(File file) throws IORuntimeException {
        File file2;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File touch(File parent, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.touch(FileUtil.file(parent, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static File touch(String parent, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.touch(FileUtil.file(parent, (String)var1_1));
    }

    public static File mkParentDirs(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        return FileUtil.mkdir(FileUtil.getParent(file2, 1));
    }

    public static File mkParentDirs(String path) {
        String string;
        if (path == null) {
            return null;
        }
        return FileUtil.mkParentDirs(FileUtil.file(string));
    }

    public static boolean del(String fullFileOrDirPath) throws IORuntimeException {
        return FileUtil.del(FileUtil.file(fullFileOrDirPath));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean del(File file) throws IORuntimeException {
        boolean isOk;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && !(isOk = FileUtil.clean(file))) {
            return false;
        }
        Path path = file.toPath();
        try {
            FileUtil.delFile(path);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            void var1_3;
            FileUtil.del((Path)var1_3);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        return true;
    }

    public static boolean clean(String dirPath) throws IORuntimeException {
        return FileUtil.clean(FileUtil.file(dirPath));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean clean(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray;
            for (File childFile : fileArray) {
                void var3_3;
                if (FileUtil.del((File)var3_3)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean cleanEmpty(File directory) throws IORuntimeException {
        void var1_1;
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (ArrayUtil.isEmpty(files)) {
            File file;
            return file.delete();
        }
        for (File file : var1_1) {
            FileUtil.cleanEmpty(file);
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        File file;
        if (dirPath == null) {
            return null;
        }
        file = FileUtil.file((String)((Object)file));
        return FileUtil.mkdir(file);
    }

    public static File mkdir(File dir) {
        File file;
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileUtil.mkdirsSafely(dir, 5, 1L);
        }
        return file;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        File file;
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            ThreadUtil.sleep(sleepMillis);
        }
        return file.exists();
    }

    public static File createTempFile(File dir) throws IORuntimeException {
        File file;
        return FileUtil.createTempFile("hutool", null, file, true);
    }

    public static File createTempFile() throws IORuntimeException {
        return FileUtil.createTempFile("hutool", null, null, true);
    }

    /*
     * WARNING - void declaration
     */
    public static File createTempFile(String suffix, boolean isReCreat) throws IORuntimeException {
        void var1_1;
        String string;
        return FileUtil.createTempFile("hutool", string, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File createTempFile(String prefix, String suffix, boolean isReCreat) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.createTempFile(prefix, (String)var1_1, null, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File createTempFile(File dir, boolean isReCreat) throws IORuntimeException {
        void var1_1;
        File file;
        return FileUtil.createTempFile("hutool", null, file, (boolean)var1_1);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = PathUtil.createTempFile(prefix, suffix, dir == null ? null : dir.toPath()).toFile().getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        String string;
        Assert.notBlank(src, "Source File path is blank !", new Object[0]);
        Assert.notBlank(dest, "Destination File path is blank !", new Object[0]);
        return FileUtil.copyFile(Paths.get(string, new String[0]), Paths.get((String)var1_1, new String[0]), (StandardCopyOption[])var2_2).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static File copyFile(Resource src, File dest, StandardCopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        Resource resource;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        return FileUtil.copyFile(resource, var1_1.toPath(), (CopyOption[])var2_2).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static File copyFile(InputStream src, File dest, StandardCopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        return FileUtil.copyFile(inputStream, var1_1.toPath(), (CopyOption[])var2_2).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws IORuntimeException {
        void var2_2;
        void var1_1;
        File file;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new IORuntimeException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(src, dest)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", src, dest);
        }
        return FileUtil.copyFile(file.toPath(), var1_1.toPath(), (StandardCopyOption[])var2_2).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static File copy(String srcPath, String destPath, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.copy(FileUtil.file(srcPath), FileUtil.file((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File copy(File src, File dest, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileCopier.create(src, (File)var1_1).setOverride((boolean)var2_2).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static File copyContent(File src, File dest, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileCopier.create(src, (File)var1_1).setCopyContentIfDir(true).setOverride((boolean)var2_2).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static File copyFilesFromDir(File src, File dest, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileCopier.create(src, (File)var1_1).setCopyContentIfDir(true).setOnlyCopyFile(true).setOverride((boolean)var2_2).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static void move(File src, File target, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        File file;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtil.move(file.toPath(), var1_1.toPath(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void moveContent(File src, File target, boolean isOverride) throws IORuntimeException {
        void var2_2;
        void var1_1;
        File file;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtil.moveContent(file.toPath(), var1_1.toPath(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File rename(File file, String newName, boolean isOverride) {
        void var2_2;
        void var1_1;
        return FileUtil.rename(file, (String)var1_1, false, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        void var3_4;
        void var1_1;
        File file2;
        String extName;
        if (isRetainExt && StrUtil.isNotBlank(extName = FileUtil.extName(file))) {
            void var2_3;
            newName = newName.concat(".").concat((String)var2_3);
        }
        return FileUtil.rename(file2.toPath(), (String)var1_1, (boolean)var3_4).toFile();
    }

    /*
     * WARNING - void declaration
     */
    public static String getCanonicalPath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String string;
        void var1_1;
        void var2_2;
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtil.normalize(path);
            if (FileUtil.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtil.getResource((String)var2_2, baseClass);
        if (url != null) {
            return FileUtil.normalize(URLUtil.getDecodedPath(url));
        }
        String classPath = ClassUtil.getClassPath();
        if (classPath == null) {
            return path;
        }
        return FileUtil.normalize(var1_1.concat(Objects.requireNonNull(string)));
    }

    public static String getAbsolutePath(String path) {
        return FileUtil.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            File file2;
            return file2.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        String string;
        if (StrUtil.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || ReUtil.isMatch(PATTERN_PATH_ABSOLUTE, (CharSequence)string);
    }

    public static boolean isDirectory(String path) {
        String string;
        return path != null && FileUtil.file(string).isDirectory();
    }

    public static boolean isDirectory(File file) {
        File file2;
        return file != null && file2.isDirectory();
    }

    public static boolean isFile(String path) {
        String string;
        return path != null && FileUtil.file(string).isFile();
    }

    public static boolean isFile(File file) {
        File file2;
        return file != null && file2.isFile();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(File file1, File file2) throws IORuntimeException {
        void var1_1;
        File file;
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileUtil.pathEquals(file1, file2);
        }
        return FileUtil.equals(file.toPath(), var1_1.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contentEquals(File file1, File file2) throws IORuntimeException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtil.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            void var1_3;
            File file;
            input1 = FileUtil.getInputStream(file);
            input2 = FileUtil.getInputStream((File)var1_3);
            bl = IoUtil.contentEquals(input1, input2);
        }
        catch (Throwable throwable) {
            void var3_6;
            void var2_5;
            IoUtil.close((Closeable)var2_5);
            IoUtil.close((Closeable)var3_6);
            throw throwable;
        }
        IoUtil.close(input1);
        IoUtil.close(input2);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws IORuntimeException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (FileUtil.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            void var2_4;
            void var1_3;
            File file;
            input1 = FileUtil.getReader(file, charset);
            input2 = FileUtil.getReader((File)var1_3, (Charset)var2_4);
            bl = IoUtil.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            void var3_6;
            IoUtil.close((Closeable)var3_6);
            IoUtil.close(input2);
            throw throwable;
        }
        IoUtil.close(input1);
        IoUtil.close(input2);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileUtil.isWindows()) {
                try {
                    if (StrUtil.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (StrUtil.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StrUtil.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                void var1_1;
                File file;
                if (!StrUtil.equals(file.getAbsolutePath(), var1_1.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfSeparator(String filePath) {
        if (StrUtil.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                void var1_1;
                char c = filePath.charAt(i);
                if (!CharUtil.isFileSeparator(c)) continue;
                return (int)var1_1;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isModifed(File file, long lastModifyTime) {
        void var1_1;
        return FileUtil.isModified(file, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isModified(File file, long lastModifyTime) {
        void var1_1;
        File file2;
        if (file == null || !file.exists()) {
            return true;
        }
        return file2.lastModified() != var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String normalize(String path) {
        void var2_3;
        void var1_1;
        if (path == null) {
            return null;
        }
        if (path.startsWith("\\\\")) {
            return path;
        }
        List<String> pathToUse = StrUtil.removePrefixIgnoreCase(path = StrUtil.removePrefixIgnoreCase(path, "classpath:"), PATH_FILE_PRE);
        if (StrUtil.startWith((CharSequence)((Object)pathToUse), '~')) {
            pathToUse = FileUtil.getUserHomePath() + ((String)((Object)pathToUse)).substring(1);
        }
        pathToUse = ((String)((Object)pathToUse)).replaceAll("[/\\\\]+", "/");
        pathToUse = StrUtil.trimStart((CharSequence)((Object)pathToUse));
        String prefix = "";
        int prefixIndex = ((String)((Object)pathToUse)).indexOf(":");
        if (prefixIndex >= 0) {
            prefix = ((String)((Object)pathToUse)).substring(0, prefixIndex + 1);
            if (StrUtil.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = ((String)((Object)pathToUse)).substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (((String)((Object)pathToUse)).startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = ((String)((Object)pathToUse)).substring(1);
        }
        List<String> pathList = StrUtil.split((CharSequence)((Object)pathToUse), '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = (String)pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StrUtil.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return (String)var1_1 + CollUtil.join(var2_3, (CharSequence)"/");
    }

    /*
     * WARNING - void declaration
     */
    public static String subPath(String rootDir, File file) {
        try {
            void var1_2;
            return FileUtil.subPath(rootDir, var1_2.getCanonicalPath());
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String subPath(String dirPath, String filePath) {
        void var1_1;
        if (StrUtil.isNotEmpty(dirPath) && StrUtil.isNotEmpty(filePath)) {
            String string;
            dirPath = StrUtil.removeSuffix(FileUtil.normalize(dirPath), "/");
            filePath = FileUtil.normalize(filePath);
            string = StrUtil.removePrefixIgnoreCase(filePath, string);
            return StrUtil.removePrefix(string, "/");
        }
        return var1_1;
    }

    public static String getName(File file) {
        return FileNameUtil.getName(file);
    }

    public static String getName(String filePath) {
        return FileNameUtil.getName(filePath);
    }

    public static String getSuffix(File file) {
        return FileNameUtil.getSuffix(file);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtil.getSuffix(fileName);
    }

    public static String getPrefix(File file) {
        return FileNameUtil.getPrefix(file);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtil.getPrefix(fileName);
    }

    public static String mainName(File file) {
        return FileNameUtil.mainName(file);
    }

    public static String mainName(String fileName) {
        return FileNameUtil.mainName(fileName);
    }

    public static String extName(File file) {
        return FileNameUtil.extName(file);
    }

    public static String extName(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean pathEndsWith(File file, String suffix) {
        void var1_1;
        return file.getPath().toLowerCase().endsWith((String)var1_1);
    }

    public static String getType(File file) throws IORuntimeException {
        return FileTypeUtil.getType(file);
    }

    public static BufferedInputStream getInputStream(File file) throws IORuntimeException {
        return IoUtil.toBuffered(IoUtil.toStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws IORuntimeException {
        return FileUtil.getInputStream(FileUtil.file(path));
    }

    /*
     * WARNING - void declaration
     */
    public static BOMInputStream getBOMInputStream(File file) throws IORuntimeException {
        try {
            return new BOMInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static BufferedReader getBOMReader(File file) {
        return IoUtil.getReader(FileUtil.getBOMInputStream(file));
    }

    public static BufferedReader getUtf8Reader(File file) throws IORuntimeException {
        return FileUtil.getReader(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws IORuntimeException {
        return FileUtil.getReader(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static BufferedReader getReader(File file, String charsetName) throws IORuntimeException {
        void var1_1;
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getReader(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static BufferedReader getReader(String path, String charsetName) throws IORuntimeException {
        void var1_1;
        return FileUtil.getReader(path, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getReader(String path, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.getReader(FileUtil.file(path), (Charset)var1_1);
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    public static byte[] readBytes(String filePath) throws IORuntimeException {
        return FileUtil.readBytes(FileUtil.file(filePath));
    }

    public static String readUtf8String(File file) throws IORuntimeException {
        return FileUtil.readString(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readUtf8String(String path) throws IORuntimeException {
        return FileUtil.readString(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String readString(File file, String charsetName) throws IORuntimeException {
        void var1_1;
        return FileUtil.readString(file, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String readString(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileReader.create(file, (Charset)var1_1).readString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String readString(String path, String charsetName) throws IORuntimeException {
        void var1_1;
        return FileUtil.readString(path, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String readString(String path, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readString(FileUtil.file(path), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String readString(URL url, String charsetName) throws IORuntimeException {
        void var1_1;
        return FileUtil.readString(url, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String readString(URL url, Charset charset) throws IORuntimeException {
        if (url == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            void var1_3;
            in = ((URL)url).openStream();
            url = IoUtil.read(in, (Charset)var1_3);
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readUtf8Lines(String path, T collection) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(path, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.readLines(FileUtil.file(path), (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.readLines(FileUtil.file(path), (Charset)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readUtf8Lines(File file, T collection) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileReader.create(file, CharsetUtil.charset((String)var1_1)).readLines(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileReader.create(file, (Charset)var1_1).readLines(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readUtf8Lines(URL url, T collection) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(url, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.readLines(url, CharsetUtil.charset((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            void var2_4;
            void var1_3;
            in = url.openStream();
            url = IoUtil.readLines(in, (Charset)var1_3, var2_4);
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return (T)url;
    }

    public static List<String> readUtf8Lines(URL url) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static List<String> readLines(URL url, String charsetName) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(url, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(URL url, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(url, (Charset)var1_1, new ArrayList());
    }

    public static List<String> readUtf8Lines(String path) throws IORuntimeException {
        return FileUtil.readLines(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(String path, String charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(path, (String)var1_1, new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(String path, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(path, (Charset)var1_1, new ArrayList());
    }

    public static List<String> readUtf8Lines(File file) throws IORuntimeException {
        return FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readUtf8Lines(File file, Predicate<String> filter) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8, (Predicate<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(File file, String charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(file, (String)var1_1, new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(File file, Charset charset) throws IORuntimeException {
        void var1_1;
        return FileUtil.readLines(file, (Charset)var1_1, new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(File file, Charset charset, Predicate<String> filter) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file2;
        ArrayList result = new ArrayList();
        FileUtil.readLines(file2, (Charset)var1_1, arg_0 -> FileUtil.lambda$readLines$0((Predicate)var2_2, result, arg_0));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void readUtf8Lines(File file, LineHandler lineHandler) throws IORuntimeException {
        void var1_1;
        FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8, (LineHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void readLines(File file, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        FileReader.create(file, (Charset)var1_1).readLines((LineHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void readLines(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        try {
            String line;
            while ((line = file.readLine()) != null) {
                void var3_4;
                lineHandler.handle(CharsetUtil.convert((String)var3_4, CharsetUtil.CHARSET_ISO_8859_1, charset));
            }
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void readLine(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        void var1_1;
        String line = FileUtil.readLine(file, (Charset)var1_1);
        if (line != null) {
            String string;
            void var2_2;
            var2_2.handle(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String readLine(RandomAccessFile file, Charset charset) {
        String line;
        try {
            line = file.readLine();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (line != null) {
            void var1_2;
            String string;
            return CharsetUtil.convert(string, CharsetUtil.CHARSET_ISO_8859_1, (Charset)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T loadUtf8(String path, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var1_1;
        return FileUtil.load(path, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T load(String path, String charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileReader.create(FileUtil.file(path), CharsetUtil.charset((String)var1_1)).read(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T load(String path, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileReader.create(FileUtil.file(path), (Charset)var1_1).read(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T loadUtf8(File file, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var1_1;
        return FileUtil.load(file, CharsetUtil.CHARSET_UTF_8, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T load(File file, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileReader.create(file, (Charset)var1_1).read(var2_2);
    }

    public static BufferedOutputStream getOutputStream(File file) throws IORuntimeException {
        OutputStream outputStream;
        try {
            OutputStream out = Files.newOutputStream(FileUtil.touch(file).toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(outputStream);
    }

    public static BufferedOutputStream getOutputStream(String path) throws IORuntimeException {
        return FileUtil.getOutputStream(FileUtil.touch(path));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.getWriter(path, Charset.forName((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.getWriter(FileUtil.touch(path), (Charset)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.getWriter(file, Charset.forName((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileWriter.create(file, (Charset)var1_1).getWriter((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        String string;
        return new PrintWriter(FileUtil.getWriter(string, (String)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static PrintWriter getPrintWriter(String path, Charset charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        String string;
        return new PrintWriter(FileUtil.getWriter(string, (Charset)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        File file2;
        return new PrintWriter(FileUtil.getWriter(file2, (String)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static PrintWriter getPrintWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        void var2_2;
        void var1_1;
        File file2;
        return new PrintWriter(FileUtil.getWriter(file2, (Charset)var1_1, (boolean)var2_2));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    /*
     * WARNING - void declaration
     */
    public static File writeUtf8String(String content, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeString(content, (String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeUtf8String(String content, File file) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeString(content, (File)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeString(String content, String path, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeString(content, FileUtil.touch((String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeString(String content, String path, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeString(content, FileUtil.touch((String)var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeString(String content, File file, String charset) throws IORuntimeException {
        String string;
        void var2_2;
        return FileWriter.create(file, CharsetUtil.charset((String)var2_2)).write(string);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeString(String content, File file, Charset charset) throws IORuntimeException {
        String string;
        void var2_2;
        return FileWriter.create(file, (Charset)var2_2).write(string);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendUtf8String(String content, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.appendString(content, (String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendString(String content, String path, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.appendString(content, FileUtil.touch((String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendString(String content, String path, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.appendString(content, FileUtil.touch((String)var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendUtf8String(String content, File file) throws IORuntimeException {
        void var1_1;
        return FileUtil.appendString(content, (File)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendString(String content, File file, String charset) throws IORuntimeException {
        String string;
        void var2_2;
        return FileWriter.create(file, CharsetUtil.charset((String)var2_2)).append(string);
    }

    /*
     * WARNING - void declaration
     */
    public static File appendString(String content, File file, Charset charset) throws IORuntimeException {
        String string;
        void var2_2;
        return FileWriter.create(file, (Charset)var2_2).append(string);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeUtf8Lines(Collection<T> list, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeLines(list, (String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeUtf8Lines(Collection<T> list, File file) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeLines(list, (File)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (String)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, String path, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (String)var1_1, (Charset)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, File file, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (File)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, File file, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (File)var1_1, (Charset)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendUtf8Lines(Collection<T> list, File file) throws IORuntimeException {
        void var1_1;
        return FileUtil.appendLines(list, (File)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendUtf8Lines(Collection<T> list, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.appendLines(list, (String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (String)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendLines(Collection<T> list, File file, String charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (File)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendLines(Collection<T> list, String path, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (String)var1_1, (Charset)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File appendLines(Collection<T> list, File file, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, (File)var1_1, (Charset)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, FileUtil.file((String)var1_1), (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, String path, Charset charset, boolean isAppend) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return FileUtil.writeLines(list, FileUtil.file((String)var1_1), (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws IORuntimeException {
        void var3_3;
        Collection<T> collection;
        void var2_2;
        return FileWriter.create(file, CharsetUtil.charset((String)var2_2)).writeLines(collection, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws IORuntimeException {
        void var3_3;
        Collection<T> collection;
        void var2_2;
        return FileWriter.create(file, (Charset)var2_2).writeLines(collection, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeUtf8Map(Map<?, ?> map, File file, String kvSeparator, boolean isAppend) throws IORuntimeException {
        void var3_3;
        void var2_2;
        Map<?, ?> map2;
        return FileWriter.create(file, CharsetUtil.CHARSET_UTF_8).writeMap(map2, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeMap(Map<?, ?> map, File file, Charset charset, String kvSeparator, boolean isAppend) throws IORuntimeException {
        void var3_3;
        Map<?, ?> map2;
        void var2_2;
        return FileWriter.create(file, (Charset)var2_2).writeMap(map2, (String)var3_3, isAppend);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeBytes(byte[] data, String path) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeBytes(data, FileUtil.touch((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static File writeBytes(byte[] data, File dest) throws IORuntimeException {
        byte[] byArray;
        void var1_1;
        return FileUtil.writeBytes(data, (File)var1_1, 0, byArray.length, false);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws IORuntimeException {
        void var3_3;
        void var2_2;
        byte[] byArray;
        return FileWriter.create(dest).write(byArray, (int)var2_2, (int)var3_3, isAppend);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeFromStream(InputStream in, File dest) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeFromStream(in, (File)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeFromStream(InputStream in, File dest, boolean isCloseIn) throws IORuntimeException {
        void var2_2;
        InputStream inputStream;
        return FileWriter.create(dest).writeFromStream(inputStream, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File writeFromStream(InputStream in, String fullFilePath) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeFromStream(in, FileUtil.touch((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long writeToStream(File file, OutputStream out) throws IORuntimeException {
        void var1_1;
        return FileReader.create(file).writeToStream((OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long writeToStream(String fullFilePath, OutputStream out) throws IORuntimeException {
        void var1_1;
        return FileUtil.writeToStream(FileUtil.touch(fullFilePath), (OutputStream)var1_1);
    }

    public static String readableFileSize(File file) {
        return FileUtil.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        return DataSizeUtil.format(size);
    }

    /*
     * WARNING - void declaration
     */
    public static File convertCharset(File file, Charset srcCharset, Charset destCharset) {
        void var2_2;
        void var1_1;
        return CharsetUtil.convert(file, (Charset)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File convertLineSeparator(File file, Charset charset, LineSeparator lineSeparator) {
        void var2_2;
        void var3_3;
        void var1_1;
        File file2;
        List<String> lines = FileUtil.readLines(file, charset);
        return FileWriter.create(file2, (Charset)var1_1).writeLines(var3_3, (LineSeparator)var2_2, false);
    }

    public static String cleanInvalid(String fileName) {
        return FileNameUtil.cleanInvalid(fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return FileNameUtil.containsInvalid(fileName);
    }

    public static long checksumCRC32(File file) throws IORuntimeException {
        return FileUtil.checksum(file, new CRC32()).getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static Checksum checksum(File file, Checksum checksum) throws IORuntimeException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            void var1_2;
            return IoUtil.checksum(Files.newInputStream(file.toPath(), new OpenOption[0]), (Checksum)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File getWebRoot() {
        String classPath = ClassUtil.getClassPath();
        if (StrUtil.isNotBlank(classPath)) {
            void var0;
            return FileUtil.getParent(FileUtil.file((String)var0), 2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getParent(String filePath, int level) {
        void var1_2;
        File parent = FileUtil.getParent(FileUtil.file(filePath), (int)var1_2);
        try {
            if (parent == null) {
                return null;
            }
            return parent.getCanonicalPath();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static File getParent(File file, int level) {
        while (level > 0 && file != null) {
            File parentFile;
            try {
                parentFile = file.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            if (1 == level) {
                return parentFile;
            }
            --level;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        void var1_1;
        File file2;
        if (parentFile != null && file != null && !FileUtil.isSub(file2, file)) {
            throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getMimeType(String filePath) {
        void var1_1;
        if (StrUtil.isBlank(filePath)) {
            return null;
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".css")) {
            return "text/css";
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".js")) {
            return "application/x-javascript";
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".rar")) {
            return "application/x-rar-compressed";
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".7z")) {
            return "application/x-7z-compressed";
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".wgt")) {
            return "application/widget";
        }
        if (StrUtil.endWithIgnoreCase(filePath, ".webp")) {
            return "image/webp";
        }
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (contentType == null) {
            String string;
            contentType = FileUtil.getMimeType(Paths.get(string, new String[0]));
        }
        return var1_1;
    }

    public static boolean isSymlink(File file) {
        return FileUtil.isSymlink(file.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSub(File parent, File sub) {
        void var1_1;
        File file;
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileUtil.isSub(file.toPath(), var1_1.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public static RandomAccessFile createRandomAccessFile(Path path, FileMode mode) {
        void var1_1;
        return FileUtil.createRandomAccessFile(path.toFile(), (FileMode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static RandomAccessFile createRandomAccessFile(File file, FileMode mode) {
        try {
            void var1_2;
            return new RandomAccessFile(file, var1_2.name());
        }
        catch (FileNotFoundException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void tail(File file, LineHandler handler) {
        void var1_1;
        FileUtil.tail(file, CharsetUtil.CHARSET_UTF_8, (LineHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void tail(File file, Charset charset, LineHandler handler) {
        void var2_2;
        void var1_1;
        File file2;
        new Tailer(file2, (Charset)var1_1, (LineHandler)var2_2).start();
    }

    /*
     * WARNING - void declaration
     */
    public static void tail(File file, Charset charset) {
        void var1_1;
        FileUtil.tail(file, (Charset)var1_1, Tailer.CONSOLE_HANDLER);
    }

    /*
     * WARNING - void declaration
     */
    private static File buildFile(File outFile, String fileName) {
        File file;
        String string;
        fileName = fileName.replace('\\', '/');
        if (!FileUtil.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            void var2_2;
            List<String> pathParts = StrUtil.split((CharSequence)fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            string = (String)string.get((int)var2_2);
        }
        return new File(file, string);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$readLines$0(Predicate filter, List result, String line) {
        if (filter.test(line)) {
            void var2_2;
            void var1_1;
            var1_1.add(var2_2);
        }
    }
}

