/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.io.FileMagicNumber;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class FileTypeUtil {
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>();

    /*
     * WARNING - void declaration
     */
    public static String putFileType(String fileStreamHexHead, String extName) {
        void var1_1;
        String string;
        return FILE_TYPE_MAP.put(string, (String)var1_1);
    }

    public static String removeFileType(String fileStreamHexHead) {
        String string;
        return FILE_TYPE_MAP.remove(string);
    }

    public static String getType(String fileStreamHexHead) {
        String string;
        if (MapUtil.isNotEmpty(FILE_TYPE_MAP)) {
            for (Map.Entry entry : FILE_TYPE_MAP.entrySet()) {
                if (!StrUtil.startWithIgnoreCase(fileStreamHexHead, (CharSequence)entry.getKey())) continue;
                return (String)entry.getValue();
            }
        }
        byte[] byArray = HexUtil.decodeHex(string);
        Object object = byArray;
        return FileMagicNumber.getMagicNumber(byArray).getExtension();
    }

    /*
     * WARNING - void declaration
     */
    public static String getType(InputStream in, int fileHeadSize) throws IORuntimeException {
        void var1_1;
        return FileTypeUtil.getType(IoUtil.readHex(in, (int)var1_1, false));
    }

    /*
     * WARNING - void declaration
     */
    public static String getType(InputStream in, boolean isExact) throws IORuntimeException {
        InputStream inputStream;
        void var1_1;
        if (in == null) {
            return null;
        }
        if (var1_1 != false) {
            return FileTypeUtil.getType(IoUtil.readHex8192Upper(in));
        }
        return FileTypeUtil.getType(IoUtil.readHex64Upper(inputStream));
    }

    public static String getType(InputStream in) throws IORuntimeException {
        return FileTypeUtil.getType(in, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String getType(InputStream in, String filename) throws IORuntimeException {
        void var1_1;
        return FileTypeUtil.getType(in, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String getType(InputStream in, String filename, boolean isExact) throws IORuntimeException {
        Object object;
        String extName;
        void var2_2;
        Object typeName = FileTypeUtil.getType(in, (boolean)var2_2);
        if (typeName == null) {
            typeName = FileUtil.extName(filename);
        } else if ("zip".equals(typeName)) {
            extName = FileUtil.extName(filename);
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        } else if ("jar".equals(typeName)) {
            void var1_1;
            if ("xlsx".equalsIgnoreCase(extName = FileUtil.extName(extName))) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("zip".equalsIgnoreCase(extName)) {
                typeName = "zip";
            } else if ("apk".equalsIgnoreCase((String)var1_1)) {
                typeName = "apk";
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String getType(File file, boolean isExact) throws IORuntimeException {
        String string;
        if (!FileUtil.isFile(file)) {
            throw new IllegalArgumentException("Not a regular file!");
        }
        FileInputStream in = null;
        try {
            void var1_2;
            in = IoUtil.toStream(file);
            string = FileTypeUtil.getType(in, ((File)((Object)string)).getName(), (boolean)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(in);
        return string;
    }

    public static String getType(File file) throws IORuntimeException {
        return FileTypeUtil.getType(file, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String getTypeByPath(String path, boolean isExact) throws IORuntimeException {
        void var1_1;
        return FileTypeUtil.getType(FileUtil.file(path), (boolean)var1_1);
    }

    public static String getTypeByPath(String path) throws IORuntimeException {
        return FileTypeUtil.getTypeByPath(path, false);
    }
}

