/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.util.ArrayUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public enum FileMagicNumber {
    UNKNOWN(null, null){
        {
            void var3_3;
        }

        @Override
        public final boolean match(byte[] bytes) {
            return false;
        }
    }
    ,
    JPEG("image/jpeg", "jpg"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-40) && Objects.equals((byte)var1_1[2], (byte)-1);
        }
    }
    ,
    JXR("image/vnd.ms-photo", "jxr"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)73) && Objects.equals((byte)var1_1[2], (byte)-68);
        }
    }
    ,
    APNG("image/apng", "apng"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            boolean bl = bytes.length > 8 && Objects.equals(bytes[0], (byte)-119) && Objects.equals(bytes[1], (byte)80) && Objects.equals(bytes[2], (byte)78) && Objects.equals(bytes[3], (byte)71) && Objects.equals(bytes[4], (byte)13) && Objects.equals(bytes[5], (byte)10) && Objects.equals(bytes[6], (byte)26) && Objects.equals(bytes[7], (byte)10);
            if (bl) {
                void var3_3;
                for (int i = 8; i < bytes.length; i += var3_3 + 4) {
                    try {
                        int n = i;
                        int dataLength = new BigInteger(1, Arrays.copyOfRange(bytes, n, n + 4)).intValue();
                        int n2 = i += 4;
                        byte[] bytes1 = Arrays.copyOfRange(bytes, n2, n2 + 4);
                        String chunkType = new String(bytes1);
                        i += 4;
                        if (Objects.equals(chunkType, "IDAT") || Objects.equals(chunkType, "IEND")) {
                            return false;
                        }
                        if (!Objects.equals(chunkType, "acTL")) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            }
            return false;
        }
    }
    ,
    PNG("image/png", "png"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)-119) && Objects.equals(bytes[1], (byte)80) && Objects.equals(bytes[2], (byte)78) && Objects.equals((byte)var1_1[3], (byte)71);
        }
    }
    ,
    GIF("image/gif", "gif"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)71) && Objects.equals(bytes[1], (byte)73) && Objects.equals((byte)var1_1[2], (byte)70);
        }
    }
    ,
    BMP("image/bmp", "bmp"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 1 && Objects.equals(bytes[0], (byte)66) && Objects.equals((byte)var1_1[1], (byte)77);
        }
    }
    ,
    TIFF("image/tiff", "tiff"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length < 4) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)73) && Objects.equals(bytes[2], (byte)42) && Objects.equals(bytes[3], (byte)0);
            boolean bl = flag2 = Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)77) && Objects.equals(bytes[2], (byte)0) && Objects.equals(bytes[3], (byte)42);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    DWG("image/vnd.dwg", "dwg"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 10 && Objects.equals(bytes[0], (byte)65) && Objects.equals(bytes[1], (byte)67) && Objects.equals(bytes[2], (byte)49) && Objects.equals((byte)var1_1[3], (byte)48);
        }
    }
    ,
    WEBP("image/webp", "webp"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 11 && Objects.equals(bytes[8], (byte)87) && Objects.equals(bytes[9], (byte)69) && Objects.equals(bytes[10], (byte)66) && Objects.equals((byte)var1_1[11], (byte)80);
        }
    }
    ,
    PSD("image/vnd.adobe.photoshop", "psd"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)56) && Objects.equals(bytes[1], (byte)66) && Objects.equals(bytes[2], (byte)80) && Objects.equals((byte)var1_1[3], (byte)83);
        }
    }
    ,
    ICO("image/x-icon", "ico"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)0) && Objects.equals(bytes[2], (byte)1) && Objects.equals((byte)var1_1[3], (byte)0);
        }
    }
    ,
    XCF("image/x-xcf", "xcf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 9 && Objects.equals(bytes[0], (byte)103) && Objects.equals(bytes[1], (byte)105) && Objects.equals(bytes[2], (byte)109) && Objects.equals(bytes[3], (byte)112) && Objects.equals(bytes[4], (byte)32) && Objects.equals(bytes[5], (byte)120) && Objects.equals(bytes[6], (byte)99) && Objects.equals(bytes[7], (byte)102) && Objects.equals(bytes[8], (byte)32) && Objects.equals((byte)var1_1[9], (byte)118);
        }
    }
    ,
    WAV("audio/x-wav", "wav"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 11 && Objects.equals(bytes[0], (byte)82) && Objects.equals(bytes[1], (byte)73) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)70) && Objects.equals(bytes[8], (byte)87) && Objects.equals(bytes[9], (byte)65) && Objects.equals(bytes[10], (byte)86) && Objects.equals((byte)var1_1[11], (byte)69);
        }
    }
    ,
    MIDI("audio/midi", "midi"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)84) && Objects.equals(bytes[2], (byte)104) && Objects.equals((byte)var1_1[3], (byte)100);
        }
    }
    ,
    MP3("audio/mpeg", "mp3"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var3_4;
            void var2_3;
            boolean flag4;
            if (bytes.length < 2) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)68) && Objects.equals(bytes[2], (byte)51);
            boolean flag2 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-5);
            boolean flag3 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-13);
            boolean bl = flag4 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-14);
            return var2_3 != false || var3_4 != false || flag3 || var1_2 != false;
        }
    }
    ,
    OGG("audio/ogg", "ogg"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)79) && Objects.equals(bytes[1], (byte)103) && Objects.equals(bytes[2], (byte)103) && Objects.equals((byte)var1_1[3], (byte)83);
        }
    }
    ,
    FLAC("audio/x-flac", "flac"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)102) && Objects.equals(bytes[1], (byte)76) && Objects.equals(bytes[2], (byte)97) && Objects.equals((byte)var1_1[3], (byte)67);
        }
    }
    ,
    M4A("audio/mp4", "m4a"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 10 && Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)52) && Objects.equals(bytes[10], (byte)65) || Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)52) && Objects.equals(bytes[2], (byte)65) && Objects.equals((byte)var1_1[3], (byte)32);
        }
    }
    ,
    AAC("audio/aac", "aac"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length <= 0) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-15);
            boolean bl = flag2 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-7);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    AMR("audio/amr", "amr"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length < 11) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)35) && Objects.equals(bytes[1], (byte)33) && Objects.equals(bytes[2], (byte)65) && Objects.equals(bytes[3], (byte)77) && Objects.equals(bytes[4], (byte)82) && Objects.equals(bytes[5], (byte)10);
            boolean bl = flag2 = Objects.equals(bytes[0], (byte)35) && Objects.equals(bytes[1], (byte)33) && Objects.equals(bytes[2], (byte)65) && Objects.equals(bytes[3], (byte)77) && Objects.equals(bytes[4], (byte)82) && Objects.equals(bytes[5], (byte)95) && Objects.equals(bytes[6], (byte)77) && Objects.equals(bytes[7], (byte)67) && Objects.equals(bytes[8], (byte)49) && Objects.equals(bytes[9], (byte)46) && Objects.equals(bytes[10], (byte)48) && Objects.equals(bytes[11], (byte)10);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    AC3("audio/ac3", "ac3"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)11) && Objects.equals((byte)var1_1[1], (byte)119);
        }
    }
    ,
    AIFF("audio/x-aiff", "aiff"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 11 && Objects.equals(bytes[0], (byte)70) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)82) && Objects.equals(bytes[3], (byte)77) && Objects.equals(bytes[8], (byte)65) && Objects.equals(bytes[9], (byte)73) && Objects.equals(bytes[10], (byte)70) && Objects.equals((byte)var1_1[11], (byte)70);
        }
    }
    ,
    WOFF("font/woff", "woff"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var3_4;
            void var2_3;
            boolean flag4;
            if (bytes.length < 8) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)119) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)70);
            boolean flag2 = Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)1) && Objects.equals(bytes[6], (byte)0) && Objects.equals(bytes[7], (byte)0);
            boolean flag3 = Objects.equals(bytes[4], (byte)79) && Objects.equals(bytes[5], (byte)84) && Objects.equals(bytes[6], (byte)84) && Objects.equals(bytes[7], (byte)79);
            boolean bl = flag4 = Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)117) && Objects.equals(bytes[7], (byte)101);
            return var2_3 != false && (var3_4 != false || flag3 || var1_2 != false);
        }
    }
    ,
    WOFF2("font/woff2", "woff2"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var3_4;
            void var2_3;
            boolean flag4;
            if (bytes.length < 8) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)119) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)50);
            boolean flag2 = Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)1) && Objects.equals(bytes[6], (byte)0) && Objects.equals(bytes[7], (byte)0);
            boolean flag3 = Objects.equals(bytes[4], (byte)79) && Objects.equals(bytes[5], (byte)84) && Objects.equals(bytes[6], (byte)84) && Objects.equals(bytes[7], (byte)79);
            boolean bl = flag4 = Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)117) && Objects.equals(bytes[7], (byte)101);
            return var2_3 != false && (var3_4 != false || flag3 || var1_2 != false);
        }
    }
    ,
    TTF("font/ttf", "ttf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)1) && Objects.equals(bytes[2], (byte)0) && Objects.equals(bytes[3], (byte)0) && Objects.equals((byte)var1_1[4], (byte)0);
        }
    }
    ,
    OTF("font/otf", "otf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)79) && Objects.equals(bytes[1], (byte)84) && Objects.equals(bytes[2], (byte)84) && Objects.equals(bytes[3], (byte)79) && Objects.equals((byte)var1_1[4], (byte)0);
        }
    }
    ,
    EPUB("application/epub+zip", "epub"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 58 && Objects.equals(bytes[0], (byte)80) && Objects.equals(bytes[1], (byte)75) && Objects.equals(bytes[2], (byte)3) && Objects.equals(bytes[3], (byte)4) && Objects.equals(bytes[30], (byte)109) && Objects.equals(bytes[31], (byte)105) && Objects.equals(bytes[32], (byte)109) && Objects.equals(bytes[33], (byte)101) && Objects.equals(bytes[34], (byte)116) && Objects.equals(bytes[35], (byte)121) && Objects.equals(bytes[36], (byte)112) && Objects.equals(bytes[37], (byte)101) && Objects.equals(bytes[38], (byte)97) && Objects.equals(bytes[39], (byte)112) && Objects.equals(bytes[40], (byte)112) && Objects.equals(bytes[41], (byte)108) && Objects.equals(bytes[42], (byte)105) && Objects.equals(bytes[43], (byte)99) && Objects.equals(bytes[44], (byte)97) && Objects.equals(bytes[45], (byte)116) && Objects.equals(bytes[46], (byte)105) && Objects.equals(bytes[47], (byte)111) && Objects.equals(bytes[48], (byte)110) && Objects.equals(bytes[49], (byte)47) && Objects.equals(bytes[50], (byte)101) && Objects.equals(bytes[51], (byte)112) && Objects.equals(bytes[52], (byte)117) && Objects.equals(bytes[53], (byte)98) && Objects.equals(bytes[54], (byte)43) && Objects.equals(bytes[55], (byte)122) && Objects.equals(bytes[56], (byte)105) && Objects.equals((byte)var1_1[57], (byte)112);
        }
    }
    ,
    ZIP("application/zip", "zip"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var3_4;
            void var2_3;
            boolean flag3;
            if (bytes.length < 4) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)80) && Objects.equals(bytes[1], (byte)75);
            boolean flag2 = Objects.equals(bytes[2], (byte)3) || Objects.equals(bytes[2], (byte)5) || Objects.equals(bytes[2], (byte)7);
            boolean bl = flag3 = Objects.equals(bytes[3], (byte)4) || Objects.equals(bytes[3], (byte)6) || Objects.equals(bytes[3], (byte)8);
            return var2_3 != false && var3_4 != false && var1_2 != false;
        }
    }
    ,
    TAR("application/x-tar", "tar"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 261 && Objects.equals(bytes[257], (byte)117) && Objects.equals(bytes[258], (byte)115) && Objects.equals(bytes[259], (byte)116) && Objects.equals(bytes[260], (byte)97) && Objects.equals((byte)var1_1[261], (byte)114);
        }
    }
    ,
    RAR("application/x-rar-compressed", "rar"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)82) && Objects.equals(bytes[1], (byte)97) && Objects.equals(bytes[2], (byte)114) && Objects.equals(bytes[3], (byte)33) && Objects.equals(bytes[4], (byte)26) && Objects.equals(bytes[5], (byte)7) && (Objects.equals(bytes[6], (byte)0) || Objects.equals((byte)var1_1[6], (byte)1));
        }
    }
    ,
    GZ("application/gzip", "gz"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)31) && Objects.equals(bytes[1], (byte)-117) && Objects.equals((byte)var1_1[2], (byte)8);
        }
    }
    ,
    BZ2("application/x-bzip2", "bz2"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)66) && Objects.equals(bytes[1], (byte)90) && Objects.equals((byte)var1_1[2], (byte)104);
        }
    }
    ,
    SevenZ("application/x-7z-compressed", "7z"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)55) && Objects.equals(bytes[1], (byte)122) && Objects.equals(bytes[2], (byte)-68) && Objects.equals(bytes[3], (byte)-81) && Objects.equals(bytes[4], (byte)39) && Objects.equals(bytes[5], (byte)28) && Objects.equals((byte)var1_1[6], (byte)0);
        }
    }
    ,
    PDF("application/pdf", "pdf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            if (bytes.length > 3 && Objects.equals(bytes[0], (byte)-17) && Objects.equals(bytes[1], (byte)-69) && Objects.equals(bytes[2], (byte)-65)) {
                bytes = Arrays.copyOfRange(bytes, 3, bytes.length);
            }
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)37) && Objects.equals(bytes[1], (byte)80) && Objects.equals(bytes[2], (byte)68) && Objects.equals((byte)var1_1[3], (byte)70);
        }
    }
    ,
    EXE("application/x-msdownload", "exe"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 1 && Objects.equals(bytes[0], (byte)77) && Objects.equals((byte)var1_1[1], (byte)90);
        }
    }
    ,
    SWF("application/x-shockwave-flash", "swf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 2 && (Objects.equals(bytes[0], 67) || Objects.equals(bytes[0], (byte)70)) && Objects.equals(bytes[1], (byte)87) && Objects.equals((byte)var1_1[2], (byte)83);
        }
    }
    ,
    RTF("application/rtf", "rtf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)123) && Objects.equals(bytes[1], (byte)92) && Objects.equals(bytes[2], (byte)114) && Objects.equals(bytes[3], (byte)116) && Objects.equals((byte)var1_1[4], (byte)102);
        }
    }
    ,
    NES("application/x-nintendo-nes-rom", "nes"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)78) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)83) && Objects.equals((byte)var1_1[3], (byte)26);
        }
    }
    ,
    CRX("application/x-google-chrome-extension", "crx"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)67) && Objects.equals(bytes[1], (byte)114) && Objects.equals(bytes[2], (byte)50) && Objects.equals((byte)var1_1[3], (byte)52);
        }
    }
    ,
    CAB("application/vnd.ms-cab-compressed", "cab"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length < 4) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)83) && Objects.equals(bytes[2], (byte)67) && Objects.equals(bytes[3], (byte)70);
            boolean bl = flag2 = Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)83) && Objects.equals(bytes[2], (byte)99) && Objects.equals(bytes[3], (byte)40);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    PS("application/postscript", "ps"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 1 && Objects.equals(bytes[0], (byte)37) && Objects.equals((byte)var1_1[1], (byte)33);
        }
    }
    ,
    XZ("application/x-xz", "xz"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 5 && Objects.equals(bytes[0], (byte)-3) && Objects.equals(bytes[1], (byte)55) && Objects.equals(bytes[2], (byte)122) && Objects.equals(bytes[3], (byte)88) && Objects.equals(bytes[4], (byte)90) && Objects.equals((byte)var1_1[5], (byte)0);
        }
    }
    ,
    SQLITE("application/x-sqlite3", "sqlite"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 15 && Objects.equals(bytes[0], (byte)83) && Objects.equals(bytes[1], (byte)81) && Objects.equals(bytes[2], (byte)76) && Objects.equals(bytes[3], (byte)105) && Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)101) && Objects.equals(bytes[6], (byte)32) && Objects.equals(bytes[7], (byte)102) && Objects.equals(bytes[8], (byte)111) && Objects.equals(bytes[9], (byte)114) && Objects.equals(bytes[10], (byte)109) && Objects.equals(bytes[11], (byte)97) && Objects.equals(bytes[12], (byte)116) && Objects.equals(bytes[13], (byte)32) && Objects.equals(bytes[14], (byte)51) && Objects.equals((byte)var1_1[15], (byte)0);
        }
    }
    ,
    DEB("application/x-deb", "deb"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 20 && Objects.equals(bytes[0], (byte)33) && Objects.equals(bytes[1], (byte)60) && Objects.equals(bytes[2], (byte)97) && Objects.equals(bytes[3], (byte)114) && Objects.equals(bytes[4], (byte)99) && Objects.equals(bytes[5], (byte)104) && Objects.equals(bytes[6], (byte)62) && Objects.equals(bytes[7], (byte)10) && Objects.equals(bytes[8], (byte)100) && Objects.equals(bytes[9], (byte)101) && Objects.equals(bytes[10], (byte)98) && Objects.equals(bytes[11], (byte)105) && Objects.equals(bytes[12], (byte)97) && Objects.equals(bytes[13], (byte)110) && Objects.equals(bytes[14], (byte)45) && Objects.equals(bytes[15], (byte)98) && Objects.equals(bytes[16], (byte)105) && Objects.equals(bytes[17], (byte)110) && Objects.equals(bytes[18], (byte)97) && Objects.equals(bytes[19], (byte)114) && Objects.equals((byte)var1_1[20], (byte)121);
        }
    }
    ,
    AR("application/x-unix-archive", "ar"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)33) && Objects.equals(bytes[1], (byte)60) && Objects.equals(bytes[2], (byte)97) && Objects.equals(bytes[3], (byte)114) && Objects.equals(bytes[4], (byte)99) && Objects.equals(bytes[5], (byte)104) && Objects.equals((byte)var1_1[6], (byte)62);
        }
    }
    ,
    LZOP("application/x-lzop", "lzo"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 7 && Objects.equals(bytes[0], (byte)-119) && Objects.equals(bytes[1], (byte)76) && Objects.equals(bytes[2], (byte)90) && Objects.equals(bytes[3], (byte)79) && Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)13) && Objects.equals(bytes[6], (byte)10) && Objects.equals((byte)var1_1[7], (byte)26);
        }
    }
    ,
    LZ("application/x-lzip", "lz"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)76) && Objects.equals(bytes[1], (byte)90) && Objects.equals(bytes[2], (byte)73) && Objects.equals((byte)var1_1[3], (byte)80);
        }
    }
    ,
    ELF("application/x-executable", "elf"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 52 && Objects.equals(bytes[0], (byte)127) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)76) && Objects.equals((byte)var1_1[3], (byte)70);
        }
    }
    ,
    LZ4("application/x-lz4", "lz4"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)4) && Objects.equals(bytes[1], (byte)34) && Objects.equals(bytes[2], (byte)77) && Objects.equals((byte)var1_1[3], (byte)24);
        }
    }
    ,
    BR("application/x-brotli", "br"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)-50) && Objects.equals(bytes[1], (byte)-78) && Objects.equals(bytes[2], (byte)-49) && Objects.equals((byte)var1_1[3], (byte)-127);
        }
    }
    ,
    DCM("application/x-dicom", "dcm"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 128 && Objects.equals(bytes[128], (byte)68) && Objects.equals(bytes[129], (byte)73) && Objects.equals(bytes[130], (byte)67) && Objects.equals((byte)var1_1[131], (byte)77);
        }
    }
    ,
    RPM("application/x-rpm", "rpm"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)-19) && Objects.equals(bytes[1], (byte)-85) && Objects.equals(bytes[2], (byte)-18) && Objects.equals((byte)var1_1[3], (byte)-37);
        }
    }
    ,
    ZSTD("application/x-zstd", "zst"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            int n = bytes.length;
            if (n < 5) {
                return false;
            }
            byte[] byArray = new byte[]{34, 35, 36, 37, 38, 39, 40};
            boolean bl = ArrayUtil.contains(byArray, bytes[0]) && Objects.equals(bytes[1], (byte)-75) && Objects.equals(bytes[2], (byte)47) && Objects.equals(bytes[3], (byte)-3);
            if (bl) {
                return true;
            }
            if ((bytes[0] & 0xF0) == 80) {
                void var1_1;
                return bytes[1] == 42 && bytes[2] == 77 && var1_1[3] == 24;
            }
            return false;
        }
    }
    ,
    MP4("video/mp4", "mp4"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length < 13) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)83) && Objects.equals(bytes[10], (byte)78) && Objects.equals(bytes[11], (byte)86);
            boolean bl = flag2 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)105) && Objects.equals(bytes[9], (byte)115) && Objects.equals(bytes[10], (byte)111) && Objects.equals(bytes[11], (byte)109);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    AVI("video/x-msvideo", "avi"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 11 && Objects.equals(bytes[0], (byte)82) && Objects.equals(bytes[1], (byte)73) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)70) && Objects.equals(bytes[8], (byte)65) && Objects.equals(bytes[9], (byte)86) && Objects.equals(bytes[10], (byte)73) && Objects.equals((byte)var1_1[11], (byte)32);
        }
    }
    ,
    WMV("video/x-ms-wmv", "wmv"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 9 && Objects.equals(bytes[0], (byte)48) && Objects.equals(bytes[1], (byte)38) && Objects.equals(bytes[2], (byte)-78) && Objects.equals(bytes[3], (byte)117) && Objects.equals(bytes[4], (byte)-114) && Objects.equals(bytes[5], (byte)102) && Objects.equals(bytes[6], (byte)-49) && Objects.equals(bytes[7], (byte)17) && Objects.equals(bytes[8], (byte)-90) && Objects.equals((byte)var1_1[9], (byte)-39);
        }
    }
    ,
    M4V("video/x-m4v", "m4v"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var2_3;
            boolean flag2;
            if (bytes.length < 12) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)52) && Objects.equals(bytes[10], (byte)86) && Objects.equals(bytes[11], (byte)32);
            boolean bl = flag2 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)109) && Objects.equals(bytes[9], (byte)112) && Objects.equals(bytes[10], (byte)52) && Objects.equals(bytes[11], (byte)50);
            return var2_3 != false || var1_2 != false;
        }
    }
    ,
    FLV("video/x-flv", "flv"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)70) && Objects.equals(bytes[1], (byte)76) && Objects.equals(bytes[2], (byte)86) && Objects.equals((byte)var1_1[3], (byte)1);
        }
    }
    ,
    MKV("video/x-matroska", "mkv"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            boolean bl = bytes.length > 11 && Objects.equals(bytes[0], (byte)26) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)-33) && Objects.equals(bytes[3], (byte)-93);
            if (bl) {
                void var2_4;
                void var1_1;
                byte[] bytes1 = new byte[]{66, -126, -120, 109, 97, 116, 114, 111, 115, 107, 97};
                int n = FileMagicNumber.access$100((byte[])var1_1, (byte[])var2_4);
                return n > 0;
            }
            return false;
        }
    }
    ,
    WEBM("video/webm", "webm"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            boolean bl = bytes.length > 8 && Objects.equals(bytes[0], (byte)26) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)-33) && Objects.equals(bytes[3], (byte)-93);
            if (bl) {
                void var2_4;
                void var1_1;
                byte[] bytes1 = new byte[]{66, -126, -120, 119, 101, 98, 109};
                int n = FileMagicNumber.access$100((byte[])var1_1, (byte[])var2_4);
                return n > 0;
            }
            return false;
        }
    }
    ,
    MOV("video/quicktime", "mov"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_2;
            void var3_4;
            void var2_3;
            boolean flag7;
            if (bytes.length < 12) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)113) && Objects.equals(bytes[9], (byte)116) && Objects.equals(bytes[10], (byte)32) && Objects.equals(bytes[11], (byte)32);
            boolean flag2 = Objects.equals(bytes[4], (byte)109) && Objects.equals(bytes[5], (byte)111) && Objects.equals(bytes[6], (byte)111) && Objects.equals(bytes[7], (byte)118);
            boolean flag3 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)101) && Objects.equals(bytes[7], (byte)101);
            boolean flag4 = Objects.equals(bytes[4], (byte)109) && Objects.equals(bytes[5], (byte)100) && Objects.equals(bytes[6], (byte)97) && Objects.equals(bytes[7], (byte)116);
            boolean flag5 = Objects.equals(bytes[4], (byte)119) && Objects.equals(bytes[5], (byte)105) && Objects.equals(bytes[6], (byte)100) && Objects.equals(bytes[7], (byte)101);
            boolean flag6 = Objects.equals(bytes[4], (byte)112) && Objects.equals(bytes[5], (byte)110) && Objects.equals(bytes[6], (byte)111) && Objects.equals(bytes[7], (byte)116);
            boolean bl = flag7 = Objects.equals(bytes[4], (byte)115) && Objects.equals(bytes[5], (byte)107) && Objects.equals(bytes[6], (byte)105) && Objects.equals(bytes[7], (byte)112);
            return var2_3 != false || var3_4 != false || flag3 || flag4 || flag5 || flag6 || var1_2 != false;
        }
    }
    ,
    MPEG("video/mpeg", "mpg"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)0) && Objects.equals(bytes[2], (byte)1) && bytes[3] >= -80 && var1_1[3] <= -65;
        }
    }
    ,
    RMVB("video/vnd.rn-realvideo", "rmvb"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)46) && Objects.equals(bytes[1], (byte)82) && Objects.equals(bytes[2], (byte)77) && Objects.equals((byte)var1_1[3], (byte)70);
        }
    }
    ,
    M3GP("video/3gpp", "3gp"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 10 && Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)51) && Objects.equals(bytes[9], (byte)103) && Objects.equals((byte)var1_1[10], (byte)112);
        }
    }
    ,
    DOC("application/msword", "doc"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            byte[] byte42 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            boolean byte42 = bytes.length > 515 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte42);
            if (byte42) {
                void var1_2;
                void var2_6;
                void var3_7;
                boolean flag3;
                byte[] byte2 = new byte[]{-20, -91, -63, 0};
                boolean flag2 = Arrays.equals(Arrays.copyOfRange(bytes, 512, 516), byte2);
                byte[] byte3 = new byte[]{0, 10, 0, 0, 0, 77, 83, 87, 111, 114, 100, 68, 111, 99, 0, 16, 0, 0, 0, 87, 111, 114, 100, 46, 68, 111, 99, 117, 109, 101, 110, 116, 46, 56, 0, -12, 57, -78, 113};
                byte[] range = Arrays.copyOfRange(bytes, 2075, 2142);
                boolean bl = flag3 = bytes.length > 2142 && FileMagicNumber.access$100(range, (byte[])var3_7) > 0;
                return var2_6 != false || var1_2 != false;
            }
            return false;
        }
    }
    ,
    XLS("application/vnd.ms-excel", "xls"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            byte[] byte52 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            boolean byte52 = bytes.length > 520 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte52);
            if (byte52) {
                void var1_2;
                void var3_8;
                void var2_6;
                boolean flag4;
                byte[] byte2 = new byte[]{-3, -1, -1, -1};
                boolean flag2 = Arrays.equals(Arrays.copyOfRange(bytes, 512, 516), byte2) && (bytes[518] == 0 || bytes[518] == 2);
                byte[] byte3 = new byte[]{9, 8, 16, 0, 0, 6, 5, 0};
                boolean flag3 = Arrays.equals(Arrays.copyOfRange(bytes, 512, 520), byte3);
                byte[] byte4 = new byte[]{-30, 0, 0, 0, 92, 0, 112, 0, 4, 0, 0, 67, 97, 108, 99};
                boolean bl = flag4 = bytes.length > 2095 && Arrays.equals(Arrays.copyOfRange(bytes, 1568, 2095), byte4);
                return var2_6 != false || var3_8 != false || var1_2 != false;
            }
            return false;
        }
    }
    ,
    PPT("application/vnd.ms-powerpoint", "ppt"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            byte[] byte72 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            boolean byte72 = bytes.length > 524 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte72);
            if (byte72) {
                void var1_2;
                void var3_8;
                void var2_6;
                boolean flag6;
                byte[] byte2 = new byte[]{-96, 70, 29, -16};
                byte[] byteRange = Arrays.copyOfRange(bytes, 512, 516);
                boolean flag2 = Arrays.equals(byteRange, byte2);
                byte[] byte3 = new byte[]{0, 110, 30, -16};
                boolean flag3 = Arrays.equals(byteRange, byte3);
                byte[] byte4 = new byte[]{15, 0, -24, 3};
                boolean flag4 = Arrays.equals(byteRange, byte4);
                byte[] byte5 = new byte[]{-3, -1, -1, -1};
                boolean flag5 = Arrays.equals(byteRange, byte5) && bytes[522] == 0 && bytes[523] == 0;
                byte[] byte6 = new byte[]{0, -71, 41, -24, 17, 0, 0, 0, 77, 83, 32, 80, 111, 119, 101, 114, 80, 111, 105, 110, 116, 32, 57, 55};
                boolean bl = flag6 = bytes.length > 2096 && Arrays.equals(Arrays.copyOfRange(bytes, 2072, 2096), byte6);
                return var2_6 != false || flag3 || flag4 || var3_8 != false || var1_2 != false;
            }
            return false;
        }
    }
    ,
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx"){
        {
            void var3_3;
        }

        @Override
        public final boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)DOCX);
        }
    }
    ,
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"){
        {
            void var3_3;
        }

        @Override
        public final boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)PPTX);
        }
    }
    ,
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"){
        {
            void var3_3;
        }

        @Override
        public final boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)XLSX);
        }
    }
    ,
    WASM("application/wasm", "wasm"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 7 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)97) && Objects.equals(bytes[2], (byte)115) && Objects.equals(bytes[3], (byte)109) && Objects.equals(bytes[4], (byte)1) && Objects.equals(bytes[5], (byte)0) && Objects.equals(bytes[6], (byte)0) && Objects.equals((byte)var1_1[7], (byte)0);
        }
    }
    ,
    DEX("application/vnd.android.dex", "dex"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 36 && Objects.equals(bytes[0], (byte)100) && Objects.equals(bytes[1], (byte)101) && Objects.equals(bytes[2], (byte)120) && Objects.equals(bytes[3], (byte)10) && Objects.equals((byte)var1_1[36], (byte)112);
        }
    }
    ,
    DEY("application/vnd.android.dey", "dey"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            return bytes.length > 100 && Objects.equals(bytes[0], (byte)100) && Objects.equals(bytes[1], (byte)101) && Objects.equals(bytes[2], (byte)121) && Objects.equals(bytes[3], (byte)10) && DEX.match(Arrays.copyOfRange((byte[])var1_1, 40, 100));
        }
    }
    ,
    EML("message/rfc822", "eml"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (bytes.length < 8) {
                return false;
            }
            byte[] byte1 = new byte[]{70, 114, 111, 109, 32, 32, 32};
            byte[] byte2 = new byte[]{70, 114, 111, 109, 32, 63, 63, 63};
            byte[] byte3 = new byte[]{70, 114, 111, 109, 58, 32};
            byte[] byte4 = new byte[]{82, 101, 116, 117, 114, 110, 45, 80, 97, 116, 104, 58, 32};
            return Arrays.equals(Arrays.copyOfRange(bytes, 0, 7), (byte[])var2_2) || Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), (byte[])var3_3) || Arrays.equals(Arrays.copyOfRange(bytes, 0, 6), byte3) || bytes.length > 13 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 13), byte4);
        }
    }
    ,
    MDB("application/vnd.ms-access", "mdb"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
            return bytes.length > 18 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 18), (byte[])var2_2);
        }
    }
    ,
    CHM("application/vnd.ms-htmlhelp", "chm"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{73, 84, 83, 70};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 4), (byte[])var2_2);
        }
    }
    ,
    CLASS("application/java-vm", "class"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{-54, -2, -70, -66};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 4), (byte[])var2_2);
        }
    }
    ,
    TORRENT("application/x-bittorrent", "torrent"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{100, 56, 58, 97, 110, 110, 111, 117, 110, 99, 101};
            return bytes.length > 11 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 11), (byte[])var2_2);
        }
    }
    ,
    WPD("application/vnd.wordperfect", "wpd"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{-1, 87, 80, 67};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 4), (byte[])var2_2);
        }
    }
    ,
    DBX("", "dbx"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{-49, -83, 18, -2};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 4), (byte[])var2_2);
        }
    }
    ,
    PST("application/vnd.ms-outlook-pst", "pst"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{33, 66, 68, 78};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 4), (byte[])var2_2);
        }
    }
    ,
    RAM("audio/x-pn-realaudio", "ram"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(byte[] bytes) {
            void var2_2;
            void var1_1;
            byte[] byte1 = new byte[]{46, 114, 97, -3, 0};
            return bytes.length > 5 && Arrays.equals(Arrays.copyOfRange((byte[])var1_1, 0, 5), (byte[])var2_2);
        }
    };

    private final String mimeType;
    private final String extension;

    /*
     * WARNING - void declaration
     */
    private FileMagicNumber(String mimeType, String extension) {
        void var3_3;
        this.mimeType = var3_3;
        this.extension = extension;
    }

    /*
     * WARNING - void declaration
     */
    public static FileMagicNumber getMagicNumber(byte[] bytes) {
        void var1_1;
        FileMagicNumber number = Arrays.stream(FileMagicNumber.values()).filter(fileMagicNumber -> {
            byte[] byArray;
            return fileMagicNumber.match(byArray);
        }).findFirst().orElse(UNKNOWN);
        if (number.equals((Object)ZIP)) {
            Object object;
            FileMagicNumber fileMagicNumber2 = FileMagicNumber.matchDocument(bytes);
            Object fn = (Object)fileMagicNumber2;
            if (fileMagicNumber2 == UNKNOWN) {
                return ZIP;
            }
            return object;
        }
        return var1_1;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    private static int indexOf(byte[] array, byte[] target) {
        if (array == null || target == null || array.length < target.length) {
            return -1;
        }
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean compareBytes(byte[] buf, byte[] slice, int startOffset) {
        void var1_1;
        void var3_3;
        byte[] byArray;
        void var2_2;
        int sl = slice.length;
        if (startOffset + sl > buf.length) {
            return false;
        }
        void v0 = var2_2;
        byArray = Arrays.copyOfRange(byArray, (int)v0, (int)(v0 + var3_3));
        return Arrays.equals(byArray, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static FileMagicNumber matchOpenXmlMime(byte[] bytes, int offset) {
        void var1_1;
        byte[] byArray;
        void var3_3;
        void var2_2;
        byte[] word = new byte[]{119, 111, 114, 100, 47};
        byte[] ppt = new byte[]{112, 112, 116, 47};
        byte[] xl = new byte[]{120, 108, 47};
        if (FileMagicNumber.compareBytes(bytes, (byte[])var2_2, offset)) {
            return DOCX;
        }
        if (FileMagicNumber.compareBytes(bytes, (byte[])var3_3, offset)) {
            return PPTX;
        }
        if (FileMagicNumber.compareBytes(byArray, xl, (int)var1_1)) {
            return XLSX;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static FileMagicNumber matchDocument(byte[] bytes) {
        FileMagicNumber fileMagicNumber = FileMagicNumber.matchOpenXmlMime(bytes, 30);
        if (!fileMagicNumber.equals((Object)UNKNOWN)) {
            return fileMagicNumber;
        }
        byte[] bytes1 = new byte[]{91, 67, 111, 110, 116, 101, 110, 116, 95, 84, 121, 112, 101, 115, 93, 46, 120, 109, 108};
        byte[] bytes2 = new byte[]{95, 114, 101, 108, 115, 47, 46, 114, 101, 108, 115};
        byte[] bytes3 = new byte[]{100, 111, 99, 80, 114, 111, 112, 115};
        boolean flag1 = FileMagicNumber.compareBytes(bytes, bytes1, 30);
        boolean flag2 = FileMagicNumber.compareBytes(bytes, bytes2, 30);
        boolean flag3 = FileMagicNumber.compareBytes(bytes, bytes3, 30);
        if (!(flag1 || flag2 || flag3)) {
            return UNKNOWN;
        }
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            void var3_7;
            FileMagicNumber fn;
            if ((index = FileMagicNumber.searchSignature(bytes, index + 4, 6000)) == -1 || (fn = FileMagicNumber.matchOpenXmlMime(bytes, index + 30)).equals((Object)UNKNOWN)) continue;
            return var3_7;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static int searchSignature(byte[] bytes, int start, int rangeNum) {
        void var0_1;
        void var1_2;
        void var3_4;
        void var2_3;
        int index;
        byte[] signature = new byte[]{80, 75, 3, 4};
        int end = start + rangeNum;
        int length = bytes.length;
        if (end > length) {
            end = length;
        }
        if ((index = FileMagicNumber.indexOf(Arrays.copyOfRange(bytes, start, (int)var2_3), (byte[])var3_4)) == -1) {
            return -1;
        }
        return (int)(var1_2 + var0_1);
    }

    public abstract boolean match(byte[] var1);

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(byte[] x0, byte[] x1) {
        void var1_1;
        return FileMagicNumber.indexOf(x0, (byte[])var1_1);
    }
}

