/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetDetector {
    private static final Charset[] DEFAULT_CHARSETS;

    /*
     * WARNING - void declaration
     */
    public static Charset detect(File file, Charset ... charsets) {
        void var1_1;
        return CharsetDetector.detect(FileUtil.getInputStream(file), (Charset[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Charset detect(InputStream in, Charset ... charsets) {
        void var1_1;
        InputStream inputStream;
        return CharsetDetector.detect(32768, inputStream, (Charset[])var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(int bufferSize, InputStream in, Charset ... charsets) {
        if (ArrayUtil.isEmpty(charsets)) {
            charsets = DEFAULT_CHARSETS;
        }
        Object buffer = new byte[bufferSize];
        block4: while (true) {
            int n;
            int n2;
            Charset[] charsetArray;
            block8: {
                try {
                    if (in.read((byte[])buffer) < 0) break block8;
                    charsetArray = charsets;
                    n2 = charsets.length;
                    n = 0;
                }
                catch (IOException e) {
                    try {
                        void var3_6;
                        throw new IORuntimeException((Throwable)var3_6);
                    }
                    catch (Throwable throwable) {
                        void var1_3;
                        IoUtil.close((Closeable)var1_3);
                        throw throwable;
                    }
                }
            }
            IoUtil.close(in);
            return null;
            while (true) {
                if (n >= n2) continue block4;
                Charset charset = charsetArray[n];
                CharsetDecoder decoder = charset.newDecoder();
                if (CharsetDetector.identify(buffer, decoder)) {
                    buffer = charset;
                    IoUtil.close(in);
                    return buffer;
                }
                ++n;
            }
            break;
        }
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            byte[] byArray;
            decoder.decode(ByteBuffer.wrap(byArray));
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        String[] names = new String[]{"UTF-8", "GBK", "GB2312", "GB18030", "UTF-16BE", "UTF-16LE", "UTF-16", "BIG5", "UNICODE", "US-ASCII"};
        DEFAULT_CHARSETS = Convert.convert(Charset[].class, (Object)var0);
    }
}

