/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class BufferUtil {
    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copy(ByteBuffer src, int start, int end) {
        void var1_1;
        void var2_2;
        return BufferUtil.copy(src, ByteBuffer.allocate((int)(var2_2 - var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest) {
        void var1_1;
        ByteBuffer byteBuffer;
        return BufferUtil.copy(src, dest, Math.min(byteBuffer.limit(), var1_1.remaining()));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest, int length) {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer = src;
        void v1 = var1_1;
        return BufferUtil.copy(byteBuffer, byteBuffer.position(), (ByteBuffer)v1, v1.position(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copy(ByteBuffer src, int srcStart, ByteBuffer dest, int destStart, int length) {
        void var2_2;
        void var3_3;
        void var1_1;
        System.arraycopy(src.array(), (int)var1_1, dest.array(), (int)var3_3, length);
        return var2_2;
    }

    public static String readUtf8Str(ByteBuffer buffer) {
        return BufferUtil.readStr(buffer, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String readStr(ByteBuffer buffer, Charset charset) {
        void var1_1;
        return StrUtil.str(BufferUtil.readBytes(buffer), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(ByteBuffer buffer) {
        void var1_2;
        ByteBuffer byteBuffer;
        int n = buffer.remaining();
        byte[] ab = new byte[n];
        byteBuffer.get(ab);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(ByteBuffer buffer, int maxLength) {
        void var1_2;
        ByteBuffer byteBuffer;
        int remaining = buffer.remaining();
        if (maxLength > remaining) {
            void var2_3;
            maxLength = var2_3;
        }
        byte[] ab = new byte[maxLength];
        byteBuffer.get(ab);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(ByteBuffer buffer, int start, int end) {
        void var2_3;
        void var1_1;
        ByteBuffer byteBuffer;
        byte[] bs = new byte[end - start];
        System.arraycopy(byteBuffer.array(), (int)var1_1, bs, 0, bs.length);
        return var2_3;
    }

    public static int lineEnd(ByteBuffer buffer) {
        ByteBuffer byteBuffer = buffer;
        return BufferUtil.lineEnd(byteBuffer, byteBuffer.remaining());
    }

    /*
     * WARNING - void declaration
     */
    public static int lineEnd(ByteBuffer buffer, int maxLength) {
        void var2_2;
        ByteBuffer byteBuffer;
        int primitivePosition = buffer.position();
        boolean canEnd = false;
        int charIndex = primitivePosition;
        while (buffer.hasRemaining()) {
            void var1_1;
            byte b = buffer.get();
            ++charIndex;
            if (b == 13) {
                canEnd = true;
            } else {
                if (b == 10) {
                    if (canEnd) {
                        return charIndex - 2;
                    }
                    return charIndex - 1;
                }
                canEnd = false;
            }
            if (charIndex - primitivePosition <= maxLength) continue;
            buffer.position(primitivePosition);
            throw new IndexOutOfBoundsException(StrUtil.format("Position is out of maxLength: {}", (int)var1_1));
        }
        byteBuffer.position((int)var2_2);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String readLine(ByteBuffer buffer, Charset charset) {
        void var2_2;
        void var3_3;
        int startPosition = buffer.position();
        int endPosition = BufferUtil.lineEnd(buffer);
        if (endPosition > startPosition) {
            void var1_1;
            Object object;
            byte[] byArray = BufferUtil.readBytes((ByteBuffer)object, startPosition, endPosition);
            object = byArray;
            return StrUtil.str(byArray, (Charset)var1_1);
        }
        if (var3_3 == var2_2) {
            return "";
        }
        return null;
    }

    public static ByteBuffer create(byte[] data) {
        return ByteBuffer.wrap(data);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer create(CharSequence data, Charset charset) {
        void var1_1;
        return BufferUtil.create(StrUtil.bytes(data, (Charset)var1_1));
    }

    public static ByteBuffer createUtf8(CharSequence data) {
        return BufferUtil.create(StrUtil.utf8Bytes(data));
    }

    public static CharBuffer createCharBuffer(int capacity) {
        return CharBuffer.allocate(capacity);
    }
}

