/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.io.IORuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private final PushbackInputStream in;
    private boolean isInited = false;
    private final String defaultCharset;
    private String charset;
    private static final int BOM_SIZE = 4;

    /*
     * WARNING - void declaration
     */
    public BOMInputStream(InputStream in) {
        this((InputStream)var1_1, "UTF-8");
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BOMInputStream(InputStream in, String defaultCharset) {
        void var2_2;
        void var1_1;
        this.in = new PushbackInputStream((InputStream)var1_1, 4);
        this.defaultCharset = var2_2;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    /*
     * WARNING - void declaration
     */
    public String getCharset() {
        if (!this.isInited) {
            try {
                this.init();
            }
            catch (IOException ex) {
                void var1_1;
                throw new IORuntimeException((Throwable)var1_1);
            }
        }
        return this.charset;
    }

    @Override
    public void close() throws IOException {
        this.isInited = true;
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        this.isInited = true;
        return this.in.read();
    }

    /*
     * WARNING - void declaration
     */
    protected void init() throws IOException {
        int unread;
        if (this.isInited) {
            return;
        }
        byte[] bom = new byte[4];
        int n = this.in.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.charset = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.charset = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.charset = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.charset = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.charset = "UTF-16LE";
            unread = n - 2;
        } else {
            this.charset = this.defaultCharset;
            unread = n;
        }
        if (unread > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.in.unread((byte[])var1_1, (int)(var2_2 - unread), (int)var3_3);
        }
        this.isInited = true;
    }
}

