/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img.gif;

import java.io.IOException;
import java.io.OutputStream;

class LZWEncoder {
    private static final int EOF = -1;
    private final int imgW;
    private final int imgH;
    private final byte[] pixAry;
    private final int initCodeSize;
    private int remaining;
    private int curPixel;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    final int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    /*
     * WARNING - void declaration
     */
    LZWEncoder(int width, int height, byte[] pixels, int color_depth) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.imgW = var1_1;
        this.imgH = var2_2;
        this.pixAry = var3_3;
        this.initCodeSize = Math.max(2, color_depth);
    }

    /*
     * WARNING - void declaration
     */
    void char_out(byte c, OutputStream outs) throws IOException {
        void var1_1;
        this.accum[this.a_count++] = var1_1;
        if (this.a_count >= 254) {
            void var2_2;
            this.flush_char((OutputStream)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void cl_block(OutputStream outs) throws IOException {
        void var1_1;
        LZWEncoder lZWEncoder = this;
        lZWEncoder.cl_hash(lZWEncoder.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        LZWEncoder lZWEncoder2 = this;
        lZWEncoder2.output(lZWEncoder2.ClearCode, (OutputStream)var1_1);
    }

    void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    void compress(int init_bits, OutputStream outs) throws IOException {
        void var2_2;
        int c;
        int fcode;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        int ent = this.nextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode <<= 1) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        LZWEncoder lZWEncoder = this;
        lZWEncoder.output(lZWEncoder.ClearCode, outs);
        block1: while ((c = this.nextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                void var1_1;
                ++this.free_ent;
                this.htab[var3_6] = var1_1;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        LZWEncoder lZWEncoder2 = this;
        lZWEncoder2.output(lZWEncoder2.EOFCode, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void encode(OutputStream os) throws IOException {
        void var1_1;
        os.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        LZWEncoder lZWEncoder = this;
        lZWEncoder.compress(lZWEncoder.initCodeSize + 1, os);
        var1_1.write(0);
    }

    /*
     * WARNING - void declaration
     */
    void flush_char(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            void var1_1;
            outs.write(this.a_count);
            var1_1.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int MAXCODE(int n_bits) {
        void var1_1;
        return (1 << var1_1) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte by = this.pixAry[this.curPixel++];
        return by & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    void output(int code, OutputStream outs) throws IOException {
        void var1_1;
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            LZWEncoder lZWEncoder = this;
            lZWEncoder.char_out((byte)lZWEncoder.cur_accum, outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (var1_1 == this.EOFCode) {
            void var2_2;
            while (this.cur_bits > 0) {
                LZWEncoder lZWEncoder = this;
                lZWEncoder.char_out((byte)lZWEncoder.cur_accum, outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char((OutputStream)var2_2);
        }
    }
}

