/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img.gif;

import cn.hutool.core.img.gif.LZWEncoder;
import cn.hutool.core.img.gif.NeuQuant;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class AnimatedGifEncoder {
    protected int width;
    protected int height;
    protected Color transparent = null;
    protected boolean transparentExactMatch = false;
    protected Color background = null;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 0;
    protected boolean started = false;
    protected OutputStream out;
    protected BufferedImage image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 10;

    /*
     * WARNING - void declaration
     */
    public void setDelay(int ms) {
        void var1_1;
        this.delay = Math.round((float)var1_1 / 10.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void setDispose(int code) {
        if (code >= 0) {
            void var1_1;
            this.dispose = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRepeat(int iter) {
        if (iter >= 0) {
            void var1_1;
            this.repeat = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparent(Color c) {
        void var1_1;
        this.setTransparent((Color)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparent(Color c, boolean exactMatch) {
        void var2_2;
        void var1_1;
        this.transparent = var1_1;
        this.transparentExactMatch = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackground(Color c) {
        void var1_1;
        this.background = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addFrame(BufferedImage im) {
        void var2_2;
        if (im == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            void var1_1;
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            this.image = var1_1;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException iOException) {
            ok = false;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean finish() {
        void var1_1;
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            ok = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            void var1_1;
            this.delay = Math.round(100.0f / var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setQuality(int quality) {
        void var1_1;
        if (quality <= 0) {
            quality = 1;
        }
        this.sample = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSize(int w, int h) {
        void var2_2;
        void var1_1;
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = var1_1;
        this.height = var2_2;
        if (this.width <= 0) {
            this.width = 320;
        }
        if (this.height <= 0) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean start(OutputStream os) {
        void var2_2;
        void var1_1;
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = var1_1;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            ok = false;
        }
        this.started = var2_2;
        return this.started;
    }

    /*
     * WARNING - void declaration
     */
    public boolean start(String file) {
        void var1_2;
        boolean ok;
        try {
            this.out = new BufferedOutputStream(Files.newOutputStream(Paths.get(file, new String[0]), new OpenOption[0]));
            AnimatedGifEncoder animatedGifEncoder = this;
            ok = animatedGifEncoder.start(animatedGifEncoder.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            ok = false;
        }
        this.started = var1_2;
        return this.started;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void analyzePixels() {
        int len = this.pixels.length;
        int nPix = len / 3;
        this.indexedPixels = new byte[nPix];
        NeuQuant nq = new NeuQuant(this.pixels, len, this.sample);
        this.colorTab = nq.process();
        for (int i = 0; i < this.colorTab.length; i += 3) {
            byte temp = this.colorTab[i];
            this.colorTab[i] = this.colorTab[i + 2];
            this.colorTab[i + 2] = temp;
            this.usedEntry[i / 3] = false;
        }
        int k = 0;
        for (int i = 0; i < nPix; ++i) {
            int index = nq.map(this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF);
            this.usedEntry[index] = true;
            this.indexedPixels[i] = (byte)index;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            int n;
            if (this.transparentExactMatch) {
                AnimatedGifEncoder animatedGifEncoder = this;
                n = animatedGifEncoder.findExact(animatedGifEncoder.transparent);
            } else {
                AnimatedGifEncoder animatedGifEncoder = this;
                n = animatedGifEncoder.findClosest(animatedGifEncoder.transparent);
            }
            this.transIndex = n;
        }
    }

    protected int findClosest(Color c) {
        if (this.colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int minpos = 0;
        int dmin = 0x1000000;
        int len = this.colorTab.length;
        for (int i = 0; i < len; ++i) {
            int dr = r - (this.colorTab[i++] & 0xFF);
            int dg = g - (this.colorTab[i++] & 0xFF);
            int db = b - (this.colorTab[i] & 0xFF);
            int n = dr;
            int n2 = dg;
            int n3 = db;
            int d = n * n + n2 * n2 + n3 * n3;
            int index = i / 3;
            if (!this.usedEntry[index] || d >= dmin) continue;
            dmin = d;
            minpos = index;
        }
        return minpos;
    }

    /*
     * WARNING - void declaration
     */
    boolean isColorUsed(Color c) {
        void var1_1;
        return this.findExact((Color)var1_1) != -1;
    }

    protected int findExact(Color c) {
        if (this.colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int len = this.colorTab.length / 3;
        for (int index = 0; index < len; ++index) {
            int i = index * 3;
            if (!this.usedEntry[index] || r != (this.colorTab[i] & 0xFF) || g != (this.colorTab[i + 1] & 0xFF) || b != (this.colorTab[i + 2] & 0xFF)) continue;
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected void getImagePixels() {
        void var3_5;
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int type = this.image.getType();
        if (w != this.width || h != this.height || var3_5 != 5) {
            void var1_2;
            void var2_4;
            BufferedImage temp = new BufferedImage(this.width, this.height, 5);
            Graphics2D g = temp.createGraphics();
            g.setColor(this.background);
            g.fillRect(0, 0, this.width, this.height);
            var2_4.drawImage(this.image, 0, 0, null);
            this.image = var1_2;
        }
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    /*
     * WARNING - void declaration
     */
    protected void writeGraphicCtrlExt() throws IOException {
        void var1_1;
        void var2_2;
        int disp;
        boolean transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            transp = false;
            disp = 0;
        } else {
            transp = true;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        disp <<= 2;
        this.out.write(0 | var2_2 | var1_1);
        AnimatedGifEncoder animatedGifEncoder = this;
        animatedGifEncoder.writeShort(animatedGifEncoder.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        AnimatedGifEncoder animatedGifEncoder = this;
        animatedGifEncoder.writeShort(animatedGifEncoder.width);
        AnimatedGifEncoder animatedGifEncoder2 = this;
        animatedGifEncoder2.writeShort(animatedGifEncoder2.height);
        if (this.firstFrame) {
            this.out.write(0);
            return;
        }
        this.out.write(0x80 | this.palSize);
    }

    protected void writeLSD() throws IOException {
        AnimatedGifEncoder animatedGifEncoder = this;
        animatedGifEncoder.writeShort(animatedGifEncoder.width);
        AnimatedGifEncoder animatedGifEncoder2 = this;
        animatedGifEncoder2.writeShort(animatedGifEncoder2.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        AnimatedGifEncoder animatedGifEncoder = this;
        animatedGifEncoder.writeShort(animatedGifEncoder.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder lZWEncoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeShort(int value) throws IOException {
        void var1_1;
        this.out.write(value & 0xFF);
        this.out.write((int)(var1_1 >> 8 & 0xFF));
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }
}

