/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.lang.Assert;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class LabColor {
    private static final ColorSpace XYZ_COLOR_SPACE = ColorSpace.getInstance(1001);
    private final double l;
    private final double a;
    private final double b;

    /*
     * WARNING - void declaration
     */
    public LabColor(Integer rgb) {
        this(rgb != null ? new Color(var1_1.intValue()) : null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabColor(Color color) {
        void var1_1;
        Assert.notNull(color, "Color must not be null", new Object[0]);
        float[] lab = this.fromXyz(color.getColorComponents(XYZ_COLOR_SPACE, null));
        this.l = lab[0];
        this.a = lab[1];
        this.b = (double)var1_1[2];
    }

    /*
     * WARNING - void declaration
     */
    public double getDistance(LabColor other) {
        void var2_2;
        void var1_1;
        double c1 = Math.sqrt(this.a * this.a + this.b * this.b);
        double deltaC = c1 - Math.sqrt(other.a * other.a + other.b * other.b);
        double deltaA = this.a - other.a;
        double deltaB = this.b - other.b;
        double d = deltaA;
        double d2 = deltaB;
        double d3 = deltaC;
        double deltaH = Math.sqrt(Math.max(0.0, d * d + d2 * d2 - d3 * d3));
        return Math.sqrt(Math.max(0.0, Math.pow(this.l - var1_1.l, 2.0) + Math.pow(deltaC / (1.0 + c1 * 0.045), 2.0) + Math.pow(deltaH / (1.0 + var2_2 * 0.015), 2.0)));
    }

    /*
     * WARNING - void declaration
     */
    private float[] fromXyz(float[] xyz) {
        void var1_1;
        return LabColor.fromXyz(xyz[0], xyz[1], (float)var1_1[2]);
    }

    /*
     * WARNING - void declaration
     */
    private static float[] fromXyz(float x, float y, float z) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        double l = (LabColor.f(y) - 16.0) * 116.0;
        double a = (LabColor.f(f) - LabColor.f(y)) * 500.0;
        double b = (LabColor.f((double)var1_1) - LabColor.f((double)var2_2)) * 200.0;
        return new float[]{(float)var3_3, (float)a, (float)b};
    }

    private static double f(double t) {
        double d;
        if (t > 0.008856451679035631) {
            return Math.cbrt(t);
        }
        return 0.3333333333333333 * Math.pow(4.833333333333333, 2.0) * d + 0.13793103448275862;
    }
}

