/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.BackgroundRemoval;
import cn.hutool.core.img.ColorUtil;
import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class ImgUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    /*
     * WARNING - void declaration
     */
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.scale((Image)image, (File)var1_2, (float)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.scale((Image)image, (OutputStream)var1_2, (float)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.scale((Image)image, (ImageOutputStream)var1_2, (float)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(Image srcImg, File destFile, float scale) throws IORuntimeException {
        void var1_1;
        void var2_2;
        Img.from(srcImg).setTargetImageType(FileUtil.extName(destFile)).scale((float)var2_2).write((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(Image srcImg, OutputStream out, float scale) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.scale(srcImg, ImgUtil.getImageOutputStream((OutputStream)var1_1), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws IORuntimeException {
        void var1_1;
        void var2_2;
        ImgUtil.writeJpg(ImgUtil.scale(srcImg, (float)var2_2), (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image scale(Image srcImg, float scale) {
        void var1_1;
        return Img.from(srcImg).scale((float)var1_1).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static Image scale(Image srcImg, int width, int height) {
        void var2_2;
        void var1_1;
        return Img.from(srcImg).scale((int)var1_1, (int)var2_2).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IORuntimeException {
        Img img = null;
        try {
            void var1_2;
            void var3_4;
            void var2_3;
            File file;
            img = Img.from(file);
            img.setTargetImageType(FileUtil.extName(destImageFile)).scale((int)var2_3, (int)var3_4, fixedColor).write((File)var1_2);
            return;
        }
        finally {
            IoUtil.flush(img);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.scale(image, ImgUtil.getImageOutputStream((OutputStream)var1_2), (int)var2_3, (int)var3_4, fixedColor);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.scale(image, (ImageOutputStream)var1_2, (int)var2_3, (int)var3_4, fixedColor);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        ImgUtil.writeJpg(ImgUtil.scale(srcImage, (int)var2_2, (int)var3_3, fixedColor), (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Img.from(srcImage).scale((int)var1_1, (int)var2_2, (Color)var3_3).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.cut((Image)image, (File)var1_2, (Rectangle)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.cut((Image)image, (OutputStream)var1_2, (Rectangle)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.cut((Image)image, (ImageOutputStream)var1_2, (Rectangle)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws IORuntimeException {
        void var1_1;
        void var2_2;
        ImgUtil.write(ImgUtil.cut(srcImage, (Rectangle)var2_2), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.cut(srcImage, ImgUtil.getImageOutputStream((OutputStream)var1_1), (Rectangle)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws IORuntimeException {
        void var1_1;
        void var2_2;
        ImgUtil.writeJpg(ImgUtil.cut(srcImage, (Rectangle)var2_2), (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image cut(Image srcImage, Rectangle rectangle) {
        void var1_1;
        return Img.from(srcImage).setPositionBaseCentre(false).cut((Rectangle)var1_1).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static Image cut(Image srcImage, int x, int y) {
        void var2_2;
        void var1_1;
        return ImgUtil.cut(srcImage, (int)var1_1, (int)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image cut(Image srcImage, int x, int y, int radius) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Img.from(srcImage).cut((int)var1_1, (int)var2_2, (int)var3_3).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.slice(image, (File)var1_2, (int)var2_3, (int)var3_4);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        int rows;
        int cols;
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)cols / (double)destWidth) + 1;
        rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)rows / (double)destHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image image = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImgUtil.write(image, FileUtil.file(descDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.sliceByRowsAndCols(srcImageFile, (File)var1_1, IMAGE_TYPE_JPEG, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void sliceByRowsAndCols(File srcImageFile, File destDir, String format, int rows, int cols) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.sliceByRowsAndCols(image, (File)var1_2, (String)var2_3, (int)var3_4, cols);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.sliceByRowsAndCols(srcImage, (File)var1_1, IMAGE_TYPE_JPEG, (int)var2_2, (int)var3_3);
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String format, int rows, int cols) {
        if (!destDir.exists()) {
            FileUtil.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        if (rows <= 0 || rows > 20) {
            rows = 2;
        }
        if (cols <= 0 || cols > 20) {
            cols = 2;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        int destWidth = NumberUtil.partValue(srcWidth, cols);
        int destHeight = NumberUtil.partValue(srcHeight, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image image = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImgUtil.write(image, new File(destDir, "_r" + i + "_c" + j + "." + format));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void convert(File srcImageFile, File destImageFile) {
        void var3_4;
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtil.extName(srcImageFile);
        String destExtName = FileUtil.extName(destImageFile);
        if (StrUtil.equalsIgnoreCase(srcExtName, (CharSequence)var3_4)) {
            FileUtil.copy(srcImageFile, destImageFile, true);
        }
        Img img = null;
        try {
            void var1_2;
            File file;
            img = Img.from(file);
            img.write((File)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.flush((Flushable)var2_3);
            throw throwable;
        }
        IoUtil.flush(img);
    }

    /*
     * WARNING - void declaration
     */
    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.write((Image)image, (String)var1_2, ImgUtil.getImageOutputStream((OutputStream)var2_3));
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        void var2_2;
        void var1_1;
        Img.from(srcImage).setTargetImageType((String)var1_1).write((ImageOutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        void var2_2;
        void var1_1;
        ImgUtil.convert(srcImage, (String)var1_1, (ImageOutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(File srcImageFile, File destImageFile) {
        BufferedImage image = null;
        try {
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.gray((Image)image, (File)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            ImgUtil.flush((Image)var2_3);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(InputStream srcStream, OutputStream destStream) {
        BufferedImage image = null;
        try {
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.gray((Image)image, (OutputStream)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            ImgUtil.flush((Image)var2_3);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        BufferedImage image = null;
        try {
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.gray((Image)image, (ImageOutputStream)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            ImgUtil.flush((Image)var2_3);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(Image srcImage, File outFile) {
        void var1_1;
        ImgUtil.write(ImgUtil.gray(srcImage), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(Image srcImage, OutputStream out) {
        void var1_1;
        ImgUtil.gray(srcImage, ImgUtil.getImageOutputStream((OutputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws IORuntimeException {
        void var1_1;
        ImgUtil.writeJpg(ImgUtil.gray(srcImage), (ImageOutputStream)var1_1);
    }

    public static Image gray(Image srcImage) {
        return Img.from(srcImage).gray().getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(File srcImageFile, File destImageFile) {
        BufferedImage image = null;
        try {
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.binary(image, (File)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            ImgUtil.flush((Image)var2_3);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.binary((Image)image, ImgUtil.getImageOutputStream((OutputStream)var1_2), (String)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.binary((Image)image, (ImageOutputStream)var1_2, (String)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(Image srcImage, File outFile) {
        void var1_1;
        ImgUtil.write(ImgUtil.binary(srcImage), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(Image srcImage, OutputStream out, String imageType) {
        void var2_2;
        void var1_1;
        ImgUtil.binary(srcImage, ImgUtil.getImageOutputStream((OutputStream)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws IORuntimeException {
        void var1_1;
        void var2_2;
        ImgUtil.write(ImgUtil.binary(srcImage), (String)var2_2, (ImageOutputStream)var1_1);
    }

    public static Image binary(Image srcImage) {
        return Img.from(srcImage).binary().getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.pressText((Image)image, (File)var1_2, (String)var2_3, (Color)var3_4, font, x, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.pressText((Image)image, ImgUtil.getImageOutputStream((OutputStream)var1_2), (String)var2_3, (Color)var3_4, font, x, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.pressText((Image)image, (ImageOutputStream)var1_2, (String)var2_3, (Color)var3_4, font, x, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        ImgUtil.write(ImgUtil.pressText(srcImage, (String)var2_2, (Color)var3_3, font, x, y, alpha), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.pressText(srcImage, ImgUtil.getImageOutputStream((OutputStream)var1_1), (String)var2_2, (Color)var3_3, font, x, y, alpha);
    }

    /*
     * WARNING - void declaration
     */
    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        ImgUtil.writeJpg(ImgUtil.pressText(srcImage, (String)var2_2, (Color)var3_3, font, x, y, alpha), (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Img.from(srcImage).pressText((String)var1_1, (Color)var2_2, (Font)var3_3, x, y, alpha).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.pressImage((Image)image, (File)var1_2, (Image)var2_3, (int)var3_4, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            InputStream inputStream;
            image = ImgUtil.read(inputStream);
            ImgUtil.pressImage((Image)image, ImgUtil.getImageOutputStream((OutputStream)var1_2), (Image)var2_3, (int)var3_4, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        BufferedImage image = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            ImageInputStream imageInputStream;
            image = ImgUtil.read(imageInputStream);
            ImgUtil.pressImage((Image)image, (ImageOutputStream)var1_2, (Image)var2_3, (int)var3_4, y, alpha);
            return;
        }
        finally {
            ImgUtil.flush(image);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        ImgUtil.write(ImgUtil.pressImage(srcImage, (Image)var2_2, (int)var3_3, y, alpha), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.pressImage(srcImage, ImgUtil.getImageOutputStream((OutputStream)var1_1), (Image)var2_2, (int)var3_3, y, alpha);
    }

    /*
     * WARNING - void declaration
     */
    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        ImgUtil.writeJpg(ImgUtil.pressImage(srcImage, (Image)var2_2, (int)var3_3, y, alpha), (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Img.from(srcImage).pressImage((Image)var1_1, (int)var2_2, (int)var3_3, alpha).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Img.from(srcImage).pressImage((Image)var1_1, (Rectangle)var2_2, (float)var3_3).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void rotate(File imageFile, int degree, File outFile) throws IORuntimeException {
        BufferedImage image = null;
        try {
            void var2_3;
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.rotate((Image)image, (int)var1_2, (File)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ImgUtil.flush((Image)var3_4);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void rotate(Image image, int degree, File outFile) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.write(ImgUtil.rotate(image, (int)var1_1), (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void rotate(Image image, int degree, OutputStream out) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.writeJpg(ImgUtil.rotate(image, (int)var1_1), ImgUtil.getImageOutputStream((OutputStream)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void rotate(Image image, int degree, ImageOutputStream out) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.writeJpg(ImgUtil.rotate(image, (int)var1_1), (ImageOutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Image rotate(Image image, int degree) {
        void var1_1;
        return Img.from(image).rotate((int)var1_1).getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void flip(File imageFile, File outFile) throws IORuntimeException {
        BufferedImage image = null;
        try {
            void var1_2;
            File file;
            image = ImgUtil.read(file);
            ImgUtil.flip((Image)image, (File)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            ImgUtil.flush((Image)var2_3);
            throw throwable;
        }
        ImgUtil.flush(image);
    }

    /*
     * WARNING - void declaration
     */
    public static void flip(Image image, File outFile) throws IORuntimeException {
        void var1_1;
        ImgUtil.write(ImgUtil.flip(image), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void flip(Image image, OutputStream out) throws IORuntimeException {
        void var1_1;
        ImgUtil.flip(image, ImgUtil.getImageOutputStream((OutputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void flip(Image image, ImageOutputStream out) throws IORuntimeException {
        void var1_1;
        ImgUtil.writeJpg(ImgUtil.flip(image), (ImageOutputStream)var1_1);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    /*
     * WARNING - void declaration
     */
    public static void compress(File imageFile, File outFile, float quality) throws IORuntimeException {
        Img img = null;
        try {
            void var1_2;
            void var2_3;
            File file;
            img = Img.from(file);
            img.setQuality((float)var2_3).write((File)var1_2);
        }
        catch (Throwable throwable) {
            void var3_4;
            IoUtil.flush((Flushable)var3_4);
            throw throwable;
        }
        IoUtil.flush(img);
    }

    @Deprecated
    public static RenderedImage toRenderedImage(Image img) {
        return ImgUtil.castToRenderedImage(img, IMAGE_TYPE_JPG);
    }

    @Deprecated
    public static BufferedImage toBufferedImage(Image img) {
        return ImgUtil.castToBufferedImage(img, IMAGE_TYPE_JPG);
    }

    /*
     * WARNING - void declaration
     */
    public static RenderedImage castToRenderedImage(Image img, String imageType) {
        void var1_1;
        Image image;
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImgUtil.toBufferedImage(image, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage castToBufferedImage(Image img, String imageType) {
        void var1_1;
        Image image;
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImgUtil.toBufferedImage(image, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage toBufferedImage(Image image, String imageType) {
        void var1_1;
        return ImgUtil.toBufferedImage(image, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        void var2_3;
        void var1_2;
        Image image2;
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImgUtil.toBufferedImage(image2, (int)var1_2, (Color)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage toBufferedImage(Image image, int imageType) {
        void var1_1;
        Image image2;
        if (image instanceof BufferedImage) {
            void var2_2;
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType);
            }
            return var2_2;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image2, (int)var1_1);
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        void var2_2;
        void var1_1;
        Image image2;
        if (image instanceof BufferedImage) {
            void var3_3;
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
            }
            return var3_3;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image2, (int)var1_1, (Color)var2_2);
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage copyImage(Image img, int imageType) {
        void var1_1;
        return ImgUtil.copyImage(img, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        void var1_3;
        img = new ImageIcon(img).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = GraphicsUtil.createGraphics(bimage, backgroundColor);
        try {
            Image image;
            bGr.drawImage(image, 0, 0, null);
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.dispose();
            throw throwable;
        }
        bGr.dispose();
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage createCompatibleImage(int width, int height, int transparency) throws HeadlessException {
        void var2_2;
        void var1_1;
        int n;
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        object = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        object = ((GraphicsDevice)object).getDefaultConfiguration();
        return ((GraphicsConfiguration)object).createCompatibleImage(n, (int)var1_1, (int)var2_2);
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        return ImgUtil.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        byte[] byArray;
        return ImgUtil.read(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteArrayInputStream toStream(Image image, String imageType) {
        void var1_1;
        return IoUtil.toStream(ImgUtil.toBytes(image, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toBase64DataUri(Image image, String imageType) {
        void var1_1;
        Image image2;
        return URLUtil.getDataUri("image/" + imageType, "base64", ImgUtil.toBase64(image2, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toBase64(Image image, String imageType) {
        void var1_1;
        return Base64.encode(ImgUtil.toBytes(image, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Image image, String imageType) {
        void var2_2;
        void var1_1;
        Image image2;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImgUtil.write(image2, (String)var1_1, out);
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.writePng((Image)ImgUtil.createImage(str, (Font)var1_1, (Color)var2_2, (Color)var3_3, 2), out);
    }

    /*
     * WARNING - void declaration
     */
    public static void createTransparentImage(String str, Font font, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        ImgUtil.writePng((Image)ImgUtil.createImage(str, (Font)var1_1, null, (Color)var2_2, 2), (ImageOutputStream)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) throws IORuntimeException {
        void var1_1;
        String string;
        void var3_3;
        Rectangle2D r = ImgUtil.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (backgroundColor != null) {
            void var2_2;
            g.setColor((Color)var2_2);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectUtil.defaultIfNull(var3_3, Color.BLACK));
        g.setFont(font);
        g.drawString(string, 0, var1_1.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        String string;
        return font.getStringBounds(string, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        return FontUtil.createFont(fontFile);
    }

    public static Font createFont(InputStream fontStream) {
        return FontUtil.createFont(fontStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        void var1_1;
        return GraphicsUtil.createGraphics(image, (Color)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        void var1_1;
        ImgUtil.write(image, IMAGE_TYPE_JPG, (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void writePng(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        void var1_1;
        ImgUtil.write(image, IMAGE_TYPE_PNG, (ImageOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeJpg(Image image, OutputStream out) throws IORuntimeException {
        void var1_1;
        ImgUtil.write(image, IMAGE_TYPE_JPG, (OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void writePng(Image image, OutputStream out) throws IORuntimeException {
        void var1_1;
        ImgUtil.write(image, IMAGE_TYPE_PNG, (OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        void var2_2;
        void var1_1;
        ImgUtil.write((Image)ImgUtil.read(srcStream), (String)var1_1, (ImageOutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Image image, String imageType, OutputStream out) throws IORuntimeException {
        void var2_2;
        void var1_1;
        ImgUtil.write(image, (String)var1_1, ImgUtil.getImageOutputStream((OutputStream)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return ImgUtil.write(image, (String)var1_1, (ImageOutputStream)var2_2, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImgUtil.write(image, (String)var1_1, (ImageOutputStream)var2_2, (float)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality, Color backgroundColor) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        Image image2;
        if (StrUtil.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        Image bufferedImage = ImgUtil.toBufferedImage(image, imageType, backgroundColor);
        ImageWriter writer = ImgUtil.getWriter(bufferedImage, imageType);
        return ImgUtil.write(image2, (ImageWriter)var1_1, (ImageOutputStream)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Image image, File targetFile) throws IORuntimeException {
        FileUtil.touch(targetFile);
        ImageOutputStream out = null;
        try {
            void var1_2;
            Image image2;
            out = ImgUtil.getImageOutputStream(targetFile);
            ImgUtil.write(image2, FileUtil.extName((File)var1_2), out);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(out);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgUtil.castToRenderedImage(image, IMAGE_TYPE_JPG);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            ColorModel colorModel;
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel2 = colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel2, colorModel2.createCompatibleSampleModel(16, 16)));
        }
        try {
            void var2_3;
            if (imgWriteParams != null) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                RenderedImage renderedImage2;
                writer.write(renderedImage2);
            }
            var2_3.flush();
            writer.dispose();
        }
        catch (IOException e) {
            try {
                void var3_6;
                throw new IORuntimeException((Throwable)var3_6);
            }
            catch (Throwable throwable) {
                void var1_2;
                var1_2.dispose();
                throw throwable;
            }
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            Iterator<ImageReader> iterator2;
            return (ImageReader)iterator2.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImgUtil.read(FileUtil.file(imageFilePath));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage read(File imageFile) {
        void var1_2;
        BufferedImage result;
        try {
            result = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        if (result == null) {
            File file;
            throw new IllegalArgumentException("Image type of file [" + file.getName() + "] is not supported!");
        }
        return var1_2;
    }

    public static Image getImage(URL url) {
        URL uRL;
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public static BufferedImage read(Resource resource) {
        return ImgUtil.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage bufferedImage;
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return bufferedImage;
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        BufferedImage bufferedImage;
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage read(URL imageUrl) {
        void var1_2;
        BufferedImage result;
        try {
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        if (result == null) {
            URL uRL;
            throw new IllegalArgumentException("Image type of [" + uRL + "] is not supported!");
        }
        return var1_2;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IORuntimeException {
        Closeable closeable;
        Closeable result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return closeable;
    }

    /*
     * WARNING - void declaration
     */
    public static ImageOutputStream getImageOutputStream(File outFile) throws IORuntimeException {
        void var1_2;
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
        if (result == null) {
            File file;
            throw new IllegalArgumentException("Image type of file [" + file.getName() + "] is not supported!");
        }
        return var1_2;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IORuntimeException {
        Closeable closeable;
        Closeable result;
        try {
            result = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return closeable;
    }

    /*
     * WARNING - void declaration
     */
    public static ImageWriter getWriter(Image img, String formatName) {
        void var1_1;
        Iterator<ImageWriter> iter = ImageIO.getImageWriters((ImageTypeSpecifier)(img = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toBufferedImage((Image)img, formatName))), (String)var1_1);
        if (iter.hasNext()) {
            Iterator<ImageWriter> iterator;
            return (ImageWriter)iterator.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ImageWriter getWriter(String formatName) {
        void var1_1;
        String string;
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (writer == null && (iter = ImageIO.getImageWritersBySuffix(string)).hasNext()) {
            void var2_2;
            writer = (ImageWriter)var2_2.next();
        }
        return var1_1;
    }

    public static String toHex(Color color) {
        return ColorUtil.toHex(color);
    }

    /*
     * WARNING - void declaration
     */
    public static String toHex(int r, int g, int b) {
        void var2_2;
        void var1_1;
        return ColorUtil.toHex(r, (int)var1_1, (int)var2_2);
    }

    public static Color hexToColor(String hex) {
        return ColorUtil.hexToColor(hex);
    }

    public static Color getColor(int rgb) {
        return ColorUtil.getColor(rgb);
    }

    public static Color getColor(String colorName) {
        return ColorUtil.getColor(colorName);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor();
    }

    public static Color randomColor(Random random) {
        return ColorUtil.randomColor(random);
    }

    /*
     * WARNING - void declaration
     */
    public static Point getPointBaseCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        Rectangle rectangle2;
        void var2_2;
        void var1_1;
        return new Point(rectangle.x + Math.abs((int)(var1_1 - rectangle.width)) / 2, rectangle.y + Math.abs((int)(var2_2 - rectangle2.height)) / 2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        void var1_1;
        return ColorUtil.getMainColor(image, (int[][])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(inputPath, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(input, (File)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(input, (File)var1_1, (Color)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(bufferedImage, (Color)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(outputStream, (Color)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage colorConvert(ColorSpace colorSpace, BufferedImage image) {
        void var1_1;
        ColorSpace colorSpace2;
        return ImgUtil.filter(new ColorConvertOp(colorSpace2, null), (BufferedImage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        void var1_1;
        AffineTransform affineTransform;
        return ImgUtil.filter(new AffineTransformOp(affineTransform, null), (BufferedImage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        void var1_1;
        return op.filter((BufferedImage)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Image filter(ImageFilter filter, Image image) {
        ImageFilter imageFilter;
        void var1_1;
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(var1_1.getSource(), imageFilter));
    }

    public static void flush(Image image) {
        if (image != null) {
            Image image2;
            image2.flush();
        }
    }
}

