/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.ImageFilter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Img
implements Flushable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;
    private Color backgroundColor;

    public static Img from(Path imagePath) {
        return Img.from(imagePath.toFile());
    }

    public static Img from(File imageFile) {
        File file;
        return new Img(ImgUtil.read(file));
    }

    public static Img from(Resource resource) {
        return Img.from(resource.getStream());
    }

    public static Img from(InputStream in) {
        InputStream inputStream;
        return new Img(ImgUtil.read(inputStream));
    }

    public static Img from(ImageInputStream imageStream) {
        ImageInputStream imageInputStream;
        return new Img(ImgUtil.read(imageInputStream));
    }

    public static Img from(URL imageUrl) {
        URL uRL;
        return new Img(ImgUtil.read(uRL));
    }

    public static Img from(Image image) {
        Image image2;
        return new Img(ImgUtil.castToBufferedImage(image2, "jpg"));
    }

    /*
     * WARNING - void declaration
     */
    public Img(BufferedImage srcImage) {
        this((BufferedImage)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Img(BufferedImage srcImage, String targetImageType) {
        void var2_2;
        this.srcImage = srcImage;
        if (targetImageType == null) {
            void var1_1;
            targetImageType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || var1_1.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Img setTargetImageType(String imgType) {
        void var1_1;
        this.targetImageType = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img setPositionBaseCentre(boolean positionBaseCentre) {
        void var1_1;
        this.positionBaseCentre = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img setQuality(double quality) {
        void var1_1;
        return this.setQuality((float)var1_1);
    }

    public Img setQuality(float quality) {
        float f;
        this.quality = quality > 0.0f && quality < 1.0f ? f : 1.0f;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img setBackgroundColor(Color backgroundColor) {
        void var1_1;
        this.backgroundColor = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            double scaleDouble;
            double d = scaleDouble = NumberUtil.toDouble(Float.valueOf(scale));
            this.targetImage = ImgUtil.transform(AffineTransform.getScaleInstance(d, d), ImgUtil.toBufferedImage(srcImg, this.targetImageType));
        } else {
            void var3_4;
            void var1_1;
            void var2_2;
            int width = NumberUtil.mul((Number)srcImg.getWidth(null), (Number)Float.valueOf(scale)).intValue();
            int height = NumberUtil.mul((Number)var2_2.getHeight(null), (Number)Float.valueOf((float)var1_1)).intValue();
            this.scale((int)var3_4, height);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img scale(int width, int height) {
        void var2_2;
        void var1_1;
        return this.scale((int)var1_1, (int)var2_2, 4);
    }

    /*
     * WARNING - void declaration
     */
    public Img scale(int width, int height, int scaleType) {
        Image srcImg = this.getValidSrcImg();
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImg;
            return this;
        }
        if ("png".equals(this.targetImageType)) {
            double sx = NumberUtil.div((float)width, (float)srcWidth);
            double sy = NumberUtil.div((float)height, (float)srcHeight);
            this.targetImage = ImgUtil.transform(AffineTransform.getScaleInstance(sx, sy), ImgUtil.toBufferedImage(srcImg, this.targetImageType));
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.targetImage = srcImg.getScaledInstance((int)var1_1, (int)var2_2, (int)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img scale(int width, int height, Color fixedColor) {
        void var3_3;
        void var2_2;
        void var1_1;
        double widthRatio;
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = NumberUtil.div((float)height, (float)srcHeight);
        if (NumberUtil.equals(heightRatio, widthRatio = NumberUtil.div((float)width, (float)srcWidth))) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        if (fixedColor != null) {
            g.setBackground(fixedColor);
            g.clearRect(0, 0, width, height);
        }
        g.drawImage(srcImage, (int)((var1_1 - srcWidth) / 2), (int)((var2_2 - srcHeight) / 2), srcWidth, srcHeight, (Color)var3_3, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img cut(Rectangle rectangle) {
        void var2_2;
        void var1_1;
        Image srcImage = this.getValidSrcImg();
        this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.targetImage = ImgUtil.filter((ImageFilter)var1_1, (Image)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img cut(int x, int y) {
        void var2_2;
        void var1_1;
        return this.cut((int)var1_1, (int)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public Img cut(int x, int y, int radius) {
        void var2_2;
        void var1_1;
        int diameter;
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int n = diameter = radius > 0 ? radius << 1 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(n, n, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            void var3_3;
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + var3_3 / 2;
        }
        g.drawImage(srcImage, (int)var1_1, (int)var2_2, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img round(double arc) {
        void var3_2;
        void var1_1;
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = NumberUtil.mul(arc, (float)Math.min(width, height));
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        void v0 = var1_1;
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, (double)v0, (double)v0));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)var3_2, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img gray() {
        this.targetImage = ImgUtil.colorConvert(ColorSpace.getInstance(1003), this.getValidSrcBufferedImg());
        return this;
    }

    public Img binary() {
        this.targetImage = ImgUtil.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.pressText((String)var1_1, (Color)var2_2, (Font)var3_3, new Point(x, y), alpha);
    }

    /*
     * WARNING - void declaration
     */
    public Img pressText(String pressText, Color color, Font font, Point point, float alpha) {
        BufferedImage targetImage = ImgUtil.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (font == null) {
            font = FontUtil.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        Graphics2D g = targetImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        if (this.positionBaseCentre) {
            GraphicsUtil.drawString((Graphics)g, pressText, font, color, new Rectangle(point.x, point.y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            void var2_2;
            void var3_3;
            void var1_1;
            GraphicsUtil.drawString((Graphics)g, (String)var1_1, (Font)var3_3, (Color)var2_2, point);
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img pressTextFull(String pressText, Color color, Font font, int lineHeight, int degree, float alpha) {
        Dimension dimension;
        BufferedImage targetImage = ImgUtil.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (font == null) {
            font = FontUtil.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        int targetHeight = targetImage.getHeight();
        int targetWidth = targetImage.getWidth();
        Graphics2D g = targetImage.createGraphics();
        g.setColor(color);
        g.rotate(Math.toRadians(degree), targetWidth >> 1, targetHeight >> 1);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        try {
            dimension = FontUtil.getDimension(g.getFontMetrics(font), pressText);
        }
        catch (Exception exception) {
            dimension = new Dimension(targetWidth / 3, targetHeight / 3);
        }
        int intervalHeight = dimension.height * lineHeight;
        int y = -targetHeight >> 1;
        while ((double)y < (double)targetHeight * 1.5) {
            int x = -targetWidth >> 1;
            while ((double)x < (double)targetWidth * 1.5) {
                GraphicsUtil.drawString((Graphics)g, pressText, font, color, new Point(x, y));
                x += dimension.width;
            }
            y += intervalHeight;
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img pressImage(Image pressImg, int x, int y, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage((Image)var1_1, new Rectangle((int)var2_2, (int)var3_3, pressImgWidth, pressImgHeight), alpha);
    }

    /*
     * WARNING - void declaration
     */
    public Img pressImage(Image pressImg, Rectangle rectangle, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        Image targetImg = this.getValidSrcImg();
        this.targetImage = this.draw(ImgUtil.toBufferedImage(targetImg, this.targetImageType), (Image)var1_1, (Rectangle)var2_2, (float)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img rotate(int degree) {
        void var2_2;
        void var3_3;
        void var1_1;
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Img.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        graphics2d.rotate(Math.toRadians((double)var1_1), (double)var3_3 / 2.0, (double)height / 2.0);
        graphics2d.drawImage((Image)var2_2, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img flip() {
        void var3_3;
        void var2_2;
        void var1_1;
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage((Image)var1_1, 0, 0, width, height, (int)var2_2, 0, 0, (int)var3_3, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Img stroke(Color color, float width) {
        void var2_2;
        void var1_1;
        return this.stroke((Color)var1_1, new BasicStroke((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Img stroke(Color color, Stroke stroke) {
        void var3_3;
        void var1_1;
        BufferedImage image = ImgUtil.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Graphics2D g = image.createGraphics();
        g.setColor(ObjectUtil.defaultIfNull(var1_1, Color.BLACK));
        if (stroke != null) {
            void var2_2;
            g.setStroke((Stroke)var2_2);
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        this.targetImage = var3_3;
        return this;
    }

    public Image getImg() {
        return this.getValidSrcImg();
    }

    /*
     * WARNING - void declaration
     */
    public boolean write(OutputStream out) throws IORuntimeException {
        void var1_1;
        return this.write(ImgUtil.getImageOutputStream((OutputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean write(ImageOutputStream targetImageStream) throws IORuntimeException {
        void var1_1;
        void var2_2;
        Assert.notBlank(this.targetImageType, "Target image type is blank !", new Object[0]);
        Assert.notNull(targetImageStream, "Target output stream is null !", new Object[0]);
        Image targetImage = this.targetImage == null ? this.srcImage : this.targetImage;
        Assert.notNull(targetImage, "Target image is null !", new Object[0]);
        return ImgUtil.write((Image)var2_2, this.targetImageType, (ImageOutputStream)var1_1, this.quality, this.backgroundColor);
    }

    /*
     * WARNING - void declaration
     */
    public boolean write(File targetFile) throws IORuntimeException {
        boolean bl;
        String formatName = FileUtil.extName(targetFile);
        if (StrUtil.isNotBlank(formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            void var1_1;
            out = ImgUtil.getImageOutputStream((File)var1_1);
            bl = this.write(out);
        }
        catch (Throwable throwable) {
            void var2_4;
            IoUtil.close((Closeable)var2_4);
            throw throwable;
        }
        IoUtil.close(out);
        return bl;
    }

    @Override
    public void flush() {
        ImgUtil.flush(this.srcImage);
        ImgUtil.flush(this.targetImage);
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle, float alpha) {
        void var1_1;
        void var3_3;
        void var2_2;
        Graphics2D g = backgroundImg.createGraphics();
        GraphicsUtil.setAlpha(g, alpha);
        this.fixRectangle(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight());
        GraphicsUtil.drawImg((Graphics)g, (Image)var2_2, (Rectangle)var3_3);
        g.dispose();
        return var1_1;
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return ObjectUtil.defaultIfNull(this.targetImage, this.srcImage);
    }

    private BufferedImage getValidSrcBufferedImg() {
        return ImgUtil.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
    }

    /*
     * WARNING - void declaration
     */
    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        void var1_1;
        if (this.positionBaseCentre) {
            void var2_3;
            void var3_4;
            Point pointBaseCentre = ImgUtil.getPointBaseCentre(rectangle, baseWidth, (int)var3_4);
            rectangle.setLocation(pointBaseCentre.x, var2_3.y);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        void var1_1;
        int n;
        void var3_5;
        void var2_2;
        if (degree < 0) {
            degree += 360;
        }
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        int n2 = height;
        int n3 = width;
        double r = Math.sqrt(n2 * n2 + n3 * n3) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + (var2_2 << 1);
        int des_height = height + (var3_5 << 1);
        return new Rectangle(n, (int)var1_1);
    }
}

