/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    /*
     * WARNING - void declaration
     */
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        void var2_2;
        Graphics2D g = image.createGraphics();
        if (color != null) {
            BufferedImage bufferedImage;
            void var1_1;
            g.setColor((Color)var1_1);
            g.fillRect(0, 0, image.getWidth(), bufferedImage.getHeight());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int getCenterY(Graphics g, int backgroundHeight) {
        void var0_1;
        void var1_2;
        void var2_3;
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {}
        int y = metrics != null ? (backgroundHeight - metrics.getHeight()) / 2 + var2_3.getAscent() : var1_2 / 3;
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics drawStringColourful(Graphics g, String str, Font font, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return GraphicsUtil.drawString(g, (String)var1_1, (Font)var2_2, null, (int)var3_3, height);
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, int width, int height) {
        Graphics graphics;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int midY = GraphicsUtil.getCenterY(g, height);
        if (color != null) {
            g.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (color == null) {
                g.setColor(ImgUtil.randomColor());
            }
            g.drawString(String.valueOf(str.charAt(i)), i * charWidth, midY);
        }
        return graphics;
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics drawString(Graphics g, String str, Font font, Color color, Rectangle rectangle) {
        void var3_3;
        void var2_2;
        void var1_1;
        Graphics graphics;
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = FontUtil.getDimension(g.getFontMetrics(font), str);
        }
        catch (Exception exception) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImgUtil.getPointBaseCentre(rectangle, backgroundWidth, backgroundHeight);
        return GraphicsUtil.drawString(graphics, (String)var1_1, (Font)var2_2, (Color)var3_3, point);
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics drawString(Graphics g, String str, Font font, Color color, Point point) {
        Graphics graphics;
        void var1_1;
        void var3_3;
        void var2_2;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont((Font)var2_2);
        g.setColor(ObjectUtil.defaultIfNull(var3_3, Color.BLACK));
        g.drawString((String)var1_1, point.x, point.y);
        return graphics;
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics drawImg(Graphics g, Image img, Point point) {
        void var1_1;
        void var2_2;
        return GraphicsUtil.drawImg(g, img, new Rectangle(point.x, var2_2.y, img.getWidth(null), var1_1.getHeight(null)));
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics drawImg(Graphics g, Image img, Rectangle rectangle) {
        Graphics graphics;
        void var2_2;
        void var1_1;
        g.drawImage((Image)var1_1, rectangle.x, rectangle.y, rectangle.width, var2_2.height, null);
        return graphics;
    }

    /*
     * WARNING - void declaration
     */
    public static Graphics2D setAlpha(Graphics2D g, float alpha) {
        Graphics2D graphics2D;
        void var1_1;
        g.setComposite(AlphaComposite.getInstance(10, (float)var1_1));
        return graphics2D;
    }
}

