/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ColorUtil {
    private static final int RGB_COLOR_BOUND = 256;

    public static String toHex(Color color) {
        Color color2;
        return ColorUtil.toHex(color.getRed(), color.getGreen(), color2.getBlue());
    }

    /*
     * WARNING - void declaration
     */
    public static String toHex(int r, int g, int b) {
        void var2_2;
        void var1_1;
        int n;
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", n, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Color getColor(String colorName) {
        if (StrUtil.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARKGRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ColorUtil.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ColorUtil.hexToColor("#ac9c85");
        }
        if (StrUtil.startWith((CharSequence)colorName, '#')) {
            return ColorUtil.hexToColor(colorName);
        }
        if (StrUtil.startWith((CharSequence)colorName, '$')) {
            return ColorUtil.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StrUtil.split((CharSequence)colorName, ',');
        if (3 == rgb.size()) {
            List<String> b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayUtil.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                List<String> list;
                void var2_2;
                void var1_1;
                return new Color(var1_1.intValue(), var2_2.intValue(), (Integer)((Object)list));
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color getColor(int rgb) {
        int n;
        return new Color(n);
    }

    public static Color hexToColor(String hex) {
        return ColorUtil.getColor(Integer.parseInt(StrUtil.removePrefix(hex, "#"), 16));
    }

    /*
     * WARNING - void declaration
     */
    public static Color add(Color color1, Color color2) {
        void var2_5;
        void var1_3;
        void var0_1;
        double r1 = color1.getRed();
        double g1 = color1.getGreen();
        double b1 = color1.getBlue();
        double a1 = color1.getAlpha();
        double r2 = color2.getRed();
        double g2 = color2.getGreen();
        double b2 = color2.getBlue();
        double a2 = color2.getAlpha();
        int r = (int)((r1 * a1 / 255.0 + r2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int g = (int)((g1 * a1 / 255.0 + g2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int b = (int)((b1 * a1 / 255.0 + b2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        return new Color((int)var0_1, (int)var1_3, (int)var2_5);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        Random random2;
        if (random == null) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random2.nextInt(256));
    }

    /*
     * WARNING - void declaration
     */
    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        void var3_17;
        void var2_11;
        void var1_5;
        String[] stringArray;
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        int width = ((BufferedImage)((Object)image)).getWidth();
        int height = ((BufferedImage)((Object)image)).getHeight();
        int minx = ((BufferedImage)((Object)image)).getMinX();
        int miny = ((BufferedImage)((Object)image)).getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g;
                int pixel = ((BufferedImage)((Object)image)).getRGB(i, j);
                int r = pixel >> 16 & 0xFF;
                if (ColorUtil.matchFilters(r, g = pixel >> 8 & 0xFF, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge(r + "-" + g + "-" + b, 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = StrUtil.splitToArray(maxColor, '-');
        String rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        String gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        String bHex = Integer.toHexString(Integer.parseInt(stringArray[2]));
        rHex = rHex.length() == 1 ? "0" + rHex : rHex;
        gHex = gHex.length() == 1 ? "0" + gHex : gHex;
        bHex = bHex.length() == 1 ? "0" + bHex : bHex;
        return "#" + (String)var1_5 + (String)var2_11 + (String)var3_17;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchFilters(int r, int g, int b, int[] ... rgbFilters) {
        if (rgbFilters != null && rgbFilters.length > 0) {
            void var3_3;
            for (void rgbFilter : var3_3) {
                if (r != rgbFilter[0] || g != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }
}

