/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class BackgroundRemoval {
    public static String[] IMAGES_TYPE = new String[]{"jpg", "png"};

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        void var2_2;
        void var1_1;
        String string;
        return BackgroundRemoval.backgroundRemoval(new File(string), new File((String)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        void var2_2;
        void var1_1;
        return BackgroundRemoval.backgroundRemoval(input, (File)var1_1, null, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        Object object;
        if (BackgroundRemoval.fileTypeValidation(input, IMAGES_TYPE)) {
            return false;
        }
        try {
            void var1_1;
            void var3_3;
            void var2_2;
            object = ImageIO.read((File)object);
            return ImageIO.write((RenderedImage)BackgroundRemoval.backgroundRemoval((BufferedImage)object, (Color)var2_2, (int)var3_3), "png", (File)var1_1);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        void var3_3;
        tolerance = Math.min(255, Math.max(tolerance, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        String[] removeRgb = BackgroundRemoval.getRemoveRgb(bufferedImage);
        String mainColor = BackgroundRemoval.getMainColor(bufferedImage);
        for (int y = image.getMinY(); y < image.getHeight(); ++y) {
            for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                String hex = ImgUtil.toHex(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
                boolean bl = ArrayUtil.contains(removeRgb, hex) || BackgroundRemoval.areColorsWithinTolerance(BackgroundRemoval.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                if (bl) {
                    rgb = override == null ? 0x1000000 | rgb & 0xFFFFFF : override.getRGB();
                }
                image.setRGB(x, y, rgb);
            }
        }
        graphics.drawImage(image, 0, 0, var3_3.getImageObserver());
        return image;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        IOException iOException;
        try {
            void var2_2;
            void var1_1;
            return BackgroundRemoval.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(((ByteArrayOutputStream)((Object)iOException)).toByteArray())), (Color)var1_1, (int)var2_2);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String[] getRemoveRgb(BufferedImage image) {
        void var0_2;
        void var1_4;
        void var3_7;
        void var2_5;
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ImgUtil.toHex(leftUpPixel >> 16 & 0xFF, leftUpPixel >> 8 & 0xFF, leftUpPixel & 0xFF);
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ImgUtil.toHex(upMiddlePixel >> 16 & 0xFF, upMiddlePixel >> 8 & 0xFF, upMiddlePixel & 0xFF);
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ImgUtil.toHex(rightUpPixel >> 16 & 0xFF, rightUpPixel >> 8 & 0xFF, rightUpPixel & 0xFF);
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ImgUtil.toHex(rightMiddlePixel >> 16 & 0xFF, rightMiddlePixel >> 8 & 0xFF, rightMiddlePixel & 0xFF);
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ImgUtil.toHex(lowerRightPixel >> 16 & 0xFF, lowerRightPixel >> 8 & 0xFF, lowerRightPixel & 0xFF);
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ImgUtil.toHex(lowerMiddlePixel >> 16 & 0xFF, lowerMiddlePixel >> 8 & 0xFF, lowerMiddlePixel & 0xFF);
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ImgUtil.toHex(leftLowerPixel >> 16 & 0xFF, leftLowerPixel >> 8 & 0xFF, leftLowerPixel & 0xFF);
        int leftMiddlePixel = image.getRGB(1, (int)(var2_5 / 2));
        String leftMiddle = ImgUtil.toHex(leftMiddlePixel >> 16 & 0xFF, leftMiddlePixel >> 8 & 0xFF, leftMiddlePixel & 0xFF);
        return new String[]{var3_7, upMiddle, rightUp, rightMiddle, lowerRight, var1_4, leftLower, var0_2};
    }

    public static Color hexToRgb(String hex) {
        String string;
        return new Color(Integer.parseInt(string.substring(1), 16));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areColorsWithinTolerance(Color color1, Color color2, int tolerance) {
        void var2_2;
        void var1_1;
        int n = tolerance;
        return BackgroundRemoval.areColorsWithinTolerance(color1, (Color)var1_1, new Color(n, n, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areColorsWithinTolerance(Color color1, Color color2, Color tolerance) {
        void var2_2;
        void var1_1;
        Color color;
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color.getGreen() - var1_1.getGreen() > -var2_2.getGreen();
    }

    public static String getMainColor(String input) {
        String string;
        return BackgroundRemoval.getMainColor(new File(string));
    }

    public static String getMainColor(File input) {
        try {
            return BackgroundRemoval.getMainColor(ImageIO.read(input));
        }
        catch (IOException iOException) {
            Serializable serializable = iOException;
            iOException.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getMainColor(BufferedImage bufferedImage) {
        void var3_8;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int y = ((BufferedImage)((Object)bufferedImage)).getMinY(); y < ((BufferedImage)((Object)bufferedImage)).getHeight(); ++y) {
            for (int x = ((BufferedImage)((Object)bufferedImage)).getMinX(); x < ((BufferedImage)((Object)bufferedImage)).getWidth(); ++x) {
                int pixel = ((BufferedImage)((Object)bufferedImage)).getRGB(x, y);
                arrayList.add((pixel >> 16 & 0xFF) + "-" + (pixel >> 8 & 0xFF) + "-" + (pixel & 0xFF));
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(arrayList.size(), 1.0f);
        for (String string : arrayList) {
            Integer integer = (Integer)map.get(string);
            integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
            map.put(string, integer);
        }
        String max = "";
        long num = 0L;
        for (Map.Entry entry : map.entrySet()) {
            void var2_6;
            String key = (String)entry.getKey();
            Integer n = (Integer)entry.getValue();
            if (!StrUtil.isBlank(max) && (long)n.intValue() <= num) continue;
            max = var2_6;
            num = n.intValue();
        }
        String[] strings = var3_8.split("-");
        if (strings.length == 3) {
            String[] stringArray;
            return ImgUtil.toHex(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(stringArray[2]));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static boolean fileTypeValidation(File input, String[] imagesType) {
        void var1_1;
        if (!input.exists()) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u6587\u4ef6\u4e3a\u7a7a");
        }
        String type = FileTypeUtil.getType(input);
        if (!ArrayUtil.contains(var1_1, type)) {
            String string;
            throw new IllegalArgumentException(StrUtil.format("\u6587\u4ef6\u7c7b\u578b{}\u4e0d\u652f\u6301", string));
        }
        return false;
    }
}

