/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.exceptions;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionUtil {
    public static String getMessage(Throwable e) {
        Throwable throwable;
        if (e == null) {
            return "null";
        }
        return StrUtil.format("{}: {}", e.getClass().getSimpleName(), throwable.getMessage());
    }

    public static String getSimpleMessage(Throwable e) {
        Throwable throwable;
        if (e == null) {
            return "null";
        }
        return throwable.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable2);
    }

    public static RuntimeException wrapRuntime(String message) {
        String string;
        return new RuntimeException(string);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T wrap(Throwable throwable, Class<T> wrapThrowable) {
        Throwable throwable2;
        void var1_1;
        if (wrapThrowable.isInstance(throwable)) {
            return (T)throwable;
        }
        return (T)((Throwable)ReflectUtil.newInstance(var1_1, new Object[]{throwable2}));
    }

    public static void wrapAndThrow(Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable2);
    }

    public static void wrapRuntimeAndThrow(String message) {
        String string;
        throw new RuntimeException(string);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable throwable;
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return throwable;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int i) {
        int n;
        return Thread.currentThread().getStackTrace()[n];
    }

    /*
     * WARNING - void declaration
     */
    public static StackTraceElement getStackElement(String fqcn, int i) {
        StackTraceElement[] stackTraceArray = Thread.currentThread().getStackTrace();
        int index = ArrayUtil.matchIndex(ele -> {
            void var1_1;
            return StrUtil.equals(fqcn, var1_1.getClassName());
        }, stackTraceArray);
        if (index > 0) {
            void var1_2;
            void var0_1;
            void var2_3;
            return var2_3[var0_1 + var1_2];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static StackTraceElement getRootStackElement() {
        void var0;
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        return Thread.currentThread().getStackTrace()[((void)var0).length - 1];
    }

    public static String stacktraceToOneLineString(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 3000);
    }

    /*
     * WARNING - void declaration
     */
    public static String stacktraceToOneLineString(Throwable throwable, int limit) {
        void var2_2;
        void var1_1;
        Throwable throwable2;
        HashMap<Character, String> replaceCharToStrMap = new HashMap<Character, String>();
        replaceCharToStrMap.put(Character.valueOf('\r'), " ");
        replaceCharToStrMap.put(Character.valueOf('\n'), " ");
        replaceCharToStrMap.put(Character.valueOf('\t'), " ");
        return ExceptionUtil.stacktraceToString(throwable2, (int)var1_1, (Map<Character, String>)var2_2);
    }

    public static String stacktraceToString(Throwable throwable) {
        return ExceptionUtil.stacktraceToString(throwable, 3000);
    }

    /*
     * WARNING - void declaration
     */
    public static String stacktraceToString(Throwable throwable, int limit) {
        void var1_1;
        return ExceptionUtil.stacktraceToString(throwable, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String stacktraceToString(Throwable throwable, int limit, Map<Character, String> replaceCharToStrMap) {
        void var1_1;
        String string;
        void var3_4;
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit < 0 || limit > length) {
            limit = length;
        }
        if (MapUtil.isNotEmpty(replaceCharToStrMap)) {
            void var3_5;
            StringBuilder sb = StrUtil.builder();
            for (int i = 0; i < limit; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (value != null) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return var3_5.toString();
        }
        if (limit == var3_4) {
            return exceptionStr;
        }
        return StrUtil.subPre(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        void var1_1;
        Throwable throwable2;
        return null != ExceptionUtil.getCausedBy(throwable2, var1_1);
    }

    public static Throwable getCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            Class<? extends Exception>[] classArray = causeClasses;
            int n = causeClasses.length;
            for (int i = 0; i < n; ++i) {
                Class<? extends Exception> clazz = classArray[i];
                if (!clazz.isInstance(cause)) continue;
                return cause;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass) {
        void var1_1;
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, var1_1, true) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass, boolean checkCause) {
        void var2_2;
        void var1_1;
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, var1_1, (boolean)var2_2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass) {
        void var1_1;
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass, boolean checkCause) {
        Throwable throwable2;
        Throwable cause;
        if (throwable == null || exceptionClass == null) {
            return null;
        }
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        if (checkCause && (cause = throwable.getCause()) != null && exceptionClass.isAssignableFrom(cause.getClass())) {
            return (T)cause;
        }
        Throwable[] throwables = throwable2.getSuppressed();
        if (ArrayUtil.isNotEmpty(throwables)) {
            void var2_4;
            for (Throwable throwable1 : var2_4) {
                if (!exceptionClass.isAssignableFrom(throwable1.getClass())) continue;
                return (T)throwable1;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Throwable> getThrowableList(Throwable throwable) {
        void var1_1;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return var1_1;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list;
        List<Throwable> list2 = ExceptionUtil.getThrowableList(throwable);
        if (list2.size() <= 0) {
            return null;
        }
        List<Throwable> list3 = list;
        return (Throwable)list3.get(list3.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        return ExceptionUtil.getMessage(ExceptionUtil.getRootCause(th));
    }
}

