/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date.format;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.SafeConcurrentHashMap;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;

public class GlobalCustomFormat {
    public static final String FORMAT_SECONDS = "#sss";
    public static final String FORMAT_MILLISECONDS = "#SSS";
    private static final Map<CharSequence, Function<Date, String>> formatterMap = new SafeConcurrentHashMap<CharSequence, Function<Date, String>>();
    private static final Map<CharSequence, Function<CharSequence, Date>> parserMap = new SafeConcurrentHashMap<CharSequence, Function<CharSequence, Date>>();

    /*
     * WARNING - void declaration
     */
    public static void putFormatter(String format, Function<Date, String> func) {
        void var1_1;
        String string;
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        formatterMap.put(string, (Function<Date, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putParser(String format, Function<CharSequence, Date> func) {
        void var1_1;
        String string;
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        parserMap.put(string, (Function<CharSequence, Date>)var1_1);
    }

    public static boolean isCustomFormat(String format) {
        String string;
        return formatterMap.containsKey(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Date date, CharSequence format) {
        Function<Date, String> func;
        if (formatterMap != null && (func = formatterMap.get(format)) != null) {
            Date date2;
            void var1_1;
            return (String)var1_1.apply(date2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String format(TemporalAccessor temporalAccessor, CharSequence format) {
        void var1_1;
        return GlobalCustomFormat.format(DateUtil.date(temporalAccessor), (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date parse(CharSequence dateStr, String format) {
        Function<CharSequence, Date> func;
        if (parserMap != null && (func = parserMap.get(format)) != null) {
            CharSequence charSequence;
            void var1_1;
            return (Date)var1_1.apply(charSequence);
        }
        return null;
    }

    static {
        GlobalCustomFormat.putFormatter(FORMAT_SECONDS, date -> String.valueOf(Math.floorDiv(date.getTime(), 1000L)));
        GlobalCustomFormat.putParser(FORMAT_SECONDS, dateStr -> DateUtil.date(Math.multiplyExact(Long.parseLong(dateStr.toString()), 1000L)));
        GlobalCustomFormat.putFormatter(FORMAT_MILLISECONDS, date -> String.valueOf(date.getTime()));
        GlobalCustomFormat.putParser(FORMAT_MILLISECONDS, dateStr -> DateUtil.date(Long.parseLong(dateStr.toString())));
    }
}

