/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date.format;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.map.SafeConcurrentHashMap;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private final ConcurrentMap<Tuple, F> cInstanceCache = new SafeConcurrentHashMap<Tuple, F>(7);
    private static final ConcurrentMap<Tuple, String> C_DATE_TIME_INSTANCE_CACHE = new SafeConcurrentHashMap<Tuple, String>(7);

    FormatCache() {
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        Format previousValue;
        Tuple key;
        Format format;
        Assert.notBlank(pattern, "pattern must not be blank", new Object[0]);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format = (Format)this.cInstanceCache.get(key = new Tuple(pattern, timeZone, locale))) == null && (previousValue = this.cInstanceCache.putIfAbsent(key, format = this.createInstance(pattern, (TimeZone)var2_2, (Locale)var3_3))) != null) {
            void var1_1;
            format = var1_1;
        }
        return (F)format;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    /*
     * WARNING - void declaration
     */
    F getDateTimeInstance(Integer dateStyle, Integer timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String pattern = FormatCache.getPatternForStyle(dateStyle, (Integer)var2_2, locale);
        return this.getInstance((String)var1_1, (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    F getDateInstance(int dateStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((int)var1_1, null, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    F getTimeInstance(int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance(null, (int)var1_1, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String getPatternForStyle(Integer dateStyle, Integer timeStyle, Locale locale) {
        Tuple key = new Tuple(dateStyle, timeStyle, locale);
        Object pattern = (String)C_DATE_TIME_INSTANCE_CACHE.get(key);
        if (pattern == null) {
            try {
                void var3_3;
                void var1_1;
                String formatter;
                formatter = dateStyle == null ? DateFormat.getTimeInstance(timeStyle, locale) : (timeStyle == null ? DateFormat.getDateInstance((Integer)((Object)formatter), locale) : DateFormat.getDateTimeInstance((Integer)((Object)formatter), var1_1.intValue(), locale));
                pattern = ((SimpleDateFormat)((Object)formatter)).toPattern();
                String previous = C_DATE_TIME_INSTANCE_CACHE.putIfAbsent((Tuple)var3_3, (String)pattern);
                if (previous != null) {
                    String string;
                    pattern = string;
                }
            }
            catch (ClassCastException classCastException) {
                void var2_2;
                throw new IllegalArgumentException("No date time pattern for locale: " + var2_2);
            }
        }
        return pattern;
    }
}

