/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date.format;

import cn.hutool.core.date.DateException;
import cn.hutool.core.date.format.AbstractDateBasic;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.map.SafeConcurrentHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;

public class FastDatePrinter
extends AbstractDateBasic
implements DatePrinter {
    private static final long serialVersionUID = -6305750172255764887L;
    private transient Rule[] rules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<TimeZoneDisplayKey, String> C_TIME_ZONE_DISPLAY_CACHE = new SafeConcurrentHashMap<TimeZoneDisplayKey, String>(7);

    /*
     * WARNING - void declaration
     */
    public FastDatePrinter(String pattern, TimeZone timeZone, Locale locale) {
        super((String)var1_1, (TimeZone)var2_2, (Locale)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var1_2;
        List<Rule> rulesList = this.parsePattern();
        this.rules = rulesList.toArray(new Rule[0]);
        int len = 0;
        int i = this.rules.length;
        while (--i >= 0) {
            len += this.rules[i].estimateLength();
        }
        this.mMaxLengthEstimate = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Rule> parsePattern() {
        void var2_2;
        DateFormatSymbols symbols = new DateFormatSymbols(this.locale);
        ArrayList<Iso8601_Rule> rules = new ArrayList<Iso8601_Rule>();
        String[] ERAs = symbols.getEras();
        String[] months = symbols.getMonths();
        String[] shortMonths = symbols.getShortMonths();
        String[] weekdays = symbols.getWeekdays();
        String[] shortWeekdays = symbols.getShortWeekdays();
        String[] AmPmStrings = symbols.getAmPmStrings();
        int length = this.pattern.length();
        int[] indexRef = new int[1];
        for (int i = 0; i < length; ++i) {
            Rule rule;
            indexRef[0] = i;
            FastDatePrinter fastDatePrinter = this;
            String token = fastDatePrinter.parseToken(fastDatePrinter.pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'G': {
                    rule = new TextField(0, ERAs);
                    break;
                }
                case 'Y': 
                case 'y': {
                    rule = tokenLen == 2 ? TwoDigitYearField.INSTANCE : this.selectNumberRule(1, Math.max(tokenLen, 4));
                    if (c != 'Y') break;
                    rule = new WeekYear((NumberRule)rule);
                    break;
                }
                case 'M': {
                    if (tokenLen >= 4) {
                        rule = new TextField(2, months);
                        break;
                    }
                    if (tokenLen == 3) {
                        rule = new TextField(2, shortMonths);
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, tokenLen);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(this.selectNumberRule(10, tokenLen));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, tokenLen);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, tokenLen);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, tokenLen);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, tokenLen);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, tokenLen < 4 ? shortWeekdays : weekdays);
                    break;
                }
                case 'u': {
                    rule = new DayInWeekField(this.selectNumberRule(7, tokenLen));
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, tokenLen);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, tokenLen);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, tokenLen);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, tokenLen);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, AmPmStrings);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(this.selectNumberRule(11, tokenLen));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, tokenLen);
                    break;
                }
                case 'X': {
                    rule = Iso8601_Rule.getRule(tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        rule = new TimeZoneNameRule(this.timeZone, this.locale, 1);
                        break;
                    }
                    rule = new TimeZoneNameRule(this.timeZone, this.locale, 0);
                    break;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        rule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    rule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String sub = ((String)((Object)rule)).substring(1);
                    if (sub.length() == 1) {
                        rule = new CharacterLiteral(sub.charAt(0));
                        break;
                    }
                    rule = new StringLiteral((String)((Object)rule));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + (String)((Object)rule));
                }
            }
            rules.add((Iso8601_Rule)rule);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String parseToken(String pattern, int[] indexRef) {
        void var3_3;
        int i;
        StringBuilder buf = new StringBuilder();
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            buf.append(c);
            while (i + 1 < length && (c2 = pattern.charAt(i + 1)) == c) {
                buf.append(c);
                ++i;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i = indexRef[0]; i < length; ++i) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    buf.append(c);
                    continue;
                }
                break;
            }
        }
        var2_2[0] = --i;
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected NumberRule selectNumberRule(int field, int padding) {
        void var2_2;
        void var1_1;
        switch (padding) {
            case 1: {
                return new UnpaddedNumberField(field);
            }
            case 2: {
                return new TwoDigitNumberField(field);
            }
        }
        return new PaddedNumberField((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    String format(Object obj) {
        void var1_1;
        if (obj instanceof Date) {
            return this.format((Date)obj);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj);
        }
        if (obj instanceof Long) {
            return this.format((Long)obj);
        }
        throw new IllegalArgumentException("Unknown class: " + (obj == null ? "<null>" : var1_1.getClass().getName()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(long millis) {
        void var3_2;
        void var1_1;
        Calendar c = Calendar.getInstance(this.timeZone, this.locale);
        c.setTimeInMillis((long)var1_1);
        return this.applyRulesToString((Calendar)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(Date date) {
        void var2_2;
        void var1_1;
        Calendar c = Calendar.getInstance(this.timeZone, this.locale);
        c.setTime((Date)var1_1);
        return this.applyRulesToString((Calendar)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(Calendar calendar) {
        void var1_1;
        return this.format((Calendar)var1_1, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        void var3_2;
        void var1_1;
        Calendar c = Calendar.getInstance(this.timeZone, this.locale);
        c.setTimeInMillis((long)var1_1);
        return this.applyRules(c, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        void var2_2;
        void var3_3;
        void var1_1;
        Calendar c = Calendar.getInstance(this.timeZone, this.locale);
        c.setTime((Date)var1_1);
        return this.applyRules((Calendar)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        void var2_2;
        void var1_1;
        if (!calendar.getTimeZone().equals(this.timeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.timeZone);
        }
        return this.applyRules((Calendar)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String applyRulesToString(Calendar c) {
        void var1_1;
        return this.applyRules((Calendar)var1_1, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private <B extends Appendable> B applyRules(Calendar calendar, B buf) {
        void var2_2;
        try {
            Rule[] ruleArray = this.rules;
            int n = this.rules.length;
            for (int i = 0; i < n; ++i) {
                Rule rule = ruleArray[i];
                rule.appendTo(buf, calendar);
            }
        }
        catch (IOException e) {
            void var3_4;
            throw new DateException((Throwable)var3_4);
        }
        return var2_2;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private static void appendDigits(Appendable buffer, int value) throws IOException {
        void var1_1;
        Appendable appendable;
        buffer.append((char)(value / 10 + 48));
        appendable.append((char)(var1_1 % 10 + 48));
    }

    private static void appendFullDigits(Appendable buffer, int value, int minFieldWidth) throws IOException {
        if (value < 10000) {
            int nDigits = 4;
            if (value < 1000) {
                --nDigits;
                if (value < 100) {
                    --nDigits;
                    if (value < 10) {
                        --nDigits;
                    }
                }
            }
            for (int i = minFieldWidth - nDigits; i > 0; --i) {
                buffer.append('0');
            }
            switch (nDigits) {
                case 4: {
                    buffer.append((char)(value / 1000 + 48));
                    value %= 1000;
                }
                case 3: {
                    if (value >= 100) {
                        buffer.append((char)(value / 100 + 48));
                        value %= 100;
                    } else {
                        buffer.append('0');
                    }
                }
                case 2: {
                    if (value >= 10) {
                        buffer.append((char)(value / 10 + 48));
                        value %= 10;
                    } else {
                        buffer.append('0');
                    }
                }
                case 1: {
                    buffer.append((char)(value + 48));
                }
            }
            return;
        }
        char[] work = new char[10];
        int digit = 0;
        while (value != 0) {
            work[digit++] = (char)(value % 10 + 48);
            value /= 10;
        }
        while (digit < minFieldWidth) {
            buffer.append('0');
            --minFieldWidth;
        }
        while (--digit >= 0) {
            buffer.append(work[digit]);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String getTimeZoneDisplay(TimeZone tz, boolean daylight, int style, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object prior;
        TimeZoneDisplayKey key = new TimeZoneDisplayKey(tz, daylight, style, locale);
        Object value = (String)C_TIME_ZONE_DISPLAY_CACHE.get(key);
        if (value == null && (prior = C_TIME_ZONE_DISPLAY_CACHE.putIfAbsent(key, (String)(value = tz.getDisplayName((boolean)var1_1, (int)var2_2, (Locale)var3_3)))) != null) {
            Object object;
            value = object;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Appendable x0, int x1) throws IOException {
        void var1_1;
        FastDatePrinter.appendDigits(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Appendable x0, int x1, int x2) throws IOException {
        void var2_2;
        void var1_1;
        FastDatePrinter.appendFullDigits(x0, (int)var1_1, (int)var2_2);
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone mTimeZone;
        private final int mStyle;
        private final Locale mLocale;

        /*
         * WARNING - void declaration
         */
        TimeZoneDisplayKey(TimeZone timeZone, boolean daylight, int style, Locale locale) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mTimeZone = var1_1;
            this.mStyle = var2_2 != false ? style | Integer.MIN_VALUE : var3_3;
            this.mLocale = locale;
        }

        public int hashCode() {
            return (this.mStyle * 31 + this.mLocale.hashCode()) * 31 + this.mTimeZone.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TimeZoneDisplayKey) {
                void var1_1;
                TimeZoneDisplayKey other = (TimeZoneDisplayKey)obj;
                return this.mTimeZone.equals(other.mTimeZone) && this.mStyle == other.mStyle && this.mLocale.equals(var1_1.mLocale);
            }
            return false;
        }
    }

    private static class Iso8601_Rule
    implements Rule {
        static final Iso8601_Rule ISO8601_HOURS = new Iso8601_Rule(3);
        static final Iso8601_Rule ISO8601_HOURS_MINUTES = new Iso8601_Rule(5);
        static final Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new Iso8601_Rule(6);
        final int length;

        static Iso8601_Rule getRule(int tokenLen) {
            switch (tokenLen) {
                case 1: {
                    return ISO8601_HOURS;
                }
                case 2: {
                    return ISO8601_HOURS_MINUTES;
                }
                case 3: {
                    return ISO8601_HOURS_COLON_MINUTES;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }

        /*
         * WARNING - void declaration
         */
        Iso8601_Rule(int length) {
            void var1_1;
            this.length = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            void var3_4;
            int offset = calendar.get(15) + calendar.get(16);
            if (offset == 0) {
                buffer.append("Z");
                return;
            }
            if (offset < 0) {
                buffer.append('-');
                offset = -offset;
            } else {
                buffer.append('+');
            }
            int hours = offset / 3600000;
            FastDatePrinter.access$000(buffer, hours);
            if (this.length < 5) {
                return;
            }
            if (this.length == 6) {
                buffer.append(':');
            }
            int minutes = offset / 60000 - var3_4 * 60;
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_3);
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        /*
         * WARNING - void declaration
         */
        TimeZoneNumberRule(boolean colon) {
            void var1_1;
            this.mColon = var1_1;
        }

        @Override
        public int estimateLength() {
            return 5;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            void var3_4;
            int offset = calendar.get(15) + calendar.get(16);
            if (offset < 0) {
                buffer.append('-');
                offset = -offset;
            } else {
                buffer.append('+');
            }
            int hours = offset / 3600000;
            FastDatePrinter.access$000(buffer, hours);
            if (this.mColon) {
                buffer.append(':');
            }
            int minutes = offset / 60000 - var3_4 * 60;
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_3);
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final Locale mLocale;
        private final int mStyle;
        private final String mStandard;
        private final String mDaylight;

        /*
         * WARNING - void declaration
         */
        TimeZoneNameRule(TimeZone timeZone, Locale locale, int style) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.mLocale = locale;
            this.mStyle = style;
            this.mStandard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, style, locale);
            this.mDaylight = FastDatePrinter.getTimeZoneDisplay((TimeZone)var1_1, true, (int)var3_3, (Locale)var2_2);
        }

        @Override
        public int estimateLength() {
            return Math.max(this.mStandard.length(), this.mDaylight.length());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            TimeZone zone = calendar.getTimeZone();
            if (var2_2.get(16) != 0) {
                buffer.append(FastDatePrinter.getTimeZoneDisplay(zone, true, this.mStyle, this.mLocale));
                return;
            }
            var1_1.append(FastDatePrinter.getTimeZoneDisplay((TimeZone)var3_3, false, this.mStyle, this.mLocale));
        }
    }

    private static class WeekYear
    implements NumberRule {
        private final NumberRule mRule;

        /*
         * WARNING - void declaration
         */
        WeekYear(NumberRule rule) {
            void var1_1;
            this.mRule = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.mRule.appendTo((Appendable)var1_1, var2_2.getWeekYear());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.mRule.appendTo((Appendable)var1_1, (int)var2_2);
        }
    }

    private static class DayInWeekField
    implements NumberRule {
        private final NumberRule mRule;

        /*
         * WARNING - void declaration
         */
        DayInWeekField(NumberRule rule) {
            void var1_1;
            this.mRule = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            int value = calendar.get(7);
            this.mRule.appendTo((Appendable)var1_1, value != 1 ? var2_3 - true : 7);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.mRule.appendTo((Appendable)var1_1, (int)var2_2);
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        /*
         * WARNING - void declaration
         */
        TwentyFourHourField(NumberRule rule) {
            void var1_1;
            this.mRule = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var3_3;
            void var1_1;
            int value = calendar.get(11);
            if (value == 0) {
                void var2_2;
                value = var2_2.getMaximum(11) + 1;
            }
            this.mRule.appendTo((Appendable)var1_1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.mRule.appendTo((Appendable)var1_1, (int)var2_2);
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        /*
         * WARNING - void declaration
         */
        TwelveHourField(NumberRule rule) {
            void var1_1;
            this.mRule = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var3_3;
            void var1_1;
            int value = calendar.get(10);
            if (value == 0) {
                void var2_2;
                value = var2_2.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo((Appendable)var1_1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.mRule.appendTo((Appendable)var1_1, (int)var2_2);
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(2) + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$000(buffer, (int)var2_2);
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(1) % 100);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$000(buffer, (int)var2_2);
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        /*
         * WARNING - void declaration
         */
        TwoDigitNumberField(int field) {
            void var1_1;
            this.mField = var1_1;
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.mField));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 100) {
                FastDatePrinter.access$000(buffer, value);
                return;
            }
            FastDatePrinter.access$100((Appendable)var1_1, (int)var2_2, 2);
        }
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        /*
         * WARNING - void declaration
         */
        PaddedNumberField(int field, int size) {
            void var2_2;
            void var1_1;
            if (size < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = var1_1;
            this.mSize = var2_2;
        }

        @Override
        public int estimateLength() {
            return this.mSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.mField));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$100(buffer, (int)var2_2, this.mSize);
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(2) + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_2);
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        /*
         * WARNING - void declaration
         */
        UnpaddedNumberField(int field) {
            void var1_1;
            this.mField = var1_1;
        }

        @Override
        public int estimateLength() {
            return 4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.mField));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            if (value < 100) {
                FastDatePrinter.access$000(buffer, value);
                return;
            }
            FastDatePrinter.access$100((Appendable)var1_1, (int)var2_2, 1);
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        /*
         * WARNING - void declaration
         */
        TextField(int field, String[] values) {
            void var2_2;
            void var1_1;
            this.mField = var1_1;
            this.mValues = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int estimateLength() {
            void var1_1;
            int max = 0;
            int i = this.mValues.length;
            while (--i >= 0) {
                void var3_3;
                int len = this.mValues[i].length();
                if (len <= max) continue;
                max = var3_3;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            buffer.append(this.mValues[var2_2.get(this.mField)]);
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        /*
         * WARNING - void declaration
         */
        StringLiteral(String value) {
            void var1_1;
            this.mValue = var1_1;
        }

        @Override
        public int estimateLength() {
            return this.mValue.length();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.mValue);
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        /*
         * WARNING - void declaration
         */
        CharacterLiteral(char value) {
            void var1_1;
            this.mValue = var1_1;
        }

        @Override
        public int estimateLength() {
            return 1;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.mValue);
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(Appendable var1, int var2) throws IOException;
    }

    private static interface Rule {
        public int estimateLength();

        public void appendTo(Appendable var1, Calendar var2) throws IOException;
    }
}

