/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import java.time.DayOfWeek;

public enum Week {
    SUNDAY(1),
    MONDAY(2),
    TUESDAY(3),
    WEDNESDAY(4),
    THURSDAY(5),
    FRIDAY(6),
    SATURDAY(7);

    private static final String[] ALIASES;
    private static final Week[] ENUMS;
    private final int value;

    /*
     * WARNING - void declaration
     */
    private Week(int value) {
        void var3_3;
        this.value = var3_3;
    }

    public final int getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final int getIso8601Value() {
        void var1_1;
        int iso8601IntValue = this.getValue() - 1;
        if (iso8601IntValue == 0) {
            iso8601IntValue = 7;
        }
        return (int)var1_1;
    }

    public final String toChinese() {
        return this.toChinese("\u661f\u671f");
    }

    /*
     * WARNING - void declaration
     */
    public final String toChinese(String weekNamePre) {
        switch (this) {
            case SUNDAY: {
                return weekNamePre + "\u65e5";
            }
            case MONDAY: {
                return weekNamePre + "\u4e00";
            }
            case TUESDAY: {
                return weekNamePre + "\u4e8c";
            }
            case WEDNESDAY: {
                return weekNamePre + "\u4e09";
            }
            case THURSDAY: {
                return weekNamePre + "\u56db";
            }
            case FRIDAY: {
                return weekNamePre + "\u4e94";
            }
            case SATURDAY: {
                void var1_1;
                return (String)var1_1 + "\u516d";
            }
        }
        return null;
    }

    public final DayOfWeek toJdkDayOfWeek() {
        return DayOfWeek.of(this.getIso8601Value());
    }

    public static Week of(int calendarWeekIntValue) {
        int n;
        if (calendarWeekIntValue > ENUMS.length || calendarWeekIntValue <= 0) {
            return null;
        }
        return ENUMS[n - 1];
    }

    /*
     * WARNING - void declaration
     */
    public static Week of(String name) throws IllegalArgumentException {
        void var1_1;
        Assert.notBlank(name);
        Week of = Week.of(ArrayUtil.indexOfIgnoreCase(ALIASES, name) + 1);
        if (of == null) {
            String string;
            of = Week.valueOf(string.toUpperCase());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Week of(DayOfWeek dayOfWeek) {
        void var0_1;
        Assert.notNull(dayOfWeek);
        int week = dayOfWeek.getValue() + 1;
        if (8 == week) {
            week = 1;
        }
        return Week.of((int)var0_1);
    }

    static {
        ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        ENUMS = Week.values();
    }
}

