/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.TemporalUtil;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.util.StrUtil;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

public class TemporalAccessorUtil
extends TemporalUtil {
    /*
     * WARNING - void declaration
     */
    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        void var1_1;
        if (temporalAccessor.isSupported(field)) {
            TemporalAccessor temporalAccessor2;
            return temporalAccessor2.get(field);
        }
        return (int)var1_1.range().getMinimum();
    }

    /*
     * WARNING - void declaration
     */
    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (time == null) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (formatter == null) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            void var2_2;
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                TemporalAccessor temporalAccessor;
                void var1_1;
                return var1_1.format(((Instant)temporalAccessor).atZone(ZoneId.systemDefault()));
            }
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String format(TemporalAccessor time, String format) {
        void var1_1;
        TemporalAccessor temporalAccessor;
        if (time == null) {
            return null;
        }
        if (time instanceof DayOfWeek || time instanceof Month || time instanceof Era || time instanceof MonthDay) {
            return time.toString();
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return GlobalCustomFormat.format(time, (CharSequence)format);
        }
        DateTimeFormatter formatter = StrUtil.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return TemporalAccessorUtil.format(temporalAccessor, (DateTimeFormatter)var1_1);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        TemporalAccessor temporalAccessor2;
        if (temporalAccessor instanceof Month) {
            return ((Month)temporalAccessor).getValue();
        }
        if (temporalAccessor instanceof DayOfWeek) {
            return ((DayOfWeek)temporalAccessor).getValue();
        }
        if (temporalAccessor instanceof Era) {
            return ((Era)temporalAccessor).getValue();
        }
        return TemporalAccessorUtil.toInstant(temporalAccessor2).toEpochMilli();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        TemporalAccessor temporalAccessor2;
        TemporalAccessor result;
        if (temporalAccessor == null) {
            return null;
        }
        result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (result instanceof LocalDateTime ? ((LocalDateTime)result).atZone(ZoneId.systemDefault()).toInstant() : (result instanceof ZonedDateTime ? ((ZonedDateTime)result).toInstant() : (result instanceof OffsetDateTime ? ((OffsetDateTime)result).toInstant() : (result instanceof LocalDate ? ((LocalDate)result).atStartOfDay(ZoneId.systemDefault()).toInstant() : (result instanceof LocalTime ? ((LocalTime)result).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (result instanceof OffsetTime ? ((OffsetTime)result).atDate(LocalDate.now()).toInstant() : TemporalAccessorUtil.toInstant(LocalDateTimeUtil.of(result))))))));
        return temporalAccessor2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate) {
        void var2_2;
        void var1_1;
        return TemporalAccessorUtil.isIn(date, (TemporalAccessor)var1_1, (TemporalAccessor)var2_2, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate, boolean includeBegin, boolean includeEnd) {
        void var0_1;
        void var3_4;
        void var2_3;
        void var1_2;
        if (date == null || beginDate == null || endDate == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3anull");
        }
        long thisMills = TemporalAccessorUtil.toEpochMilli(date);
        long beginMills = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)var1_2);
        long endMills = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)var2_3);
        long rangeMin = Math.min(beginMills, endMills);
        long rangeMax = Math.max(beginMills, endMills);
        boolean isIn = rangeMin < thisMills && thisMills < rangeMax;
        if (!isIn && var3_4 != false) {
            boolean bl = isIn = thisMills == rangeMin;
        }
        if (!isIn && includeEnd) {
            isIn = thisMills == rangeMax;
        }
        return (boolean)var0_1;
    }
}

