/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final String id;
    private List<TaskInfo> taskList;
    private String currentTaskName;
    private long startTimeNanos;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeNanos;

    public static StopWatch create(String id) {
        String string;
        return new StopWatch(string);
    }

    public StopWatch() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public StopWatch(String id) {
        this((String)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StopWatch(String id, boolean keepTaskList) {
        void var2_2;
        void var1_1;
        this.id = var1_1;
        if (var2_2 != false) {
            this.taskList = new ArrayList<TaskInfo>();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        if (keepTaskList) {
            if (this.taskList == null) {
                this.taskList = new ArrayList<TaskInfo>();
                return;
            }
        } else {
            this.taskList = null;
        }
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    /*
     * WARNING - void declaration
     */
    public void start(String taskName) throws IllegalStateException {
        void var1_1;
        if (this.currentTaskName != null) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.currentTaskName = var1_1;
        this.startTimeNanos = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    public void stop() throws IllegalStateException {
        void var1_1;
        if (this.currentTaskName == null) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTime = System.nanoTime() - this.startTimeNanos;
        this.totalTimeNanos += lastTime;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, (long)var1_1);
        if (this.taskList != null) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeNanos() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeNanos();
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotal(TimeUnit unit) {
        return unit.convert(this.totalTimeNanos, TimeUnit.NANOSECONDS);
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return this.getTotal(TimeUnit.MILLISECONDS);
    }

    public double getTotalTimeSeconds() {
        return DateUtil.nanosToSeconds(this.totalTimeNanos);
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (this.taskList == null) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public String shortSummary() {
        return this.shortSummary(null);
    }

    /*
     * WARNING - void declaration
     */
    public String shortSummary(TimeUnit unit) {
        void var1_1;
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        return StrUtil.format("StopWatch '{}': running time = {} {}", this.id, this.getTotal(unit), DateUtil.getShotName((TimeUnit)var1_1));
    }

    public String prettyPrint() {
        return this.prettyPrint(null);
    }

    /*
     * WARNING - void declaration
     */
    public String prettyPrint(TimeUnit unit) {
        void var2_2;
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        StringBuilder sb = new StringBuilder(this.shortSummary(unit));
        sb.append(FileUtil.getLineSeparator());
        if (this.taskList == null) {
            sb.append("No task info kept");
        } else {
            sb.append("---------------------------------------------").append(FileUtil.getLineSeparator());
            sb.append(DateUtil.getShotName(unit)).append("         %     Task name").append(FileUtil.getLineSeparator());
            sb.append("---------------------------------------------").append(FileUtil.getLineSeparator());
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(9);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(2);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append(nf.format(task.getTime(unit))).append("  ");
                sb.append(pf.format((double)task.getTimeNanos() / (double)this.getTotalTimeNanos())).append("   ");
                sb.append(task.getTaskName()).append(FileUtil.getLineSeparator());
            }
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(this.shortSummary());
        if (this.taskList != null) {
            for (TaskInfo task : this.taskList) {
                void var3_3;
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeNanos()).append(" ns");
                long percent = Math.round(100.0 * (double)var3_3.getTimeNanos() / (double)this.getTotalTimeNanos());
                sb.append(" = ").append(percent).append("%");
            }
        } else {
            sb.append("; no task info kept");
        }
        return var1_1.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeNanos;

        /*
         * WARNING - void declaration
         */
        TaskInfo(String taskName, long timeNanos) {
            void var2_2;
            void var1_1;
            this.taskName = var1_1;
            this.timeNanos = var2_2;
        }

        public final String getTaskName() {
            return this.taskName;
        }

        public final long getTime(TimeUnit unit) {
            return unit.convert(this.timeNanos, TimeUnit.NANOSECONDS);
        }

        public final long getTimeNanos() {
            return this.timeNanos;
        }

        public final long getTimeMillis() {
            return this.getTime(TimeUnit.MILLISECONDS);
        }

        public final double getTimeSeconds() {
            return DateUtil.nanosToSeconds(this.timeNanos);
        }
    }
}

